use 5.006;
use strict;
use warnings FATAL => 'all';
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  NAME       => 'OpenAPI::Generator',
  AUTHOR       => q{Anton Fedotov <tosha.fedotov.2000@gmail.com>},
  VERSION_FROM   => 'lib/OpenAPI/Generator.pm',
  ABSTRACT_FROM  => 'lib/OpenAPI/Generator.pm',
  LICENSE      => 'artistic_2',
  MIN_PERL_VERSION => '5.012',
  CONFIGURE_REQUIRES => {
    'ExtUtils::MakeMaker' => '0',
  },
  TEST_REQUIRES => {
    'Test::More' => '0',
  },
  PREREQ_PM => {
    'Carp'                    => '1.52',
    'Exporter'                => '5.76',
    'File::Find'              => '1.39',
    'JSON::PP'                => '4.06',
    'Pod::Simple::SimpleTree' => '3.42',
    'YAML'                    => '1.30',
    'constant'                => '1.33',
    'feature'                 => '1.63',
    'strict'                  => '1.12',
    'warnings'                => '1.51',
  },
  dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
  clean => { FILES => 'OpenAPI-Generator-*' },
);

# Compatibility with old versions of ExtUtils::MakeMaker
unless (eval { ExtUtils::MakeMaker->VERSION('6.64'); 1 }) {
  my $test_requires = delete $WriteMakefileArgs{TEST_REQUIRES} || {};
  @{$WriteMakefileArgs{PREREQ_PM}}{keys %$test_requires} = values %$test_requires;
}

unless (eval { ExtUtils::MakeMaker->VERSION('6.55_03'); 1 }) {
  my $build_requires = delete $WriteMakefileArgs{BUILD_REQUIRES} || {};
  @{$WriteMakefileArgs{PREREQ_PM}}{keys %$build_requires} = values %$build_requires;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION('6.52'); 1 };
delete $WriteMakefileArgs{MIN_PERL_VERSION}
  unless eval { ExtUtils::MakeMaker->VERSION('6.48'); 1 };
delete $WriteMakefileArgs{LICENSE}
  unless eval { ExtUtils::MakeMaker->VERSION('6.31'); 1 };

WriteMakefile(%WriteMakefileArgs);
