package Microsoft::AdCenter::V8::ReportingService::AccountPerformanceReportColumn;
# Copyright (C) 2011 Xerxes Tsang
# This program is free software; you can redistribute it and/or modify it
# under the terms of Perl Artistic License.

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::V8::ReportingService::AccountPerformanceReportColumn - Represents "AccountPerformanceReportColumn" in Microsoft AdCenter Reporting Service.

=head1 SYNOPSIS

See L<http://msdn.microsoft.com/en-us/library/ee730327.aspx> for documentation of the various data objects.

=head1 ENUMERATION VALUES

    AccountName
    AccountNumber
    AdDistribution
    AverageCpc
    AverageCpm
    AveragePosition
    Clicks
    ConversionRate
    Conversions
    CostPerConversion
    Ctr
    CurrencyCode
    DeviceType
    Impressions
    LowQualityClicks
    LowQualityClicksPercent
    LowQualityConversionRate
    LowQualityConversions
    LowQualityImpressions
    LowQualityImpressionsPercent
    Spend
    TimePeriod

=cut

sub AccountName {
    return 'AccountName';
}

sub AccountNumber {
    return 'AccountNumber';
}

sub AdDistribution {
    return 'AdDistribution';
}

sub AverageCpc {
    return 'AverageCpc';
}

sub AverageCpm {
    return 'AverageCpm';
}

sub AveragePosition {
    return 'AveragePosition';
}

sub Clicks {
    return 'Clicks';
}

sub ConversionRate {
    return 'ConversionRate';
}

sub Conversions {
    return 'Conversions';
}

sub CostPerConversion {
    return 'CostPerConversion';
}

sub Ctr {
    return 'Ctr';
}

sub CurrencyCode {
    return 'CurrencyCode';
}

sub DeviceType {
    return 'DeviceType';
}

sub Impressions {
    return 'Impressions';
}

sub LowQualityClicks {
    return 'LowQualityClicks';
}

sub LowQualityClicksPercent {
    return 'LowQualityClicksPercent';
}

sub LowQualityConversionRate {
    return 'LowQualityConversionRate';
}

sub LowQualityConversions {
    return 'LowQualityConversions';
}

sub LowQualityImpressions {
    return 'LowQualityImpressions';
}

sub LowQualityImpressionsPercent {
    return 'LowQualityImpressionsPercent';
}

sub Spend {
    return 'Spend';
}

sub TimePeriod {
    return 'TimePeriod';
}

1;
