package ICU::Unicode;
#
#    Unicode.pm
#
#    $Id: Unicode.pm,v 1.3 2001/02/11 03:27:53 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

use strict;
use Carp;
use vars qw(@ISA %EXPORT_TAGS $AUTOLOAD);

use Exporter;
@ISA = qw(Exporter);

use ICU;

%EXPORT_TAGS = (

    EUnicodeEnums => [qw( 
        &MIN_VALUE &MAX_VALUE &MAX_CHAR_LENGTH &MIN_RADIX &MAX_RADIX
    )],

    EUnicodeScriptGenericTypes => [qw( 
        &COMBINING_SPACING_MARK &CONNECTOR_PUNCTUATION &CONTROL
        &CURRENCY_SYMBOL &DASH_PUNCTUATION &DECIMAL_DIGIT_NUMBER
        &ENCLOSING_MARK &END_PUNCTUATION &FINAL_PUNCTUATION &FORMAT
        &GENERAL_TYPES_COUNT &INITIAL_PUNCTUATION &LETTER_NUMBER
        &LINE_SEPARATOR &LOWERCASE_LETTER &MATH_SYMBOL &MODIFIER_LETTER
        &MODIFIER_SYMBOL &NON_SPACING_MARK &OTHER_LETTER &OTHER_NUMBER
        &OTHER_PUNCTUATION &OTHER_SYMBOL &PARAGRAPH_SEPARATOR 
        &PRIVATE_USE &SPACE_SEPARATOR &START_PUNCTUATION &SURROGATE 
        &TITLECASE_LETTER &UNASSIGNED &UPPERCASE_LETTER
    )],

    EUnicodeScript => [qw( 
        &kAlphabeticPresentation &kArabic &kArabicPresentationA
        &kArabicPresentationB &kArmenian &kArrow &kBasicLatin &kBengali
        &kBlockElement &kBopomofo &kBoxDrawing &kCJKCompatibility
        &kCJKCompatibilityForm &kCJKCompatibilityIdeograph
        &kCJKSymbolPunctuation &kCJKUnifiedIdeograph
        &kCJKUnifiedIdeographExtensionA
        &kCombiningDiacritical &kCombiningHalfMark &kControlPicture
        &kCurrencySymbolScript &kCyrillic &kDevanagari &kDingbat
        &kEnclosedAlphanumeric &kEnclosedCJKLetterMonth
        &kGeneralPunctuation &kGeometricShape &kGeorgian &kGreek
        &kGreekExtended &kGujarati &kGurmukhi &kHalfwidthFullwidthForm
        &kHangulCompatibilityJamo &kHangulJamo &kHangulSyllable &kHebrew
        &kHighPrivateUseSurrogate &kHighSurrogate &kHiragana
        &kIPAExtension &kIdeographicDescriptionCharacters &kKanbun 
        &kKangxiRadicals &kKannada &kKatakana &kLao &kLatin1Supplement
        &kLatinExtendedA &kLatinExtendedAdditional &kLatinExtendedB
        &kLetterlikeSymbol &kLowSurrogate &kMalayalam &kMathOperator
        &kMiscSymbol &kMiscTechnical &kNoScript &kNumberForm
        &kOpticalCharacter &kOriya &kPrivateUse &kScriptCount 
        &kSmallFormVariant &kSpacingModifier &kSuperSubScript
        &kSymbolCombiningMark &kTamil &kTelugu &kThai &kTibetan
        &kYiRadicals &kYiSyllables
    )],

    EDirectionProperty => [qw( 
        &ARABIC_NUMBER &BLOCK_SEPARATOR &BOUNDARY_NEUTRAL
        &COMMON_NUMBER_SEPARATOR &DIR_NON_SPACING_MARK &EUROPEAN_NUMBER
        &EUROPEAN_NUMBER_SEPARATOR &EUROPEAN_NUMBER_TERMINATOR
        &LEFT_TO_RIGHT &LEFT_TO_RIGHT_EMBEDDING &LEFT_TO_RIGHT_OVERRIDE
        &OTHER_NEUTRAL &POP_DIRECTIONAL_FORMAT &RIGHT_TO_LEFT
        &RIGHT_TO_LEFT_ARABIC &RIGHT_TO_LEFT_EMBEDDING
        &RIGHT_TO_LEFT_OVERRIDE &SEGMENT_SEPARATOR &WHITE_SPACE_NEUTRAL
    )],

    ECellWidths => [qw( 
        &ZERO_WIDTH &HALF_WIDTH &FULL_WIDTH NEUTRAL
    )],

);

Exporter::export_tags();

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    #print "\@_ = (".join(')(',@_).") " .__FILE__.' '.__LINE__."\n";
    #print "\$AUTOLOAD = ($AUTOLOAD) " .__FILE__.' '.__LINE__."\n";
    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant_iv($constname, @_ ? $_[0] : 0);
    if ($! != 0) { 
        if ($! =~ /Invalid/) {
            $AutoLoader::AUTOLOAD = $AUTOLOAD;
            goto &AutoLoader::AUTOLOAD;
        }
        else {
                croak "Your vendor has not defined ICU::Unicode macro $constname";
        }
    }
    no strict 'refs';
    *$AUTOLOAD = sub { $val };
    goto &$AUTOLOAD;
}

1;

__END__

=head1 NAME

ICU::Unicode - Perl extension for International Components for Unicode
               Character Properties

=head1 SYNOPSIS

  use ICU::Unicode;

=head1 DESCRIPTION

TBD

