# Generated by default/object.tt
package Paws::IoTEvents::AlarmCapabilities;
  use Moose;
  has AcknowledgeFlow => (is => 'ro', isa => 'Paws::IoTEvents::AcknowledgeFlow', request_name => 'acknowledgeFlow', traits => ['NameInRequest']);
  has InitializationConfiguration => (is => 'ro', isa => 'Paws::IoTEvents::InitializationConfiguration', request_name => 'initializationConfiguration', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::AlarmCapabilities

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::AlarmCapabilities object:

  $service_obj->Method(Att1 => { AcknowledgeFlow => $value, ..., InitializationConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::AlarmCapabilities object:

  $result = $service_obj->Method(...);
  $result->Att1->AcknowledgeFlow

=head1 DESCRIPTION

Contains the configuration information of alarm state changes.

=head1 ATTRIBUTES


=head2 AcknowledgeFlow => L<Paws::IoTEvents::AcknowledgeFlow>

Specifies whether to get notified for alarm state changes.


=head2 InitializationConfiguration => L<Paws::IoTEvents::InitializationConfiguration>

Specifies the default alarm state. The configuration applies to all
alarms that were created based on this alarm model.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

