#!/usr/bin/perl

package eBay::API::XML::DataType::ProductRecommendationsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ProductRecommendationsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ProductRecommendationsType

=head1 DESCRIPTION

A list of products returned from the Suggested Attributes engine.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ProductRecommendationsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ProductInfoType;


my @gaProperties = ( [ 'Product', 'ns:ProductInfoType', '1'
	     ,'eBay::API::XML::DataType::ProductInfoType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setProduct()

A suggested product to use to list an item with Pre-filled Item Information.
Returned from GetItemRecommendations when the Suggested Attributes engine is used
See the Developer's Guide for additional details.

#    Argument: reference to an array  
                      of 'ns:ProductInfoType'

=cut

sub setProduct {
  my $self = shift;
  $self->{'Product'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getProduct()

  Calls: GetItemRecommendations
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:ProductInfoType'

=cut

sub getProduct {
  my $self = shift;
  return $self->_getDataTypeArray('Product');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
