/*
 * cs.c
 * ----
 * Shows checksums of a list of tfm and/or pk files.
 */

#include <stdio.h>
#include "checksum.h"

#ifdef __STDC__
void	usage(char *);
#else
void	usage();
#endif

main(argc, argv) int argc; char *argv[]; {
   int i, cs_o; long cs;

   if (argc<2) {
      usage(argv[0]);
      exit(1);
   }

   for (i=1; i<argc; i++) {
       switch (readfile(argv[i], &cs)) {
       case NOERROR:
	  cs_o = cs;
	  if (cs_o < 0) { cs_o+=2<<31; cs_o+=2<<31; }
          printf("%s:%12lo (8)%12ld (10)\n", argv[i], cs_o, cs);
          break;
       case NOFILE:
          fprintf(stderr, "%s: no such file\n", argv[i]); break;
       case WRONGTFMFILE:
          fprintf(stderr, "%s: wrong tfm-file\n", argv[i]); break;
       case WRONGPKFILE:
          fprintf(stderr, "%s: wrong pk-file file\n", argv[i]); break;
       case NOTFMORPK:
          fprintf(stderr, "%s: no tfm or pk-file\n", argv[i]); break;
       }
   }
}

void usage(myname)
char * myname;
{
   printf("Usage: %s tfm-or-pkfile . . .\n", myname);
}

