/*
  Copyright (C) 1989      Fung F. Lee

  hz2sgb: convert a HZ file into a Macintosh/CCDOS SGB file.

  This program is free for general distribution.  

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/

#include <stdio.h>

#define true 1
#define false 0
#define notAscii(c)	((c)&0x80)
#define isGB(c)		((c)>=0x21 && (c)<=0x7E)
#define DB(hi,lo)	(((hi)&0xFF) << 8 | (lo)&0xFF)

int LF2CR=false;	/* flag for converting ASCII <LF> to <CR> */

main(argc, argv)
     int argc;
     char *argv[];
{
  LF2CR = (argc==2 && argv[1][0]=='-' && argv[1][1]=='n');
  filter(stdin, stdout);
}


filter(fin, fout)
     FILE *fin, *fout;
{
  int c1, c2, c3, c4, code;
  int GBmode = false;
  
  while ((c1=fgetc(fin)) != EOF)
    {
      if (GBmode)
	{
	  c2 = fgetc(fin);
	  GBrange(c1, c2);
	  code = DB(c1, c2);
	  switch (code)
	    {
	    case 0x7E7D: /* DB('~','}') */
	      GBmode = false; break;
	    default:
#ifdef MAC
	      gb2mac(c1, c2, &c3, &c4);
#endif
#ifdef DOS
	      gb2dos(c1, c2, &c3, &c4);
#endif
	      fputc(c3, fout);
	      fputc(c4, fout);
	      break;
	    }
	}
      /* not in GBmode */
      else if (notAscii(c1))
	fprintf(stderr, "unexpected non-ASCII char: %2x\n", c1);
      /* optional error recovery: ignore this byte */
      else if (c1 == '~')
	{
	  c2 = fgetc(fin);
	  switch (c2)
	    {
	    case '~': fputc('~', fout); break;
	    case '{': GBmode = true; break;
	    case '\n': break;	/* line-continuation marker */
	    default:  
	      fprintf(stderr, "unexpected escape sequence: ~%c\n", c2);
	      /* optional error recovery: */
	      fputc('~', fout); ungetc(c2, fin);
	      break;
	    }
	}
      else
	{
	  if (LF2CR && c1=='\n') c1 = '\r';
	  fputc(c1, fout);
	}
    }
}


GBrange(hi, lo)
int hi, lo;
{
  if (!isGB(hi) || !isGB(lo))
    {
      fprintf(stderr, "GB code out of range: %c%c (hex: %2x%2x)\n",
	      hi, lo, hi, lo);
      exit(1);
    }
}

#ifdef MAC
gb2mac(hi, lo, hi1, lo1)
     int hi, lo, *hi1, *lo1;
{
  *hi1 = 0x81 + (hi - 0x21)/2;
  if (hi%2 != 0)
    {
      *lo1 = 0x40 + (lo - 0x21);
      if (*lo1 >= 0x7F) *lo1 += 1;
    }
  else
    *lo1 = 0x9F + (lo - 0x21);
}
#endif


#ifdef DOS
gb2dos(hi, lo, hi1, lo1)
     int hi, lo, *hi1, *lo1;
{
  *hi1 = 0x80 + hi;
  *lo1 = 0x80 + lo;
}
#endif
