#ifndef _ptrie_h
#define _ptrie_h

typedef void *ptrie;

#ifdef __STDC__

ptrie ptrie_create(void);
void ptrie_free(ptrie, void (*)(void *));
void ptrie_insert(ptrie, unsigned char *, void *);
void *ptrie_find(ptrie, unsigned char *);
void ptrie_walk(ptrie, void *, void (*)(void *, void *))

#else /* !__STDC__ */

ptrie ptrie_create(/* */);
void ptrie_free(/* ptrie root, void (*free_func)(void *data) */);
void ptrie_insert(/* ptrie root, unsigned char *key, void *data */);
void *ptrie_find(/* ptrie root, unsigned char *key */);
void ptrie_walk(/* ptrie root, void *user_data,
                   void (*action_func)(void *u_data, void *node_data) */);
#endif /* !__STDC__ */

#endif /* _ptrie_h */
