h45318
s 00121/00017/01764
d R 6.1 91/12/09 22:39:31 root 5 4
c (1) Fixed bug where 'c'c & 's' in Hebrew mode reversed English strings.  
c (2) Fixed bug where if you typed ^X while editing in a 'c' command, vi.iv might  
c     append the contents of another line to the current line.  
c (3) Preserve & recover now work with vi.iv.
e
s 00353/00027/01428
d D 5.1 90/04/24 14:33:34 haim 4 3
c (1) 'c & 's commands no longer reverse English strings while in Hebrew mode.
c *** CHANGED *** 91/12/09 20:59:36 haim
c (1) Fixed bug where directions of secondary language strings would
c be reversed if cancelled a command sequence (e.g., 'c', 'd', 'y').
c [function operate in ex_voper.c]
c (2) Fixed bug where substitute command would sometimes result in a
c segmentation fault.  [function subschang in ex_re.c]
c (3) Added other checks for null pointers [especially in ex_RL.c]
e
s 00000/00000/01455
d D 4.1 90/02/09 09:58:30 haim 3 2
c (1) created new termcap definitions vt100iv & suniv. Renamed the old
c termcap defintion to vi100iv.
c (2) Added use of TERMIV, EXINITIV, & .exrciv.
c *** CHANGED *** 90/02/09 10:23:30 haim
c (1) created new termcap definitions vt100iv & suniv. Renamed the old
e
s 00039/00003/01416
d D 3.1 90/01/01 14:15:37 haim 2 1
c Fixed the following bugs: [1] echoing previous lines during insert
c mode, [2] cursor stuck in corner when inserting LR text in RL view,
c [3] prints "ERROR" instead of correct messages.
c Also deleted unused entries from termcap.
e
s 01419/00000/00000
d D 2.1 89/12/27 12:03:42 haim 1 0
c First version installed on the Technion Computer Science Faculty 
c (TCSF) CS network.  usuable, but has some bugs, the worst of which 
c is that in insert mode, when you start a new line, previous lines 
c are echoed on that new line.  Installed by Haim Roman 11/1989.
c *** CHANGED *** 89/12/27 12:09:49 haim
c First version installed on the Technion Computer Science Faculty 
c (TCSF) CS network.  usuable, but has some bugs, the worst of which 
c is that in insert mode, when you start a new line, previous lines 
c are echoed on that new line.  Installed by Haim Roman 11/1989.
c *** CHANGED *** 89/12/27 12:03:48 haim
c date and time created 89/12/27 12:03:42 by haim
e
u
U
f e 0
t
T
I 1
/*===============================================================
 * FILE: ex_RL.c		RIGHT-TO-LEFT LANGUAGE ROUTINES
 * ----------------------------------------------------------------
 * EDIT HISTORY:
I 2
 *
 * 29/12/89		HAIM ROMAN, COMPUTER SCIENCE DEPT., TECHNION
 * (1) See selbuf.  This change to fix bug of displaying previous
 * lines during insert mode.
 * (2) added comments.
E 2
 * 
 * 10/1989		HAIM ROMAN, COMPUTER SCIENCE DEPT., TECHNION
 * (1) added comments
 * 
 * ??/198?		URI HABASHA, COMPUTER SCIENCE DEPT., TECHNION
 * Created this file
 * -----------------------------------------------------------------
 * DESCRIPTION:
 * 
 *     The file consists of subrutines that were written for vi.iv .
 *     vi.iv is an extended vesion of vi into a two-direction word  
 *  processor that enables writing documents using different kinds
 *  of languages and also enables editing documents written from
 *  right to left and from left to right.
 *	Most of the changes were done on the vi files themselves so
 *  as to preserve the basic form of working with the vi, and to allow
 *  the user to work on a better processor with as little new commands
 *  for him to learn as possible.
 *	This file contains independent procedures which were needed to
 *  make the adjusment between the format of the information in the file
 *  and the vi format, and also all the functions that were needed for
 *  the terminal and its adjustment to the different modes.
 *	vi.iv is independent of the terminal and can be used on every
 *  terminal defined in termcap, but it is important to notice that
 *  for terminals that do not allow changing cursor moves from right
 *  to left, the program is slower and much more primitive.
I 4
 * -----------------------------------------------------------------
 * OTHER NOTES:
 *
 * NULL POINTERS -- I added checks for null pointers.  In deciding how 
 * to respond to a pointer being null, I tried to determine if the function
 * would work if the pointer pointed to a null string.  If so, I treated
 * the pointer as if it pointed to a null string.  Otherwise, I printed
 * the error message & returned from the function.  In no case did I
 * abort the program.	[Haim Roman, 12/03/90] 
E 4
 * ================================================================
 */

/*=================================================================
 *  DATA DECLARATIONS
 *  ==================================================================
 */

#include "ex.h"
#include "ex_vis.h"
#include "ex_tty.h"
#include "ex_RL.h"
#include <sys/ioctl.h>

/*
 * convLR:	index: 0 = Aleph, 1 = Bet, 2 = Gimmel, etc.
 *		value = Latin character generated by the same keyboard key
 */
char convLR[27] = {
			't','c','d','s','v','u','z','j','y','h','l','f',
			'k','o','n','i','b','x','g',';','p','.','m','e',
			'r','a',','
};

/*
 * convRL:	index: 0 = `, 1 = A, 2 = B, etc.
 *		value = ASCII code (minus octal 200) of Hebrew
 *		  character generated by the same key
 */
char convRL[27] = {
			'/','y','p','a','b','w','k','r','i','o','g','l',
			'j','v','n','m','t','Q','x','c','`','e','d','\'',
			'q','h','f'
};

bool underline = 0;
#define ternum 250
struct terch {
	short	typedir;
	char	ch;
}typech[ternum];
int	inpoint = 0, outpoint = 0, mone = 0;
char * shcurs;

/*=====================================================================
 * FUNCTIONS
 *====================================================================
 */

/*
 *	rlcount - Computes the number of places taken by the character.
 *  This is needed for the use of 'tab' in which the number of pleces
 *  is independent of the distance from the cursor to the nearest 
 *  'tabstop'.
 *
 *  (NOTE: maybe instead of "independent of the distance",he means
 *  "dependent on the distance" -- Haim Roman)
 */
short
rlcount(c, col)
	register int c;
{

	if ((c & TRIM) == '\t') 
		if (RL_letter(c) == Mdirect)
			return(value(TABSTOP) - col % value(TABSTOP));
		else
			return(value(TABSTOP));
	return(1);
}

/*---------------------------------------------------------------
 * cntendlin -- count to end of line
 *
 *	NOTE -- this prologue might be incomplete.
 *
 * DESCRIPTION:
 * ------------
 *  Gets the line and breaks it to pieces according
 *  to the line width allowed by the terminal.  This is needed for 
 *  lines containing of secondary language because of the
 *  transformation from sheff-format to screen-format .
 *
 * VALUE RETURNED BY FUNCTION:
 * ---------------------------
 * pointer to character in the string that begins the next line
 *
 * FUNCTION PARAMETERS:
 * --------------------
 * cp (in) -- pointer to string to put on the current line.
 * flag (in/out) -- true = start a new line on the terminal, even if
 *	there is room on the current one.  This will always be set to 
 *	false by the function.
 *
 * EXTERNAL VARIABLES: 
 * -------------------
 *	This list might not be complete.  In particular, it might not
 *	contain all external variables referenced by the functions
 *	that this function calls.
 *
 * Pline (in) -- pointer to the function used to put a line on the
 *	screen.
 * WCOLS (in) -- total number of columns on the terminal.
 *
 *-------------------------------------------------------------------
 */
char		*
cntendlin(cp, flag)
	register char *cp;
	register bool *flag;
{
	/* vcntcol keeps track of which column of the terminal we are on */
	static int vcntcol;
I 4

	/* If 'flag' is a null pointer, that indicates a bug that this 
	 * function cannot fix.  However, I don't think it happens.
	 * [Haim Roman, 12/03/90]
	 */
	if (flag == NULL) {
		error ("Bug in routine cntendlin: argument 'flag' is null pointer");
		return (NULL);
	}
E 4
	
	/*
	 * determine which column on the terminal the string starts
	 * on.  If 'flag' is true, then this will be the 1st column (or,
	 * if displaying line numbers, the 1st column after the
	 * number).  If flag is false, we start from where we left off.
	 */
	if  (*flag && (Pline == numbline)){ /* new line, show numbers */
		*flag = 0;
		vcntcol = 8;
	} else
		if (*flag){		   /* new line, no numbers */
			*flag = 0;
			vcntcol = 0;
		} else			   /* continue on old line */
			vcntcol %= WCOLS;

I 4
	/* if 'cp' is a null pointer, act as if it were an empty string. 
	 * [Haim Roman 12/03/90]
	 */
	if (cp == NULL) return (cp);

E 4
	/*
	 * count off characters until either hit a null, newline, or  
	 * the last column on the terminal.  "rlcount" takes tabs into
	 * account when counting columns.
	 */
	while (vcntcol < WCOLS && *cp && ((*cp & TRIM) != '\n'))
		vcntcol += rlcount(*cp++, vcntcol);
	
	return(cp);
}


/*
D 4
 *	next_lang - Provides the place in the line where the language 
 *  is changed from secondary to main.
E 4
I 4
 * next_lang - Points to the last char of the desired language in the current
 *	block of text.  Often used to point to
 *	the next place in the line where the language changes.
 *
 * FUNCTION ARGUMENTS:
 * -------------------
 * cp (in) -- points to character in the line from which to start
 *	looking.
 * hp (in) -- points to the last character to look at.  We will not
 *	search past this character.
 * kind (in) -- the language we want.  Possible values are LR & RL.
 *	Next_lang finds the last char of this language.
 *
 * VALUE RETURNED BY THE FUNCTION:
 * -------------------------------
 * pointer to character of the desired language (immediately before the
 * string changes to the other language.
 * If there is no such
 * block, it returns the value of 'hp'.
E 4
 */
char           *
next_lang(cp, hp, kind)
	register char  *cp, *hp;
	register bool kind;

{
	int d;

I 4
	/* check for null pointer.  [Haim Roman, 12/03/90] */
	if (cp == NULL ) {
		error ("Bug in function next_lang: cp is a null pointer");
		return (NULL);
	}

E 4
	d = *cp;
	while (hp > cp && ((RL_letter(d)) == kind)) {
		cp++;
		d = *cp;
	}
	return (--cp);
}

/*---------------------------------------------------------------
 * changseclan -- change the order of the second language
 *
 *	NOTE -- this prologue might be incomplete.
 *
 * DESCRIPTION:
 * ------------
 *  Changes the format from sheff-format to
 *  screen-format.  As a matter of fact, only the secondary language 
 *  representation is changed.  This is done by breaking the line into
 *  pieces according to line-width.  As long as the letter belonges 
 *  to the main language - it is copied, otherwise - the end of the
 *  secondary language section is being located and copied in a 
 *  reverse mode, i.e. from end to beginning.
 *
 * VALUE RETURNED BY FUNCTION:	none
 * ---------------------------
 *
 * FUNCTION PARAMETERS:
 * --------------------
 * sp (in/out) -- string.  All substrings consisting of the characters
 *	of the 2nd language (i.e., not the main language) have their
 *	order reversed.
 * kind -- main language (values = RL or LR).
 *
 * EXTERNAL VARIABLES:  
 * -------------------
 *	This list might not be complete.  In particular, it might not
 *	contain all external variables referenced by the functions
 *	that this function calls.
 *
 *-------------------------------------------------------------------
 */
changseclan(sp,kind)
	register char  *sp;
	register bool kind;
{
	/*
	 * cp -- pointer to the current char in the temporary buffer
	 * lp -- pointer to the current char in the caller's string
	 * pel -- pointer to last char of the temporary buffer that is
	 *	on the current terminal line.
	 */
	register char  *cp, *lp, *tp, *pel;
	/* register char     hbuf[LBSIZE];	/* temporary buffer */
	char     hbuf[LBSIZE];	/* temporary buffer */
	register int    i;
	bool	first= 1;		/* true = begin on new line */
	int d;				/* value of current char */

I 4
	/* check for null pointer.  [Haim Roman, 12/03/90] */
	if (sp == NULL) return;

E 4
	/* initialize variables */
	lp = sp;
	cp = pel = hbuf;
	CP(hbuf, sp);

	/* loop through all characters in the string */
	while (cp != pel || (*pel && ((*pel & TRIM) != '\n'))) {

		/*
		 * if reached the end of the current line, set pointer
		 * to last character on the next line
		 */
		if (cp == pel)
			pel = cntendlin(pel, &first);

		/*
		 * while the language of the characters match the main
		 * language, preserve the order of the characters.
		 */
		d = *cp;
		for (; cp < pel && ((RL_letter(d)) == kind);
							*lp++ = *cp++, d = *cp);
		/*
		 * If there are more characters to put on this line,
		 * they are NOT in the main language.  Reverse their
		 * order.
		 */
		if (cp < pel) {
			tp = cp;
			cp = next_lang(cp, pel, !kind);
			i = cp - tp + 1;
			for (; cp >= tp; *lp++ = *cp--);
			cp = tp + i;

		/*
		 * Else there are no more characters to put on this
		 * line; exit the function
		 */
		} else
			break;
	}
}

/*
 *	The next two functions were written to allow working with the
 *  8th bit in vi.iv, for indicating the kind of language in which
 *  the letter is written.  In the original vi, the 8th bit was meant
D 4
 *  for passing information.  To prevent 
E 4
I 4
 *  for passing information about characters.
E 4
 *
 *	spechar - Checks if the letter was changed to allow working
 * 		  with the 8th bit.
 *
 *	ascspec - Exchanges between the given letter and the real one.
 */
spechar(c)
	register int    c;
{
	c &= (QUOTE | TRIM);	/* trim to lower order 8 bits */
	switch (c) {
	case BQ:
	case SQ:
	case SQ | QUOTE:
	case BSQ:
	case RQ:
	case NQ:
	case QUOTE:
	case TSL:
		return (1);
	default:
		return (0);
	}
}

I 4
/*-------------------------------------------------------------
 * ascspec -- convert some special characters to other ASCII codes.
 *
 * I think one of the functions of this routine is to make vi 8th bit
 * clean (i.e., save the 8th bit for ESCII character encoding instead
 * of using it for special information).  However, I'm not sure of
 * this.		(Haim Roman 06/03/90)
 *---------------------------------------------------------------
 */
E 4
ascspec(c)
	register int    c;
{
	c &= (QUOTE | TRIM);	/* trim to lower order 8 bits */
	switch (c) {
	case BQ:
		return ('\b');
	case SQ:
	case SQ | QUOTE:
		if (INdirect)
			return (0240);	/* RL space character */
		else
			return(' ');
	case BSQ:
		return ('\\');
	case RQ:
		return ('\r');
	case NQ:
		return ('\n');
	case QUOTE:
		return (c & TRIM);
D 4
/* defalt: */
E 4
	default:
		return (c);
	}
}

/*
 *	setRL - changes the letter to RL 
 */
setRL()
{
	if (DIdirect != INdirect)
		termch();
	DIdirect = RL;
	if (HN)
		newtputs(HN, 0, putch);
}

/*
 *	setLR - changes the letter to LR 
 */
setLR()
{
	if (DIdirect != INdirect)
		termch();
	DIdirect = LR;
	if (HF)
		newtputs(HF, 0, putch);
	else
		chLR = 1;
}

/*
 *	motionRL - changes the cursor direction form right to left
 */
motionRL()
{
	Mdirect = RL;
	if (HE)
		newtputs(HE,0,putch);
}

/*
 *	motionLR - changes the cursor direction form left to right
 */
motionLR()
{
	Mdirect = LR;
	newtputs(EG,0,putch);
}

/*
 *	setmotion - updates the propper variables each time we change 
 *                  the text from RL-text to LR-text and vice-versa.
 *
 *		The parameter "direct" may have as a value either RL
 *		or LR (as defined in ex_RL.h).
 */
setmotion(direct)
	register int    direct;
{
	register int    i;	/* lint says this is unused */

	if (Mdirect == direct)
		return;
	setnumb(value(NUMBER));
	setplod(value(RIGHTLEFT));
/*	changeabb();*/
	INdirect = direct;
	prflag = 0;
	if (direct)
		motionRL();
	else
		motionLR();
}

/*
 * Pdirect print the insert mode direction in the echo area. 
 */


prmsg(bolt, msg)
	bool bolt;
	register char *msg;

{
	register int    sdl = destline, sdc = destcol;
	bool sdontcare;

	sdontcare = dontcare;
	dontcare = 1;
	delunl();
	if (isRLtext)
		fixcurslr();
	splitw++;
	if (WBOT == WECHO && WBOT != 0)
		vmoveitup(1, 1);
	vigoto(WECHO, 0);
	if (bolt && SO && SE)
		putpad(SO);
D 4
	printf("%s ", msg);
E 4
I 4
	/* printf("%s ", msg); */
	if (msg != NULL) printf("%s ", msg);	/* check for null pointer added by
						 * [Haim Roman, 12/03/90] */
E 4
	chadir();
	if (bolt && SO && SE)
		putpad(SE);
	flusho();
	vclreol();
	if (state != VISUAL)
		vcnt = vcline = 0;
	splitw = 0;
	if (state == ONEOPEN || state == CRTOPEN)
		vup1();
	if (isRLtext)
		fixcursrl();
	if (sdl > WBOT || sdl > WECHO)
		sdl = (WBOT > WECHO ? WECHO : WBOT);
	vgoto(sdl,sdc);
	dontcare = sdontcare;
}


/*
 *	chadir - physicaly makes the change of the letter
 */
chadir()
{
	if (INdirect != DIdirect){
		if (INdirect == RL)
			setRL();
		else
			setLR();
		flusho();
	}
}


/*
 * Strcolrl returns the number of columns occupied by printing the current
 * line. 
 */
strcolrl()
{
	return (qcolumn(&linebuf[LBSIZE - 2], (char *) 0));
}


int             (*
		 setplod(t)) ()
	short           t;
{
	register        (*P) ();

	P = Plod;
	Plod = t ? plodRL : plod;
	return (P);
}


/*
 *	While working in RL-mode it is needed to physicaly make the
 *  cleaning from a certain point to the left end of the screen
 *  because CE isn't adjusted to working with right to left cursor
 *  moves, and it still cleans from the given point to the right end
 *  of the screen.
 */
vclreolRL()
{
	register int    i, j;
	register char  *tp;
	bool sdontcare = dontcare;

	if (destcol == WCOLS)
		return;
	destline += destcol / WCOLS;
	destcol %= WCOLS;
	if (destline < 0 || destline > WECHO)
		error("Internal error: vclreolRL");
	i = WCOLS - destcol;
/*	if (destline == WECHO)
		i = COLUMNS;
*/
	tp = vtube[destline] + destcol;
	for(j = 0; i > 0 && *tp++; j++);
	tp = vtube[destline] + destcol;
	dontcare = 1;
	delunl();
	while (j > 0 && (i = *tp & (QUOTE|TRIM))){
		if (i ==' ' && spechar(i) && HE && !value(MARKSL)) 
			destcol++;
		else
			vputchar(' ');
		*tp++ = 0;
		--j;
	}
	dontcare = sdontcare;
}

/*
 *	Printing the line number is done from right to left, so it is
 *  needed to adjust the number so that it will be printed aproprietly
 */
prnum(i)
	register 	int i;

{
	
	char num[8];
	
	if (i == 0)
		/*
		 *   Part of qcolumn procedure for computing the colum
		 * so we mustn't change number direction.
		 */
		printf("%6d  ",i);
	else{
		sprintf(num,"%d",i);
		revers(num);
		dontcare = 1;
		delunl();
		printf("%6s  ",num);
		dontcare = 0;
	}
}

numrl(i)
int i;
{
	register int j = 0;

	while(i){
		j = j*10 + i%10;
		i = i / 10;
	}
	return(j);
}

revers(cp)
	register 	char *cp;

{
	/* register	char help[LBSIZE],*sp; */
	register	char *sp;
	char		help[LBSIZE];
	register	int i;

I 4
	/* check for null pointer.  [Haim Roman 12/03/90] */
	if (cp == NULL) return;

E 4
	CP(help,cp);
	for(i = strlen(cp), sp = help+i-1; i > 0; *cp++ = *sp-- , i--);
}

fixcurslr()
{
	if (EG){
		newtputs(EG,0,putch);
		flusho();
	}
	Plod = plod;
}


fixcursrl()
{
	if (HE){
		newtputs(HE,0,putch);
		flusho();
	}
	Plod = plodRL;
}


/*
 *	For terminals that do not allow moving from right to left, we
 *  do it by moving the cursor two places left after each insertion
 *  of a character.
 */
jmpleft()

{
	bool scare;

	if (LEFT_PARM)
		if (destcol != 0)
			newtputs(tgoto(LEFT_PARM,0,2),2,putch);
		else
			newtputs(tgoto(LEFT_PARM,0,1),1,putch);
	else
		if (BC){
			if (destcol != 0)
				newtputs(BC,0,putch);
			newtputs(BC,0,putch);
		} else {
			scare = dontcare;
			dontcare = 1;
			delunl();
			if (destcol != 0){
				putch('\b');
				putch('\b');
			}else {	
				destcol++;
				fgoto();
				destcol--;
			}
			dontcare = scare;
		}
}
setprflag()

{
	if (!insmode && (state != HARDOPEN || OS) && (isRL || isRLtext))
		prflag = 1;
}

/*
 * Fix the echo area for use without change screen direction 
 * setting the state variable splitw so we wont rollup
 * when we move the cursor there.
 */
fixecho()
{

	splitw++;
	if (state != VISUAL && state != CRTOPEN) {
		vclean();
		vcnt = 0;
	}
	vgoto(WECHO, 0); flusho();
}

/*
 * CHANGEABB procedure sutibale the abbrevs buffer to the kind 
 * of text mode . For RL text the words must be in shef format in
 * LR text it mustbe in the format indentical to what it seen 
 * on the screen.
 */
 changeabb()
 {
	register int abno;

	if (!anyabbrs)
		return;
	for (abno=0; abbrevs[abno].mapto; abno++){
		changseclan(abbrevs[abno].cap, Mdirect);
		changseclan(abbrevs[abno].cap, !Mdirect);
		changseclan(abbrevs[abno].mapto, Mdirect);
		changseclan(abbrevs[abno].mapto, !Mdirect);
		changseclan(abbrevs[abno].descr, Mdirect);
		changseclan(abbrevs[abno].descr, !Mdirect);
	}
}

/*
 *	The next functions were meant to adjust the scan and the 
 *  substitute for working with the secondary language .
 *
 * setchar -- set/clear 8th bit so "language" of character matches the
 *	language indicated by Mdirect.
 */
setchar(c)
	register char *c;
{
I 4
	if (c == NULL)  return;	/* [Haim Roman, 12/03/90] */

E 4
	if (Mdirect)
		*c |= QUOTE;
	else
		*c &= TRIM;
}

setspechar(cp)
	register char *cp;
{
	/*
	 * Added variables 'prevsp' & 'nextsp' to point to characters 
	 * before & after the one pointed to by 'sp'.  Then used 
	 * them instead of 'sp[-1]' & 'sp[1]'.  (Haim Roman  17/11/89)
	 *
	 * Sorry -- I didn't need to do all that.  I may change it
	 * back later.
	 */
	register char *prevsp, *nextsp;
	register char *ep, *fp, *sp;
	char keepch;
	int spacenum = 0;
	int d;

I 4
	if (cp == NULL) return;	/* check for null pointer [Haim Roman 12/03/90] */
E 4
	sp = cp;
	switch (*sp & TRIM){
		case '.':
		case '/':
		case '?':
		case '&':
			setchar(sp++);
	}
	if (any(*sp, "^"))
			setchar(sp++);
	while(*sp){
		switch (*sp & TRIM){
		   case '/':
			spacenum += 1;
			setchar(sp++);
			continue;
		   case '\\':
				sp++;
magic:
				if (!value(MAGIC)){
					/* setchar(sp[-1]); */
					prevsp = sp;
					prevsp--;
					setchar(prevsp);

					d = *sp;
					if (RL_letter(d) != Mdirect){
						/* sp[-1] = *sp; */
						*prevsp = *sp;
						*sp = '\\';
					if (isRLtext)
						*sp |= QUOTE;
					}
					sp++;
					continue;
				}
				switch (*sp & TRIM){
		   			case '<':
		   			case '>':
						/* setchar(&sp[-1]); */
						prevsp = sp;
						prevsp--;
						setchar(prevsp);
						setchar(sp++);
						continue;
		   			case '(':
		   			case ')':
						if (spacenum != 0){
							setchar(sp++);
							continue;
						}
						if (*sp & QUOTE)
							if ((*sp & TRIM) == '(')
								*sp = ')';
							else
								*sp = '(';
		   			case '~':
						setchar(sp++);
						continue;
					case ']':
						if (isRLtext) {
							d = *sp;
							if (RL_letter(d))
								*sp = '[' | QUOTE;
							else
								*sp = '[';
						}
						sp++;
						continue;
					case '[':
						if (isRLtext) {
							d = *sp;
							if (RL_letter(d))
								*sp = ']' | QUOTE;
							else
								*sp = ']';
						}
						sp++;
						continue;
		   			case '^':
						d = *sp;
						/* if ((RL_letter(d)) != Mdirect && any(sp[-1], "[]") && !any(sp[1], "[]")){ */
						prevsp = nextsp = sp;
						prevsp--;
						nextsp++;
						if ((RL_letter(d)) != Mdirect && any(*prevsp, "[]") && !any(*nextsp, "[]")){
							keepch = *sp;
							ep = sp;
							fp = ep++;
							while (!any(*ep, "[]") && *ep)
								*fp++ = *ep++;
							*fp = keepch;
						} else
							sp++;
						continue;
		   			case '$':
						if (!*++sp)
							setchar(--sp);
						sp++;
						continue;
					default:
						setchar(sp++);
						continue;
				}
			case '[':
			case ']':
			case '$':
			case '^':
			case '.':
			case '*':
			case '~':
				if (value(MAGIC))
					goto magic;
			default:
				sp++;
		}
	}
}
magichar(cp)
	register char *cp;
{
I 4
	if (cp == NULL) return;	/* check for null pointer [Haim Roman 12/03/90] */

E 4
	switch (*cp & TRIM){
		case '/':
		case '?':
		case '&':
			 *cp++ &= TRIM;
	}
	for(; *cp; cp++){
		if ((*cp & TRIM) == '\\')
			if((cp[1] & TRIM) != '\\')
				*cp &= TRIM;
			else
				cp =cp + 2;
		else
			if (any(*cp, "/()<>[].~*^$"))
				if (value(MAGIC))
					*cp &= TRIM;
				else{
					if(cp[-1] == '\\' && cp[-2] != '\\')
						*cp &= TRIM;
				}
			/*else
				if (('/' | QUOTE) == *cp)
						*cp &= TRIM;
						*/
	}
}


setscan(buf, sbuf)
	register char *buf;
	bool sbuf;
{
	register char hbuf[LBSIZE];

D 4
	setbs(buf);
	setspechar(buf);
E 4
I 4
	setbs(buf);	/* process the RL chars acting as the backslash */
	setspechar(buf);	/* process the special characters */
E 4
	if (!ishef)
		if (Mdirect)
			changseclan(buf, RL);
		else
			changseclan(buf, LR);
	magichar(buf);
}

I 4
/*----------------------------------------------------------------
 * setbs -- process the RL "backslash" characters in a string.  The
 *	backslash character disables the special meaning of the next
 *	character (or enables it if in nomagic mode).  In the LR
 *	character set this is the '\' character.  In the RL character
 *	set, it is user settable.
 *
 *	This function converts the RL backslash character to '\' with
 *	the 8th bit set, unless it is preceeded by a '\' (with or
 *	without the 8th bit set).
 *
 *	NOTE -- this prologue might be incomplete.
 *
 * VALUE RETURNED BY FUNCTION:	none
 * ---------------------------
 *
 * FUNCTION PARAMETERS:
 * --------------------
 * sp (in/out) -- string that might contain the backslash characters.
 *
 * EXTERNAL VARIABLES:   (might be #define definitions)
 * -------------------
 *	This list might not be complete.  In particular, it might not
 *	contain all external variables referenced by the functions
 *	that this function calls.
 *
 *-------------------------------------------------------------------
 */
E 4
setbs(sp)
	register char *sp;
{
	register char *fp, *ep;
	int d;

I 4
	if (sp == NULL) return;	/* Added check for null pointer. [Haim Roman,
					 * 12/03/90]
					 */

E 4
	for(; *sp; sp++) {
I 4

		/* if 'sp' points to a RL escape character ... */
E 4
		d = *sp;
		if ((RL_letter(d)) && ((*sp & TRIM) == *svalue(BACKSLASH))) 
I 4
			/* if the RL backslash character is preceeded
			 * by a '\', do not convert it.  Delete the
			 * preceeding '\' from the string & move all
			 * the remaining characters up 1 element.
			 */
E 4
			if ((sp[-1] & TRIM) == '\\'){
				fp = sp;
				ep = fp--;
				do 
					*fp++ = *ep++;
				while (*ep);
				*fp ='\0';
I 4

			/* else convert the RL backslash character to
			 * really be a '\' with the 8th bit set.
			 */
E 4
			} else
				*sp = '\\' | QUOTE;
	}
}

/*---------------------------------------------------------------
 * convLL -- keyboard translation
 *
 *	NOTE -- this prologue might be incomplete.
 *
 * DESCRIPTION:
 * ------------
 * This function is called if the terminal does map from English to
 * Hebrew keyboard itself.  Given a Hebrew character, this function 
 * returns the ASCII code transmitted by the terminal when that Hebrew
 * character's key is hit, but the terminal is in English mode.
 *
 * VALUE RETURNED BY FUNCTION:  see DESCRIPTION
 * ---------------------------
 *
 * FUNCTION PARAMETERS:
 * --------------------
 * c (in) -- Hebrew character
 *
 * EXTERNAL VARIABLES:  
 * -------------------
 *	This list might not be complete.  In particular, it might not
 *	contain all external variables referenced by the functions
 *	that this function calls.
 *
 * NOTES:
 * ------
 * This function works only for Hebrew, not for other RL languages,
 * since the position of letters on the keyboard may differ.
 *-------------------------------------------------------------------
 */
char convLL(c)
	char c;
{
	c &= TRIM;

	/* if lower-case or Hebrew letter */
	if (c >= 96 && c<= 122)	
		return(convLR[c-'`']);
	else
		switch (c) {
			case ';': return('\\');
			case '/': return('`');
			case '.': return('/');
			case ',': return('\'');
			case '\'': return('w');
		}

	/*
	 * POSSIBLE BUG -- if 'c' does not match any of the above
	 * conditions, this function will return WITHOUT a value.
	 */
}

char convRR(c)		/* see convLL above */
	char c;
{
	c &= TRIM;
	if (c >= 96 && c<= 122)
		return(convRL[c-'`']);
	else
		switch (c) {
			case ';': return('s');
			case '/': return('.');
			case '.': return('u');
			case ',': return('z');
			case '\\': return(';');
		}
}

delunl()
{
	if (underline){
		newtputs(UE, 0, putch);
		underline = 0;
		flusho();
	}
}
 
addkeep(fp, sp)
	register char *fp, *sp;
{
	char helpbuf[MAXBSIZE];
I 4
	static char null_string [1];	/* null string, in case sp is a null pointer
					 * [Haim Roman, 12/03/90] 
					 */
E 4

I 4
	null_string [0] = '\0';
	
	/* Check for null pointer. [Haim Roman, 12/03/90] */
	if (fp == NULL) {
		error ("Bug in function addkeep: fp is a null pointer");
		return;
	} else if (sp == NULL) {
		sp = null_string;
	}

E 4
	strcpy(helpbuf, fp);
	strcpy(fp, sp);
	strcpy(fp+strlen(sp), helpbuf);
}

convdu(gp)
	register char *gp;
{
	char helpbuf[MAXBSIZE], *hp, *fp, *lp;
	int d;

I 4
	if (gp == NULL) return;	/* [Haim Roman, 12/03/90] */

E 4
	hp = helpbuf;
	strcpy(helpbuf, gp);
	for (hp = helpbuf; *hp; ) {
		d = *hp;
		if (!RL_letter(d) || !(isupper(*hp&TRIM) || isdigit(*hp&TRIM)))
			*gp++ = *hp++;	
		else {
			for(fp=hp; *hp; hp++){
				d = *hp;
				if (!RL_letter(d) || !(isupper(*hp&TRIM) || isdigit(*hp&TRIM)))
					break;
			}
			lp = hp;
			for(hp--; hp >= fp; )
				*gp++ = *hp--;
			hp = lp;
		}
	}
}

cut(buf, cbuf)
	register char *buf, *cbuf;

{
	register char *hp;
	register int i = 0;

I 4
	/* check for null pointers. [Haim Roman, 12/03/90] */
	if (buf == NULL) {
		error ("Bug in function cut: buf is a null pointer");
		return;
	} else if (cbuf == NULL) {
		error ("Bug in function cut: cbuf is a null pointer");
		return;
	}

E 4
	for(hp = buf; *hp; hp++)
		if ((*hp & TRIM) == '/')
			i++;
	if (i == 2){
		for (--hp; (*hp & TRIM) != '/'; hp--);
		strcpy(cbuf, hp);
		*hp = '\0';
	}
}

vclrecholr()
{
	int scol,sline;

	scol = destcol , sline = destline;
	vgoto(WECHO,0);
	vputp(CD ? CD : CE, 1);
	vgoto(sline, scol);
}


termch()
{
	int i = 1, j, zero=0, one =1;
	char ch;

	ioctl(0, FIONREAD, &i);
	while (i){
		for(; i > 0; i--){
			i = read(0, &ch,1);
			if (i == 1)
				inchar(ch, DIdirect);
		}
		ioctl(0, FIONREAD, &i);
	}
}

inchar(ch, dir)
	char ch;
	int dir;
{
	if (mone == ternum)
		perror("The typech is full");
	else {
		typech[inpoint].ch = ch;
		typech[inpoint].typedir = dir;
		mone++;
		if (++inpoint == ternum)
			inpoint = 0;
	}
}

outch(ch, dir)
	char *ch;
	int dir;
{
	if (mone == 0)
		return(0);
	else {
I 4
		/* check for null pointer. [Haim Roman, 12/03/90] */
		if (ch == NULL) {
			error ("Bug in function outch: ch is a null pointer");
			return;
		}

E 4
		if(typech[outpoint].typedir != dir)
			if (dir == LR)
				*ch = convLL(typech[outpoint].ch);
			else
				*ch = convRR(typech[outpoint].ch);
		mone--;
		if (++outpoint == ternum)
			outpoint = 0;
		if (*ch == 'Q')
			return(0);
		else
			return(1);
	}
}
/*---------------------------------------------------------------
 * beginsec -- begin 2nd language
 *
 *	NOTE -- this prologue might be incomplete.
 *
 * DESCRIPTION:
 * ------------
 * First I must define the following terms:
 *
 *	2nd language = the language/direction that is NOT the main language.
 *	block = a contiguous string of characters, all in the same 
 *		language & all on the same line.
 *
 *	current = where the cursor currently is.
 *
 * This function finds the 1st character on the current line of the
 * current 2nd language block.  In more detail:
 *
 *	(1) If the current block is 2nd language, & there is at least
 *	1 main lanuguage character before the current charact but ON
 *	THE CURRENT LINE, then this function finds the 1st character
 *	of the current block.
 *
 *	(2) If current block is 2nd language, but there are no 1st
 *	language characters before it on the line, this function finds
 *	the beginning of the line.
 *
 *	(3) If the current block is main language, this function finds
 *	the current character.
 *
 * To see what exactly is meant by "finding", see sections VALUE
 * RETURNED & FUNCTION PARAMETERS
 *
 * VALUE RETURNED BY FUNCTION:
 * ---------------------------
 * pointer to the character found.
 *
 * FUNCTION PARAMETERS:
 * --------------------
 * i (out) -- the integer pointed to by 'i' will be the number of
 * columns from the "found" character to the current character.
 *
 * EXTERNAL VARIABLES:  
 * -------------------
 *	This list might not be complete.  In particular, it might not
 *	contain all external variables referenced by the functions
 *	that this function calls.
 *
 * Mdirect (in) -- main language/direction
 * cursor (in) -- points to character that the cursor is on
 * linebuf (in) -- points to text on the current line
 *
 *-------------------------------------------------------------------
 */
char *
	beginsec(i)
int *i;
{
	register char *sp;
	int d;		/* value of character pointed to by sp */
I 4

	/* check for null pointers. [Haim Roman, 12/03/90] */
	if (cursor == NULL) {
		error ("Bug in routine beginsec: cursor is a null pointer");
		return (NULL);
	} else if (linebuf == NULL) {
		error ("Bug in routine beginsec: linebuf is a null pointer");
		return (cursor);
	}
E 4
	
	sp = cursor;
	d = *--sp;
	while (sp > linebuf && RL_letter(d) != Mdirect)
		d = *--sp;
	*i = column(cursor) - column(++sp);
	return(sp);
}

D 4
/*
 * This procedure return the column in screen where the *sp character  
E 4
I 4
/*-------------------------------------------------------------------
 * screencol --  return the column in screen where the *sp character  
E 4
 * where apper.
I 4
 *
 * FUNCTION ARGUMENTS:
 * -------------------
 * bp (in/out) -- pointer to some character string (which we will call
 *	the main buffer); its contents might be changed.
 * sp (in/out) -- pointer to a pointer to some substring within bp.
 *	Might be changed to point to a different substring.
 *-------------------------------------------------------------------
E 4
 */

screencol(bp, sp)
	register char  *bp, **sp;
{
D 4
	register char  *cp, *lp, *tp, *pel;
E 4
I 4
	/*----------------------------------------------
	 * INTERNAL NOTES
	 *
	 * (1) In the comments we distinguish between a file line & a
	 * display line.  A file line is a string of characters ending
	 * in a newline (or maybe null) character, as it is stored in
	 * the file.  If such a line is too long, it will be displayed
	 * on more than one lines on the screen;  each of these is
	 * called a display line.
	/*-----------------------------------------------
	 * LOCAL DATA
	 *----------------------------------------------
	 */
	register char	*cp, 	/* points to current character */
			*lp, 
			*tp, 
			*pel;	/* points to 1st character of the next
				 * display line (?) 
				 */
E 4
	/* register char            hbuf[LBSIZE]; */
D 4
	char            hbuf[LBSIZE];
E 4
I 4
	char            hbuf[LBSIZE];  /* temporary main buffer */
E 4
	register int    i;
D 4
	bool makechang = 0, first= 1;
E 4
I 4
	bool	makechang = 0, 
		first= 1;	/* true = this is the 1st display line
				 * of the file line.
				 */
E 4
	int d;

D 4
	CP(hbuf, bp);
E 4
I 4
	/*------------------------------------------------
	 * Check validity of arguments  [Haim Roman, 12/03/90]
	 *---------------------------------------------------
	 */
	if (bp == NULL) {
		error ("Bug in function screencol: bp is a null pointer");
		return (0);
	} if (sp == NULL) {
		error ("Bug in function screencol: sp is a null pointer");
		return (0);
	}

	/*----------------------------------------------------
	 * Initialization
	 *------------------------------------------------
	 */
	CP(hbuf, bp);		/* copy main buffer to temporary main buffer */
E 4
	cp = pel = hbuf;
	lp = bp;
	i = (*sp - bp);
D 4
	*sp = hbuf + (*sp - bp);
E 4
I 4
	*sp = hbuf + (*sp - bp);  /* *sp now points to the equivalent
				   * substring in the temp main buffer.
				   */
	
	/*--------------------------------------------------------
	 * loop through the main buffer until hit a null string or end
	 * of line.
	 *-------------------------------------------------------
	 */
E 4
	while (cp != pel || (*pel && ((*pel & TRIM) != '\n'))) {
I 4
		
		/* if we've reached the end of the current display
		 * line, set pel to point to the 1st character of the
		 * next line.
		 */
E 4
		if (cp == pel)
			pel = cntendlin(pel, &first);
I 4

		/* starting at current character, loop until hit
		 * either the end of the current display line or a
		 * secondary language character.
		 */
E 4
		d = *cp;
		for (; cp < pel && ((RL_letter(d)) == Mdirect); d = *cp){
I 4
			/* increment pointer to current char in main 
			 * buffer to correspond to current char in
			 * temp main buffer.
			 */
E 4
			*lp++ = *cp;
I 4
			
E 4
			if (cp++ == *sp){
				makechang = 1;
I 4
				
				/* 'sp' was pointing to the given
				 * substring in the temp main buffer. 
				 * Now change it to point to the
				 * corresponding position in the main
				 * buffer.
				 */
E 4
				*sp = lp - 1;
			}
D 4
		}
E 4
I 4
		}  /* for (; cp < pel ... */

		/* if current character is secondary language character */
E 4
		if (cp < pel) {
D 4
			tp = cp;
E 4
I 4
			tp = cp;	/* save current position in temp main buff */

			/* set cp to point at last char in the current
			 * secondary language block.
			 * 
			 * note -- we are reversing the order of secondary
			 * language blocks in the main buffer, leaving the
			 * temp main buffer alone.  We'll restore the main
			 * buffer down below by copying the temp main buffer
			 * to it.
			 * 
			 * the main buffer is in time order.  But we want sp to
			 * point to a place in the main buffer as if the main
			 * buffer was in visual order!
			 */
E 4
			cp = next_lang(cp, pel, !Mdirect);
D 4
			i = cp - tp + 1;
			for (; cp >= tp; ){
E 4
I 4
			i = cp - tp + 1;	/* reverse order of secondary */
			for (; cp >= tp; ){	/* text block in main buffer */
E 4
				*lp++ = *cp;
				if (cp-- == *sp){
					makechang = 1;
					*sp = lp - 1;
				}
			}
D 4
			cp = tp + i;
E 4
I 4
			cp = tp + i;	/* restore position in temp main buff */

		/* else we've hit the end-of-line */
E 4
		} else
			break;
D 4
	}
E 4
I 4
	} /* while */

	/*--------------------------------------------------
	 * Final Actions
	 *-------------------------------------------------
	 */
	/* If we haven't changed which substring sp is pointing to,
	 * then it is still pointing to the temp main buffer.  Make it
	 * point to the corresponding place in the main buffer.
	 */ 
E 4
	if (!makechang)
		*sp = bp + (*sp - hbuf);
I 4
	
	/* return the column of the screen where the string pointed to
	 * by sp begins.
	 */
E 4
	i = column(*sp);
D 4
	CP(bp, hbuf);
E 4
I 4
	CP(bp, hbuf);	/* undo changes to the main buffer */
E 4
	return (i);
D 4
}
E 4
I 4
} /* end of function screencol */
E 4

hscreencol(lp)
char *lp;
{
	char *sp;

I 4
	/* check for null pointer. [Haim Roman, 12/03/90] */
	if (linebuf == NULL) {
		error ("Bug in routine hscreencol: linebuf is a null pointer");
		return (0);
	}

E 4
	sp = lp;
	return(screencol(linebuf, &sp));
}


I 2
/*---------------------------------------------------------
 * setshcurs -- set shef cursor
 *	compute where the cursor must be if we are dealing with a shef
 *	file (because then the file is in time order, not visual order).
 *
 *		This is how I understood Uri' explanation, but then I
 *		don't understand why routine "selbuf" calls it where
 *		it does		((( HR 29/12/89 )))
 *---------------------------------------------------------
 */
E 2
setshcurs()
{
	if (ishef){
I 4
		/* check for null pointer. [Haim Roman, 12/03/90] */
		if (linebuf == NULL) {
			error ("Bug in routine setshcurs: linebuf is a null pointer");
			return;
		} else if (tobuf == NULL) {
			error ("Bug in routine setshcurs: tobuf is a null pointer");
			return;
		}

E 4
		CP(tobuf, linebuf);
D 4
		screencol(linebuf, &cursor);
		changseclan(linebuf, Mdirect);
E 4
I 4
		screencol(linebuf, &cursor); /* adjust cursor as if line was in visual order */
		changseclan(linebuf, Mdirect); /* change linebuf from time to visual order */
E 4
	}
}

I 2
/*-------------------------------------------------------
 * markcurs -- mark current position of cursor by inserting an octal
 *	002 (202 if inserting in RL mode).  This character will not be
 *	displayed on the screen.
 *------------------------------------------------------
 */
E 2
markcurs()
{
	char help[LBSIZE];

I 4
	/* check for null pointer. [Haim Roman, 12/03/90] */
	if (cursor == NULL) {
		error ("Bug in routine markcurs: cursor is a null pointer");
		return;
	}

E 4
	CP(help, cursor);
	*cursor = (INdirect ? 0202 : 2);
	CP(cursor + 1, help);
}


selbuf(prflag)
bool prflag;
{
D 2
	markcurs();
E 2
I 2
	markcurs();	/* mark current cursor position */
E 2
	setshcurs();
D 2
	curlbuf();
	DEPTH(vcline) = 0;
E 2
I 2
	curlbuf();	/* return to the cursor-position mark */

		/* the following line was in the version that was
		 * originally running on host TECHUNIX (a VAX), but
		 * apparently it was never executed.  When executed, it
		 * causes an insert-mode bug.  When starting a new line,
		 * all lines previously entered in the same insertion are
		 * echoed after the cursor.  Commenting out the line
		 * fixes the problem, but it might cause other problems.
		 *		((( HR 29/12/89 )))
		 */
	/* DEPTH(vcline) = 0; */
E 2
	if (prflag){
		setprflag();
		vreopen(LINE(vcline), lineDOT(), vcline);
		prflag = 0;
	}
}

I 2
/*--------------------------------------------------------
 * curlbuf -- return to where cursor was (i.e., where "markcurs" was
 *	called.  See "markcurs").
 *---------------------------------------------------------
 */
E 2
curlbuf()
{
I 4
	/* check for null pointer. [Haim Roman, 12/03/90] */
	if (linebuf == NULL) {
		error ("Bug in routine curlbuf: linebuf is a null pointer");
		return;
	}

E 4
	for (cursor = linebuf; (*cursor & TRIM) != 2 && *cursor; cursor++);
}

vgotabsl()
{
	register int i =  value(TABSTOP);

	do
		(*Outchar)(TSL);
	while (--i);
}

I 4
/*--------------------------------------------------------
 * setlf -- convert line from time order to visual order (I think it
 *	will also conver the other way around;  I'm writing the
 *	comments assuming this is so  [Haim Roman 15/03/90] )
 *
 * FUNCTION ARGUMENTS:
 * -------------------
 * flag (in/out) -- pointer to a boolean variable which gets toggled
 *	every time this function is called.  This flag is used by the
 *	caller to keep track if the line was changed or not.
 *
 * GLOBAL VARIABLES: (this list might not be complete)
 * -----------------
 * linebuf (in/out) -- the line buffer that gets converted.
 * tobuf (out) -- buffer that holds contents of linebuf before the
 *	conversion.  Last I checked (15/03/90), this buffer was never
 *	used for restoring linebuf's contents; instead setlf is simply
 *	called a 2nd time.
 * cursor, wcursor (in/out) -- each point to some place in linebuf.
 *	If they are pointing to characters in the secondary language,
 *	they are adjusted to continue pointing to that character even
 *	after the conversion.
 *-------------------------------------------------------------
 */
E 4
setlf(flag)
D 4
bool *flag;
E 4
I 4
	bool *flag;
E 4
{
I 4
	/* check for null pointer. [Haim Roman, 12/03/90] */
	if (flag == NULL) {
		error ("Bug in routine setlf: flag is a null pointer");
		return;
	}

E 4
	*flag = !*flag;
I 4

	/* if this is not a shef file, then the file is stored in
	 * visual order, and there is no need to do the conversion.
	 */
E 4
	if (ishef){
D 4
		screencol(linebuf, &wcursor);
		setshcurs();
E 4
I 4
		screencol(linebuf, &wcursor);	/* convert wcursor */

		/* adjust linebuf & cursor.  Save lienbuf's original
		 * contents in 'tobuf'.
		 */
		setshcurs(); 
E 4
	}
}

simpleR(inscol, ch, newcol)
int inscol;
char ch;
int *newcol;
{
	char help[LBSIZE];
	char tp, *vp, *hp;
	int colnum = (value(NUMBER) ? 8 : 0);
	int d, e;
I 4

	/* check for null pointer. [Haim Roman, 12/03/90] */
	if (newcol == NULL) {
		error ("Bug in routine simpleR: newcol is a null pointer");
		return;
	}
E 4
	
	CP(help, vtube0);
	vp = help + inscol;
	screencol(help + colnum, &vp);
	changseclan(help + colnum, Mdirect);
	tp = *vp;
	*vp++ = ch;
	hp = vp;
	if (isecondlang && !*hp){
		doomed = 0;
		hp--;
	}
	screencol(help + colnum, &hp);
	changseclan(help + colnum, Mdirect);
	*newcol = hp - help;
	d = ch;
	e = tp;
	if (RL_letter(d) != RL_letter(e))
		return(1);
	else
		return(0);
}

vputlineR(inscol, c, newcol)
int inscol;
char c;
int newcol;
{
	char *tp;
	int sline = destline;
	bool smark = omark;
	int colnum = (value(NUMBER) ? 8 : 0);
	int d, e;
	
	omark = 0;
	tp = vtube0 + inscol;
	d = *tp;
	e = c;
	if (RL_letter(d) != RL_letter(e)){
		omark = 1;
		screencol(vtube0 + colnum, &tp);
		changseclan(vtube0 + colnum, Mdirect);
	}
	*tp++ = c;
	if (omark)
		changseclan(vtube0 + colnum, Mdirect);
	vgoto(LINE(vcline), 0);
	omark = 1;
	for ( tp = vtube0; *tp; )
		vputchar(*tp++);
	omark = smark;
	vgoto(sline, newcol);
}

/*---------------------------------------------------------------
 * convlinebp -- convert the linebp buffer to terminal form.
 *
 *	NOTE -- this prologue might be incomplete.
 *
 * DESCRIPTION:
 * ------------
 * When this function is called, the string pointed to by the external
 * variable linebp is in shef format.  This function converts it to a
 * form sutiable for displaying on the screen.
 *
 * VALUE RETURNED BY FUNCTION:	none
 * ---------------------------
 *
 * FUNCTION PARAMETERS:	none
 * --------------------
 *
 * EXTERNAL VARIABLES:  
 * -------------------
 *	This list might not be complete.  In particular, it might not
 *	contain all external variables referenced by the functions
 *	that this function calls.
 *
 * Mdirect (in) -- the current main direction of editing.
 * linebp (in/out) -- points to the string to convert.  THIS CANNOT BE
 *	A NULL POINTER!
 *
 *-------------------------------------------------------------------
 */
convlinebp()
{
	register char *hp;

	/*
	 * I added this check for a null pointer, because there were
	 * times when this function was called when 'linebp' was null,
	 * and this caused segmentation fault on the Sun-4.  It may be
	 * that the reason this did not cause a problem on the VAX was
	 * that the VAX does abort when referencing a null pointer.  Or
	 * it maybe that on the VAX, this pointer was never null.  I
	 * don't know yet.  (Haim Roman, 15/11/89).
	 */
	if (linebp != NULL) {
	
		/*
		 * loop through string until hit a null.  For every newline
		 * character in the string, set/clear the 8th bit so that the
		 * "language" of the character matches the language specified by
		 * the external variable Mdirect.
		 */
		for (hp = linebp; *hp; hp++)
			if ((*hp & TRIM) == '\n')
				setchar(hp);
		/*
		 * change from shef format to screen format. This means
		 * modifying linebp so that it is in the order it will appear on
		 * the screen rather than shef order.
		 */
		changseclan(linebp, Mdirect);
	
		/*
		 * now change the language of all the newlines to LR, so the
		 * rest of the editor will recognize them.
		 */
		for (hp = linebp; *hp; hp++)
			if ((*hp & TRIM) == '\n')
				*hp &= TRIM;
	}
}
E 1
