﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ram/RAM_EXPORTS.h>
#include <aws/ram/model/ResourceShareInvitation.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace RAM {
namespace Model {
class AcceptResourceShareInvitationResult {
 public:
  AWS_RAM_API AcceptResourceShareInvitationResult() = default;
  AWS_RAM_API AcceptResourceShareInvitationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_RAM_API AcceptResourceShareInvitationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An object that contains information about the specified invitation.</p>
   */
  inline const ResourceShareInvitation& GetResourceShareInvitation() const { return m_resourceShareInvitation; }
  template <typename ResourceShareInvitationT = ResourceShareInvitation>
  void SetResourceShareInvitation(ResourceShareInvitationT&& value) {
    m_resourceShareInvitationHasBeenSet = true;
    m_resourceShareInvitation = std::forward<ResourceShareInvitationT>(value);
  }
  template <typename ResourceShareInvitationT = ResourceShareInvitation>
  AcceptResourceShareInvitationResult& WithResourceShareInvitation(ResourceShareInvitationT&& value) {
    SetResourceShareInvitation(std::forward<ResourceShareInvitationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The idempotency identifier associated with this request. If you want to
   * repeat the same operation in an idempotent manner then you must include this
   * value in the <code>clientToken</code> request parameter of that later call. All
   * other parameters must also have the same values that you used in the first
   * call.</p>
   */
  inline const Aws::String& GetClientToken() const { return m_clientToken; }
  template <typename ClientTokenT = Aws::String>
  void SetClientToken(ClientTokenT&& value) {
    m_clientTokenHasBeenSet = true;
    m_clientToken = std::forward<ClientTokenT>(value);
  }
  template <typename ClientTokenT = Aws::String>
  AcceptResourceShareInvitationResult& WithClientToken(ClientTokenT&& value) {
    SetClientToken(std::forward<ClientTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  AcceptResourceShareInvitationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ResourceShareInvitation m_resourceShareInvitation;

  Aws::String m_clientToken;

  Aws::String m_requestId;
  bool m_resourceShareInvitationHasBeenSet = false;
  bool m_clientTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace RAM
}  // namespace Aws
