# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
# pylint: disable=too-many-lines


def sshkey_list(client,
                resource_group_name=None):
    if resource_group_name:
        return client.list_by_resource_group(resource_group_name=resource_group_name)
    return client.list_by_subscription()


def sshkey_show(client,
                resource_group_name,
                ssh_public_key_name):
    return client.get(resource_group_name=resource_group_name,
                      ssh_public_key_name=ssh_public_key_name)


def sshkey_create(client,
                  resource_group_name,
                  ssh_public_key_name,
                  location,
                  tags=None,
                  public_key=None):
    parameters = {}
    parameters['location'] = location
    parameters['tags'] = tags
    parameters['public_key'] = public_key
    return client.create(resource_group_name=resource_group_name,
                         ssh_public_key_name=ssh_public_key_name,
                         parameters=parameters)


def sshkey_update(client,
                  resource_group_name,
                  ssh_public_key_name,
                  tags=None,
                  public_key=None):
    parameters = {}
    parameters['tags'] = tags
    parameters['public_key'] = public_key
    return client.update(resource_group_name=resource_group_name,
                         ssh_public_key_name=ssh_public_key_name,
                         parameters=parameters)


def sshkey_delete(client,
                  resource_group_name,
                  ssh_public_key_name):
    return client.delete(resource_group_name=resource_group_name,
                         ssh_public_key_name=ssh_public_key_name)
