/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.InitializationFinder;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.ReferenceTracingInvocationUnit;
import proguard.optimize.evaluation.ReferenceTracingValueFactory;
import proguard.util.ArrayUtil;

public class LivenessAnalyzer
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private static final int MAX_VARIABLES_SIZE = 64;
    private final PartialEvaluator partialEvaluator;
    private final boolean runPartialEvaluator;
    private final InitializationFinder initializationFinder;
    private final boolean runInitializationFinder;
    private long[] isAliveBefore = new long[8096];
    private long[] isAliveAfter = new long[8096];
    private long[] isCategory2 = new long[8096];
    private boolean checkAgain;
    private long alive;

    public LivenessAnalyzer() {
        this(new ReferenceTracingValueFactory(new BasicValueFactory()));
    }

    private LivenessAnalyzer(ReferenceTracingValueFactory referenceTracingValueFactory) {
        this(new PartialEvaluator(referenceTracingValueFactory, new ReferenceTracingInvocationUnit(new BasicInvocationUnit(referenceTracingValueFactory)), true, referenceTracingValueFactory), true);
    }

    private LivenessAnalyzer(PartialEvaluator partialEvaluator, boolean runPartialEvaluator) {
        this(partialEvaluator, runPartialEvaluator, new InitializationFinder(partialEvaluator, false), true);
    }

    public LivenessAnalyzer(PartialEvaluator partialEvaluator, boolean runPartialEvaluator, InitializationFinder initializationFinder, boolean runInitializationFinder) {
        this.partialEvaluator = partialEvaluator;
        this.runPartialEvaluator = runPartialEvaluator;
        this.initializationFinder = initializationFinder;
        this.runInitializationFinder = runInitializationFinder;
    }

    public boolean isTraced(int instructionOffset) {
        return this.partialEvaluator.isTraced(instructionOffset);
    }

    public boolean isAliveBefore(int instructionOffset, int variableIndex) {
        return variableIndex >= 64 ? this.partialEvaluator.getVariablesBefore(instructionOffset).getValue(variableIndex) != null : (this.isAliveBefore[instructionOffset] & 1L << variableIndex) != 0L;
    }

    public void setAliveBefore(int instructionOffset, int variableIndex, boolean alive) {
        if (variableIndex < 64) {
            if (alive) {
                int n = instructionOffset;
                this.isAliveBefore[n] = this.isAliveBefore[n] | 1L << variableIndex;
            } else {
                int n = instructionOffset;
                this.isAliveBefore[n] = this.isAliveBefore[n] & (1L << variableIndex ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }

    public boolean isAliveAfter(int instructionOffset, int variableIndex) {
        return variableIndex >= 64 ? this.partialEvaluator.getVariablesAfter(instructionOffset).getValue(variableIndex) != null : (this.isAliveAfter[instructionOffset] & 1L << variableIndex) != 0L;
    }

    public void setAliveAfter(int instructionOffset, int variableIndex, boolean alive) {
        if (variableIndex < 64) {
            if (alive) {
                int n = instructionOffset;
                this.isAliveAfter[n] = this.isAliveAfter[n] | 1L << variableIndex;
            } else {
                int n = instructionOffset;
                this.isAliveAfter[n] = this.isAliveAfter[n] & (1L << variableIndex ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }

    public boolean isCategory2(int instructionOffset, int variableIndex) {
        return variableIndex >= 64 ? this.partialEvaluator.getVariablesBefore(instructionOffset).getValue(variableIndex) != null && this.partialEvaluator.getVariablesBefore(instructionOffset).getValue(variableIndex).isCategory2() : (this.isCategory2[instructionOffset] & 1L << variableIndex) != 0L;
    }

    public void setCategory2(int instructionOffset, int variableIndex, boolean category2) {
        if (variableIndex < 64) {
            if (category2) {
                int n = instructionOffset;
                this.isCategory2[n] = this.isCategory2[n] | 1L << variableIndex;
            } else {
                int n = instructionOffset;
                this.isCategory2[n] = this.isCategory2[n] & (1L << variableIndex ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int offset;
        int codeLength = codeAttribute.u4codeLength;
        int variablesSize = codeAttribute.u2maxLocals;
        this.isAliveBefore = ArrayUtil.ensureArraySize(this.isAliveBefore, codeLength, 0L);
        this.isAliveAfter = ArrayUtil.ensureArraySize(this.isAliveAfter, codeLength, 0L);
        this.isCategory2 = ArrayUtil.ensureArraySize(this.isCategory2, codeLength, 0L);
        if (this.runPartialEvaluator) {
            this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        if (this.runInitializationFinder) {
            this.initializationFinder.visitCodeAttribute(clazz, method, codeAttribute);
        }
        if (variablesSize > 64) {
            variablesSize = 64;
        }
        do {
            this.checkAgain = false;
            this.alive = 0L;
            for (offset = codeLength - 1; offset >= 0; --offset) {
                if (!this.partialEvaluator.isTraced(offset)) continue;
                InstructionOffsetValue branchTargets = this.partialEvaluator.branchTargets(offset);
                if (branchTargets != null) {
                    this.alive = this.combinedLiveness(branchTargets);
                }
                this.alive |= this.isAliveAfter[offset];
                this.isAliveAfter[offset] = this.alive;
                codeAttribute.instructionAccept(clazz, method, offset, this);
                this.alive |= this.isAliveBefore[offset];
                if (((this.isAliveBefore[offset] ^ 0xFFFFFFFFFFFFFFFFL) & this.alive) == 0L) continue;
                this.isAliveBefore[offset] = this.alive;
                InstructionOffsetValue branchOrigins = this.partialEvaluator.branchOrigins(offset);
                if (branchOrigins == null || offset >= branchOrigins.maximumValue()) continue;
                this.checkAgain = true;
            }
            codeAttribute.exceptionsAccept(clazz, method, this);
        } while (this.checkAgain);
        for (offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset)) continue;
            for (int variableIndex = 0; variableIndex < variablesSize; ++variableIndex) {
                Value value;
                if (this.isAliveBefore(offset, variableIndex) && (value = this.partialEvaluator.getVariablesBefore(offset).getValue(variableIndex)) != null && value.isCategory2()) {
                    this.setCategory2(offset, variableIndex, true);
                    this.setAliveBefore(offset, variableIndex + 1, true);
                    this.setCategory2(offset, variableIndex + 1, true);
                }
                if (!this.isAliveAfter(offset, variableIndex) || (value = this.partialEvaluator.getVariablesAfter(offset).getValue(variableIndex)) == null || !value.isCategory2()) continue;
                this.setCategory2(offset, variableIndex, true);
                this.setAliveAfter(offset, variableIndex + 1, true);
                this.setCategory2(offset, variableIndex + 1, true);
            }
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        int variableIndex = variableInstruction.variableIndex;
        if (variableIndex < 64) {
            long livenessMask = 1L << variableIndex;
            if (variableInstruction.isLoad()) {
                this.alive |= livenessMask;
            } else {
                this.alive &= livenessMask ^ 0xFFFFFFFFFFFFFFFFL;
                int n = offset;
                this.isAliveAfter[n] = this.isAliveAfter[n] | livenessMask;
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        if (offset == this.initializationFinder.superInitializationOffset()) {
            this.alive |= 1L;
        }
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        long alive = this.isAliveBefore[exceptionInfo.u2handlerPC];
        if (alive != 0L) {
            int startOffset = exceptionInfo.u2startPC;
            int endOffset = exceptionInfo.u2endPC;
            for (int offset = startOffset; offset < endOffset; ++offset) {
                if (!this.partialEvaluator.isTraced(offset) || ((this.isAliveBefore[offset] & this.isAliveAfter[offset] ^ 0xFFFFFFFFFFFFFFFFL) & alive) == 0L) continue;
                int n = offset;
                this.isAliveBefore[n] = this.isAliveBefore[n] | alive;
                int n2 = offset;
                this.isAliveAfter[n2] = this.isAliveAfter[n2] | alive;
                this.checkAgain = true;
            }
        }
    }

    private long combinedLiveness(InstructionOffsetValue instructionOffsetValue) {
        long alive = 0L;
        int count = instructionOffsetValue.instructionOffsetCount();
        for (int index = 0; index < count; ++index) {
            alive |= this.isAliveBefore[instructionOffsetValue.instructionOffset(index)];
        }
        return alive;
    }
}

