/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class ImmutablePair<L, R>
extends Pair<L, R> {
    public static final ImmutablePair<?, ?>[] EMPTY_ARRAY = new ImmutablePair[0];
    private static final ImmutablePair NULL = new ImmutablePair<Object, Object>(null, null);
    private static final long serialVersionUID = 4954918890077093841L;
    public final L left;
    public final R right;

    public static <L, R> ImmutablePair<L, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static <L, R> Pair<L, R> left(L left2) {
        return ImmutablePair.of(left2, null);
    }

    public static <L, R> ImmutablePair<L, R> nullPair() {
        return NULL;
    }

    public static <L, R> ImmutablePair<L, R> of(L left2, R right2) {
        return left2 != null || right2 != null ? new ImmutablePair<L, R>(left2, right2) : ImmutablePair.nullPair();
    }

    public static <L, R> ImmutablePair<L, R> of(Map.Entry<L, R> pair) {
        return pair != null ? new ImmutablePair<L, R>(pair.getKey(), pair.getValue()) : ImmutablePair.nullPair();
    }

    public static <L, R> ImmutablePair<L, R> ofNonNull(L left2, R right2) {
        return ImmutablePair.of(Objects.requireNonNull(left2, "left"), Objects.requireNonNull(right2, "right"));
    }

    public static <L, R> Pair<L, R> right(R right2) {
        return ImmutablePair.of(null, right2);
    }

    public ImmutablePair(L left2, R right2) {
        this.left = left2;
        this.right = right2;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    @Override
    public R setValue(R value) {
        throw new UnsupportedOperationException();
    }
}

