/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.runtime.TestCaseFailed;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public final class TestCaseResultObserver
implements AutoCloseable {
    private final EventPublisher bus;
    private final List<Suggestion> suggestions = new ArrayList<Suggestion>();
    private final EventHandler<SnippetsSuggestedEvent> snippetsSuggested = this::handleSnippetSuggestedEvent;
    private Result result;
    private final EventHandler<TestCaseFinished> testCaseFinished = this::handleTestCaseFinished;

    public TestCaseResultObserver(EventPublisher bus) {
        this.bus = bus;
        bus.registerHandlerFor(SnippetsSuggestedEvent.class, this.snippetsSuggested);
        bus.registerHandlerFor(TestCaseFinished.class, this.testCaseFinished);
    }

    @Override
    public void close() {
        this.bus.removeHandlerFor(SnippetsSuggestedEvent.class, this.snippetsSuggested);
        this.bus.removeHandlerFor(TestCaseFinished.class, this.testCaseFinished);
    }

    private void handleSnippetSuggestedEvent(SnippetsSuggestedEvent event) {
        SnippetsSuggestedEvent.Suggestion s = event.getSuggestion();
        this.suggestions.add(new Suggestion(s.getStep(), s.getSnippets()));
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        this.result = event.getResult();
    }

    public void assertTestCasePassed(Supplier<Throwable> testCaseSkipped, Function<Throwable, Throwable> testCaseSkippedWithException, Function<List<Suggestion>, Throwable> testCaseWasUndefined, Function<Throwable, Throwable> testCaseWasPending) {
        Status status = this.result.getStatus();
        if (status.is(Status.PASSED)) {
            return;
        }
        Throwable error = this.result.getError();
        if (status.is(Status.SKIPPED) && error == null) {
            Throwable throwable = testCaseSkipped.get();
            throw new TestCaseFailed(throwable);
        }
        if (status.is(Status.SKIPPED) && error != null) {
            Throwable throwable = testCaseSkippedWithException.apply(error);
            throw new TestCaseFailed(throwable);
        }
        if (status.is(Status.UNDEFINED)) {
            Throwable throwable = testCaseWasUndefined.apply(this.suggestions);
            throw new TestCaseFailed(throwable);
        }
        if (status.is(Status.PENDING)) {
            Throwable throwable = testCaseWasPending.apply(error);
            throw new TestCaseFailed(throwable);
        }
        Objects.requireNonNull(error, "result.error=null while result.status=" + this.result.getStatus());
        throw new TestCaseFailed(error);
    }

    public static final class Suggestion {
        final String step;
        final List<String> snippets;

        public Suggestion(String step, List<String> snippets) {
            this.step = Objects.requireNonNull(step);
            this.snippets = Collections.unmodifiableList(Objects.requireNonNull(snippets));
        }

        public String getStep() {
            return this.step;
        }

        public List<String> getSnippets() {
            return this.snippets;
        }
    }
}

