/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.note;

import java.awt.Color;
import java.awt.Font;
import javax.swing.text.html.StyleSheet;
import org.freeplane.api.HorizontalTextAlignment;
import org.freeplane.core.ui.components.html.CssRuleBuilder;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeCss;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;

public class NoteStyleAccessor {
    private final String rule;
    private final Color noteForeground;
    private final NodeCss noteCss;
    private final Color noteBackground;
    private final HorizontalTextAlignment horizontalAlignment;
    private Font noteFont;

    public NoteStyleAccessor(ModeController modeController, NodeModel node, float zoom, boolean asHtmlFragment) {
        Controller controller = modeController.getController();
        MapModel map = controller.getMap();
        if (map != null) {
            MapStyleModel model = MapStyleModel.getExtension(map);
            NodeModel noteStyleNode = model.getStyleNodeSafe(MapStyleModel.NOTE_STYLE);
            NodeStyleController style = Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            this.noteFont = style.getFont(noteStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            this.noteBackground = style.getBackgroundColor(noteStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            this.noteForeground = style.getColor(noteStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            this.noteCss = style.getStyleSheet(noteStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            this.horizontalAlignment = style.getHorizontalTextAlignment(noteStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            CssRuleBuilder cssRuleBuilder = new CssRuleBuilder();
            if (asHtmlFragment) {
                cssRuleBuilder.withHTMLFont(this.noteFont);
            } else {
                cssRuleBuilder.withCSSFont(this.noteFont);
            }
            cssRuleBuilder.withColor(this.noteForeground).withBackground(this.noteBackground != null ? this.noteBackground : controller.getMapViewManager().getMapViewComponent().getBackground()).withAlignment(this.horizontalAlignment.swingConstant);
            if (asHtmlFragment) {
                cssRuleBuilder.withMaxWidthAsPt(zoom, NodeSizeModel.getMaxNodeWidth(noteStyleNode), style.getMaxWidth(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
            }
            this.rule = cssRuleBuilder.toString();
        } else {
            this.rule = "";
            this.noteForeground = null;
            this.noteBackground = null;
            this.noteCss = NodeCss.EMPTY;
            this.horizontalAlignment = HorizontalTextAlignment.DEFAULT;
        }
    }

    public String getNoteCSSStyle() {
        return this.rule;
    }

    public StyleSheet getNoteStyleSheet() {
        return this.noteCss.getStyleSheet();
    }

    public Color getNoteForeground() {
        return this.noteForeground;
    }

    public Color getNoteBackground() {
        return this.noteBackground;
    }

    public HorizontalTextAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public Font getNoteFont() {
        return this.noteFont;
    }
}

