/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.print;

import java.awt.Component;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.print.PageAction;
import org.freeplane.features.print.PrintAction;
import org.freeplane.features.print.PrintDirectAction;
import org.freeplane.features.print.PrintPreviewAction;
import org.freeplane.view.swing.map.MapView;

public class PrintController
implements IExtension {
    private final PageAction pageAction;
    private PageFormat pageFormat = null;
    private final PrintAction printAction;
    private final PrintDirectAction printDirectAction;
    private PrinterJob printerJob = null;
    private boolean printingAllowed;
    private final PrintPreviewAction printPreviewAction;

    public static PrintController getController() {
        Controller controller = Controller.getCurrentController();
        return controller.getExtension(PrintController.class);
    }

    public static void install() {
        Controller controller = Controller.getCurrentController();
        controller.addExtension(PrintController.class, new PrintController());
    }

    public PrintController() {
        Controller controller = Controller.getCurrentController();
        this.printAction = new PrintAction(this, true);
        this.printDirectAction = new PrintDirectAction(this);
        this.printPreviewAction = new PrintPreviewAction(this);
        this.pageAction = new PageAction(this);
        controller.addAction(this.printAction);
        controller.addAction(this.printDirectAction);
        controller.addAction(this.printPreviewAction);
        controller.addAction(this.pageAction);
        this.printingAllowed = true;
    }

    boolean acquirePrinterJobAndPageFormat(boolean showDlg) {
        if (this.printerJob == null || showDlg && Compat.isWindowsOS()) {
            try {
                this.printerJob = PrinterJob.getPrinterJob();
            }
            catch (SecurityException ex) {
                this.printAction.setEnabled(false);
                this.printDirectAction.setEnabled(false);
                this.printPreviewAction.setEnabled(false);
                this.pageAction.setEnabled(false);
                this.printingAllowed = false;
                return false;
            }
        }
        return true;
    }

    PageFormat getPageFormat() {
        if (this.pageFormat == null) {
            this.pageFormat = this.printerJob.defaultPage();
            String pageSettings = ResourceController.getResourceController().getProperty("pageSettings", null);
            if (pageSettings == null) {
                return this.pageFormat;
            }
            ParsePosition pos = new ParsePosition(0);
            NumberFormat parser = DecimalFormat.getInstance(Locale.US);
            Number pageFormatWidth = parser.parse(pageSettings, pos);
            if (pos.getErrorIndex() != -1 || pageFormatWidth == null) {
                return this.pageFormat;
            }
            pos.setIndex(pos.getIndex() + 1);
            Number pageFormatHeight = parser.parse(pageSettings, pos);
            if (pos.getErrorIndex() != -1 || pageFormatHeight == null) {
                return this.pageFormat;
            }
            pos.setIndex(pos.getIndex() + 1);
            Number pageFormatImageableX = parser.parse(pageSettings, pos);
            if (pos.getErrorIndex() != -1 || pageFormatImageableX == null) {
                return this.pageFormat;
            }
            pos.setIndex(pos.getIndex() + 1);
            Number pageFormatImageableY = parser.parse(pageSettings, pos);
            if (pos.getErrorIndex() != -1 || pageFormatImageableY == null) {
                return this.pageFormat;
            }
            pos.setIndex(pos.getIndex() + 1);
            Number pageFormatImageableWidth = parser.parse(pageSettings, pos);
            if (pos.getErrorIndex() != -1 || pageFormatImageableWidth == null) {
                return this.pageFormat;
            }
            pos.setIndex(pos.getIndex() + 1);
            Number pageFormatImageableHeight = parser.parse(pageSettings, pos);
            if (pos.getErrorIndex() != -1 || pageFormatImageableHeight == null) {
                return this.pageFormat;
            }
            pos.setIndex(pos.getIndex() + 1);
            Number pageFormatOrientation = parser.parse(pageSettings, pos);
            if (pos.getErrorIndex() != -1 || pageFormatOrientation == null) {
                return this.pageFormat;
            }
            Paper paper = (Paper)this.pageFormat.getPaper().clone();
            paper.setSize(pageFormatWidth.doubleValue(), pageFormatHeight.doubleValue());
            paper.setImageableArea(pageFormatImageableX.doubleValue(), pageFormatImageableY.doubleValue(), pageFormatImageableWidth.doubleValue(), pageFormatImageableHeight.doubleValue());
            this.pageFormat.setOrientation(pageFormatOrientation.intValue());
            this.pageFormat.setPaper(paper);
        }
        return this.pageFormat;
    }

    private PrinterJob getPrinterJob() {
        return this.printerJob;
    }

    public boolean isEnabled() {
        return this.printingAllowed;
    }

    public void pageDialog() {
        this.pageFormat = this.getPrinterJob().pageDialog(this.getPageFormat());
        Paper paper = this.pageFormat.getPaper();
        StringBuilder sb = new StringBuilder();
        NumberFormat format = DecimalFormat.getInstance(Locale.US);
        double paperWidth = paper.getWidth();
        sb.append(format.format(paperWidth)).append(' ');
        double paperHeight = paper.getHeight();
        sb.append(format.format(paperHeight)).append(' ');
        double imageableX = paper.getImageableX();
        sb.append(format.format(imageableX)).append(' ');
        double imageableY = paper.getImageableY();
        sb.append(format.format(imageableY)).append(' ');
        double imageableWidth = paper.getImageableWidth();
        sb.append(format.format(imageableWidth)).append(' ');
        double imageableHeight = paper.getImageableHeight();
        sb.append(format.format(imageableHeight)).append(' ');
        int pageFormatOrientation = this.pageFormat.getOrientation();
        sb.append(format.format(pageFormatOrientation)).append(' ');
        ResourceController.getResourceController().setProperty("pageSettings", sb.toString());
    }

    public boolean printDialog() {
        return this.getPrinterJob().printDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Printable mapView, boolean showDlg) throws PrinterException {
        if (!this.acquirePrinterJobAndPageFormat(showDlg)) {
            return;
        }
        this.getPrinterJob().setPrintable(mapView, this.getPageFormat());
        if (!showDlg || this.printDialog()) {
            if (mapView instanceof MapView) {
                ((MapView)mapView).preparePrinting();
            }
            try {
                String name;
                PrinterJob printerJob = this.getPrinterJob();
                if (mapView instanceof Component && (name = ((Component)((Object)mapView)).getName()) != null) {
                    printerJob.setJobName(name);
                }
                printerJob.print();
            }
            catch (PrinterException ex) {
                LogUtils.warn(ex);
            }
            finally {
                if (mapView instanceof MapView) {
                    ((MapView)mapView).endPrinting();
                }
            }
        }
    }
}

