/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedList;
import javax.swing.JComponent;
import org.freeplane.api.ChildNodesAlignment;
import org.freeplane.api.ChildrenSides;
import org.freeplane.features.map.NodeModel;
import org.freeplane.view.swing.map.CloudHeightCalculator;
import org.freeplane.view.swing.map.ContentSizeCalculator;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.StepFunction;

class NodeViewLayoutHelper {
    private NodeView view;
    private int topOverlap;
    private int bottomOverlap;
    private StepFunction topBoundary;
    private StepFunction bottomBoundary;
    private int minimumContentWidth = -1;

    NodeViewLayoutHelper(NodeView view) {
        this.view = view;
    }

    Dimension calculateContentSize() {
        Dimension contentSize = ContentSizeCalculator.INSTANCE.calculateContentSize(this.view, this.minimumContentWidth);
        return this.usesHorizontallayout(this.view.getContent()) ? new Dimension(contentSize.height, contentSize.width) : contentSize;
    }

    int getAdditionalCloudHeight() {
        return CloudHeightCalculator.INSTANCE.getAdditionalCloudHeight(this.view);
    }

    int getComponentCount() {
        return this.view.getComponentCount();
    }

    NodeViewLayoutHelper getComponent(int n) {
        Component component = this.view.getComponent(n);
        return component instanceof NodeView ? ((NodeView)component).getLayoutHelper() : null;
    }

    MapView getMap() {
        return this.view.getMap();
    }

    NodeModel getNode() {
        return this.view.getNode();
    }

    NodeView getView() {
        return this.view;
    }

    int getMinimalDistanceBetweenChildren() {
        return this.view.getMinimalDistanceBetweenChildren();
    }

    int getBaseDistanceToChildren(int dx) {
        return this.view.getBaseDistanceToChildren(dx);
    }

    int getSpaceAround() {
        return this.view.getSpaceAround();
    }

    ChildNodesAlignment getChildNodesAlignment() {
        return this.view.getChildNodesAlignment();
    }

    int getContentX() {
        JComponent component = this.view.getContent();
        return this.usesHorizontallayout(this.view) ? ((Component)component).getY() : ((Component)component).getX();
    }

    int getContentY() {
        JComponent component = this.view.getContent();
        return this.usesHorizontallayout(this.view) ? ((Component)component).getX() : ((Component)component).getY();
    }

    int getContentWidth() {
        JComponent component = this.view.getContent();
        return this.usesHorizontallayout(this.view) ? ((Component)component).getHeight() : ((Component)component).getWidth();
    }

    int getContentHeight() {
        JComponent component = this.view.getContent();
        return this.usesHorizontallayout(this.view) ? ((Component)component).getWidth() : ((Component)component).getHeight();
    }

    void setContentBounds(int x, int y, int width, int height) {
        JComponent component = this.view.getContent();
        if (this.usesHorizontallayout(component)) {
            component.setBounds(y, x, height, width);
        } else {
            component.setBounds(x, y, width, height);
        }
    }

    void setContentVisible(boolean aFlag) {
        this.view.getContent().setVisible(aFlag);
    }

    boolean isContentVisible() {
        return this.view.isContentVisible();
    }

    boolean isSummary() {
        return this.view.isSummary();
    }

    boolean isFirstGroupNode() {
        return this.view.isFirstGroupNode();
    }

    boolean usesHorizontalLayout() {
        return this.view.usesHorizontalLayout();
    }

    boolean isLeft() {
        return this.view.isTopOrLeft();
    }

    boolean isRight() {
        return !this.view.isTopOrLeft() && !this.view.isRoot();
    }

    boolean isRoot() {
        return this.view.isRoot();
    }

    int getHGap() {
        return this.view.getHGap();
    }

    int getShift() {
        return this.view.getShift();
    }

    boolean isFree() {
        return this.view.isFree();
    }

    int getTopOverlap() {
        return this.topOverlap;
    }

    void setTopOverlap(int topOverlap) {
        NodeViewLayoutHelper parentView = this.getParentView();
        this.topOverlap = parentView == null || this.usesHorizontalLayout() == parentView.usesHorizontalLayout() ? topOverlap : 0;
    }

    int getBottomOverlap() {
        return this.bottomOverlap;
    }

    void setBottomOverlap(int bottomOverlap) {
        NodeViewLayoutHelper parentView = this.getParentView();
        this.bottomOverlap = parentView == null || this.usesHorizontalLayout() == parentView.usesHorizontalLayout() ? bottomOverlap : 0;
    }

    StepFunction getTopBoundary() {
        return this.topBoundary;
    }

    void setTopBoundary(StepFunction topBoundary) {
        this.topBoundary = topBoundary;
    }

    StepFunction getBottomBoundary() {
        return this.bottomBoundary;
    }

    void setBottomBoundary(StepFunction bottomBoundary) {
        this.bottomBoundary = bottomBoundary;
    }

    NodeViewLayoutHelper getParentView() {
        NodeView parentView = this.view.getParentView();
        return parentView != null ? parentView.getLayoutHelper() : null;
    }

    int getZoomed(int i) {
        return this.view.getZoomed(i);
    }

    int getHeight() {
        return this.getHeight(this.view);
    }

    int getWidth() {
        return this.getWidth(this.view);
    }

    int getX() {
        return this.getX(this.view);
    }

    int getY() {
        return this.getY(this.view);
    }

    void setSize(int width, int height) {
        if (this.usesHorizontallayout(this.view.getContent())) {
            this.view.setSize(height, width);
        } else {
            this.view.setSize(width, height);
        }
    }

    void setLocation(int x, int y) {
        if (this.usesHorizontallayout(this.view)) {
            this.view.setLocation(y, x);
        } else {
            this.view.setLocation(x, y);
        }
    }

    private int getX(Component component) {
        return this.usesHorizontallayout(component) ? component.getY() : component.getX();
    }

    private int getY(Component component) {
        return this.usesHorizontallayout(component) ? component.getX() : component.getY();
    }

    private int getWidth(Component component) {
        return this.usesHorizontallayout(component) ? component.getHeight() : component.getWidth();
    }

    private int getHeight(Component component) {
        return this.usesHorizontallayout(component) ? component.getWidth() : component.getHeight();
    }

    String describeComponent(int i) {
        return this.view.getComponent(i).toString();
    }

    String getText() {
        return this.view.getNode().getText();
    }

    boolean usesHorizontallayout(Component component) {
        NodeView parent = component == this.view && this.view.isRoot() ? this.view : (NodeView)component.getParent();
        return parent.usesHorizontalLayout();
    }

    int getMinimumDistanceConsideringHandles() {
        return this.view.getMinimumDistanceConsideringHandles();
    }

    public String toString() {
        return "NodeViewLayoutHelper [view=" + this.view + "]";
    }

    ChildrenSides childrenSides() {
        return this.view.childrenSides();
    }

    boolean isSubtreeVisible() {
        return this.view.isSubtreeVisible();
    }

    void calculateMinimumChildContentWidth() {
        int[] max = new int[]{-1, -1};
        int[] previousMax = new int[]{-1, -1};
        int[] unfolded = new int[]{-1, -1};
        LinkedList<NodeView> childrenViews = this.view.getChildrenViews();
        int lastIndex = childrenViews.size();
        for (int index = 0; index < lastIndex; ++index) {
            NodeView child = childrenViews.get(index);
            if (!this.isConsideredForAlignment(child)) continue;
            int sideIndex = child.isTopOrLeft() ? 0 : 1;
            boolean marksSummary = child.getNode().isHiddenSummary();
            if (marksSummary || this.hasChildViews(child)) {
                int updatedChildIndex = unfolded[sideIndex];
                if (updatedChildIndex >= 0) {
                    NodeView updated = childrenViews.get(updatedChildIndex);
                    updated.getLayoutHelper().setMinimumContentWidth(Math.max(max[sideIndex], previousMax[sideIndex]));
                }
                if (marksSummary) {
                    unfolded[sideIndex] = -1;
                    previousMax[sideIndex] = -1;
                } else {
                    unfolded[sideIndex] = index;
                    previousMax[sideIndex] = max[sideIndex];
                }
                max[sideIndex] = -1;
                continue;
            }
            if (child.isContentVisible()) {
                max[sideIndex] = Math.max(max[sideIndex], child.getMainView().getPreferredSize().width);
            }
            child.getLayoutHelper().setMinimumContentWidth(-1);
        }
        for (int sideIndex = 0; sideIndex <= 1; ++sideIndex) {
            int updatedChildIndex = unfolded[sideIndex];
            if (updatedChildIndex < 0) continue;
            NodeView updated = childrenViews.get(updatedChildIndex);
            updated.getLayoutHelper().setMinimumContentWidth(Math.max(max[sideIndex], previousMax[sideIndex]));
        }
    }

    private void setMinimumContentWidth(int newWidth) {
        if (this.minimumContentWidth != newWidth) {
            this.minimumContentWidth = newWidth;
            this.view.invalidate();
        }
    }

    private boolean hasChildViews(NodeView child) {
        return child.getComponentCount() > 1;
    }

    private boolean isConsideredForAlignment(NodeView child) {
        return !child.isFree() && child.getCloudModel() == null && !child.getChildNodesAlignment().isStacked();
    }

    void resetMinimumChildContentWidth() {
        for (NodeView child : this.view.getChildrenViews()) {
            child.getLayoutHelper().minimumContentWidth = -1;
        }
    }

    boolean isAutoCompactLayoutEnabled() {
        return this.view.isAutoCompactLayoutEnabled();
    }
}

