/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.cycle_detection;

import com.tngtech.archunit.library.cycle_detection.Edge;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class Path<EDGE extends Edge<?>> {
    private final List<EDGE> edges;

    Path() {
        this(Collections.emptyList());
    }

    Path(Path<EDGE> other) {
        this(other.getEdges());
    }

    Path(List<EDGE> edges) {
        this.edges = new ArrayList<EDGE>(edges);
        this.validateEdgesConnect();
    }

    private void validateEdgesConnect() {
        if (this.edges.isEmpty()) {
            return;
        }
        Object expectedFrom = ((Edge)this.edges.get(0)).getOrigin();
        for (Edge edge : this.edges) {
            this.verifyEdgeFromMatches(expectedFrom, edge);
            expectedFrom = edge.getTarget();
        }
    }

    private void verifyEdgeFromMatches(Object expectedFrom, EDGE edge) {
        if (!expectedFrom.equals(edge.getOrigin())) {
            throw new IllegalArgumentException("Edges are not connected: " + this.edges);
        }
    }

    List<EDGE> getEdges() {
        return ImmutableList.copyOf(this.edges);
    }

    boolean isEmpty() {
        return this.edges.isEmpty();
    }

    boolean formsCycle() {
        if (this.isEmpty()) {
            return false;
        }
        Object start = ((Edge)this.edges.get(0)).getOrigin();
        Object end = ((Edge)Iterables.getLast(this.edges)).getTarget();
        return start.equals(end);
    }

    public int hashCode() {
        return Objects.hash(this.edges);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return Objects.equals(this.edges, other.edges);
    }

    public String toString() {
        return "Path{" + this.edgesToString() + '}';
    }

    String edgesToString() {
        return "edges=" + this.edges;
    }
}

