/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.plantuml.rules;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.PackageMatcher;
import com.tngtech.archunit.library.plantuml.rules.IllegalDiagramException;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlComponent;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlDiagram;
import com.tngtech.archunit.library.plantuml.rules.Stereotype;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;

class JavaClassDiagramAssociation {
    private final Set<AssociatedComponent> components;

    JavaClassDiagramAssociation(PlantUmlDiagram diagram) {
        ImmutableSet.Builder components = ImmutableSet.builder();
        this.validateStereotypes(diagram);
        for (PlantUmlComponent component : diagram.getAllComponents()) {
            components.add(new AssociatedComponent(component));
        }
        this.components = components.build();
    }

    private void validateStereotypes(PlantUmlDiagram plantUmlDiagram) {
        HashSet<Stereotype> visited = new HashSet<Stereotype>();
        for (PlantUmlComponent component : plantUmlDiagram.getAllComponents()) {
            for (Stereotype stereotype : component.getStereotypes()) {
                if (visited.contains(stereotype)) {
                    throw new IllegalDiagramException(String.format("Stereotype '%s' should be unique", stereotype.asString()), new Object[0]);
                }
                visited.add(stereotype);
            }
        }
    }

    Set<String> getTargetPackageIdentifiers(JavaClass javaClass) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (PlantUmlComponent target : this.getComponentOf(javaClass).getDependencies()) {
            result.addAll(this.getPackageIdentifiersFromComponentOf(target));
        }
        return result.build();
    }

    Set<String> getPackageIdentifiersFromComponentOf(JavaClass javaClass) {
        return this.getPackageIdentifiersFromComponentOf(this.getComponentOf(javaClass));
    }

    private Set<String> getPackageIdentifiersFromComponentOf(PlantUmlComponent component) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Stereotype stereotype : component.getStereotypes()) {
            result.add(stereotype.asString());
        }
        return result.build();
    }

    private PlantUmlComponent getComponentOf(JavaClass javaClass) {
        return Iterables.getOnlyElement(this.getAssociatedComponents(javaClass));
    }

    boolean contains(JavaClass javaClass) {
        return !this.getAssociatedComponents(javaClass).isEmpty();
    }

    Set<PlantUmlComponent> getAssociatedComponents(JavaClass javaClass) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AssociatedComponent component : this.components) {
            if (!component.contains(javaClass)) continue;
            result.add(component.asPlantUmlComponent());
        }
        return result.build();
    }

    private static class AssociatedComponent {
        private final PlantUmlComponent component;
        private final Set<PackageMatcher> packageMatchers;

        private AssociatedComponent(PlantUmlComponent component) {
            this.component = component;
            ImmutableSet.Builder packageMatchers = ImmutableSet.builder();
            for (Stereotype stereotype : component.getStereotypes()) {
                packageMatchers.add(PackageMatcher.of(stereotype.asString()));
            }
            this.packageMatchers = packageMatchers.build();
        }

        private boolean contains(JavaClass javaClass) {
            return this.packageMatchers.stream().anyMatch(packageMatcher -> packageMatcher.matches(javaClass.getPackageName()));
        }

        PlantUmlComponent asPlantUmlComponent() {
            return this.component;
        }
    }
}

