/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode.mindmapmode;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.io.comparator.NameFileComparator;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.ActionAcceleratorManager;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.ChildActionEntryRemover;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.FreeplaneActions;
import org.freeplane.features.mode.ModeController;

public class LoadAcceleratorPresetsAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final URL resource;

    private static File getAcceleratorsSysDirectory() {
        return new File(ResourceController.getResourceController().getResourceBaseDir(), "accelerators");
    }

    static File getAcceleratorsUserDirectory() {
        return new File(ResourceController.getResourceController().getFreeplaneUserDirectory(), "accelerators");
    }

    public static final void install(ModeController modeController) {
        modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "acceleratorPresets", (EntryVisitor)new AcceleratorPresetsBuilder(modeController), (EntryVisitor)new ChildActionEntryRemover((FreeplaneActions)modeController));
    }

    LoadAcceleratorPresetsAction(URL resource, String propFileName, String title) {
        super("LoadAcceleratorPresetsAction." + propFileName, title, null);
        this.resource = resource;
    }

    public void actionPerformed(ActionEvent e) {
        try (InputStream in = this.resource.openStream();){
            ActionAcceleratorManager acclMgr = ResourceController.getResourceController().getAcceleratorManager();
            acclMgr.loadAcceleratorPresets(in);
            acclMgr.saveAcceleratorPresets();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    static class AcceleratorPresetsBuilder
    implements EntryVisitor {
        private final ModeController modeController;

        public AcceleratorPresetsBuilder(ModeController modeController) {
            this.modeController = modeController;
        }

        public void visit(Entry target) {
            File[] dirs;
            for (File dir : dirs = new File[]{LoadAcceleratorPresetsAction.getAcceleratorsUserDirectory(), LoadAcceleratorPresetsAction.getAcceleratorsSysDirectory()}) {
                File[] fileList = dir.listFiles();
                if (fileList == null) continue;
                Arrays.sort(fileList, NameFileComparator.NAME_COMPARATOR);
                for (File prop : fileList) {
                    String fileName = prop.getName();
                    if (prop.isDirectory() || !fileName.endsWith(".properties")) continue;
                    try {
                        int propNameLength = fileName.lastIndexOf(46);
                        String propName = fileName.substring(0, propNameLength);
                        String key = "LoadAcceleratorPresetsAction." + propName;
                        String title = TextUtils.getText((String)(key + ".text"), (String)propName);
                        LoadAcceleratorPresetsAction loadAcceleratorPresetsAction = new LoadAcceleratorPresetsAction(prop.toURL(), key, title);
                        this.modeController.addActionIfNotAlreadySet((AFreeplaneAction)loadAcceleratorPresetsAction);
                        new EntryAccessor().addChildAction(target, (AFreeplaneAction)loadAcceleratorPresetsAction);
                    }
                    catch (Exception e) {
                        UITools.errorMessage((Object)TextUtils.format((String)"accelerators_loading_error", (Object[])new Object[]{prop.getPath()}));
                    }
                }
            }
        }

        public boolean shouldSkipChildren(Entry entry) {
            return true;
        }
    }
}

