/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application.survey;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.mode.Controller;
import org.freeplane.main.application.survey.FreeplaneSurveyProperties;

public class SurveyRunner {
    private static final int MINIMAL_DAYS_BETWEEN_SURVEYS = 11;
    private static final int MINIMAL_DAYS_BETWEEN_SURVEY_REMINDERS = 3;
    private final FreeplaneSurveyProperties freeplaneSurveyProperties;
    private String surveyId;
    private boolean userVisitedVotingLink = false;

    public SurveyRunner(FreeplaneSurveyProperties freeplaneSurveyProperties) {
        this.freeplaneSurveyProperties = freeplaneSurveyProperties;
    }

    public void runServey(String id, String title, String question, String surveyUrl) {
        if (!this.freeplaneSurveyProperties.mayAskUserToFillSurvey(this.surveyId)) {
            return;
        }
        this.surveyId = id;
        this.freeplaneSurveyProperties.setNextSurveyDay(11);
        JButton go = new JButton("With pleasure");
        go.setToolTipText("Thank you so much!");
        JButton notInterested = new JButton("Not interested");
        notInterested.setToolTipText("We shall not repeat this question, but may be ask you another one.");
        JButton remindMeLater = new JButton("Remind me later");
        remindMeLater.setToolTipText("The same question can be repeated some days later.");
        JButton never = new JButton("Don't ask me anything again");
        never.setToolTipText("We are sorry! We shall never ask you any question like this again.");
        Object[] options = new JButton[]{go, notInterested, remindMeLater, never};
        OptionButtonListener optionButtonListener = new OptionButtonListener();
        for (JButton jButton : options) {
            jButton.addActionListener(optionButtonListener);
        }
        final List<Image> iconImages = UITools.getFrame().getIconImages();
        final JEditorPane messageComponent = new JEditorPane("text/html", question);
        messageComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        messageComponent.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        URL url = e.getURL();
                        SurveyRunner.this.openSurvey(url);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SurveyRunner.this.userVisitedVotingLink = true;
                    SwingUtilities.getWindowAncestor(messageComponent).setVisible(false);
                }
            }
        });
        messageComponent.setEditable(false);
        messageComponent.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (messageComponent.isShowing()) {
                    messageComponent.removeHierarchyListener(this);
                    Window window = SwingUtilities.getWindowAncestor(messageComponent);
                    if (window instanceof JDialog) {
                        ((JDialog)window).setDefaultCloseOperation(0);
                    }
                    window.setIconImages(iconImages);
                }
            }
        });
        int userDecision = JOptionPane.showOptionDialog(UITools.getCurrentFrame(), messageComponent, title, -1, -1, null, options, remindMeLater);
        block1 : switch (userDecision) {
            case -1: {
                if (!this.userVisitedVotingLink) break;
                this.freeplaneSurveyProperties.markSurveyAsFilled(this.surveyId);
                break;
            }
            default: {
                switch (Options.values()[userDecision].ordinal()) {
                    case 0: {
                        try {
                            this.freeplaneSurveyProperties.markSurveyAsFilled(this.surveyId);
                            URL exception = new URL(surveyUrl);
                            this.openSurvey(exception);
                        }
                        catch (Exception exception) {}
                        break block1;
                    }
                    case 1: {
                        this.freeplaneSurveyProperties.markSurveyAsFilled(this.surveyId);
                        break block1;
                    }
                    case 2: {
                        this.freeplaneSurveyProperties.setNextSurveyDay(3);
                        this.freeplaneSurveyProperties.activateRemindMeLater();
                        break block1;
                    }
                    case 3: {
                        this.freeplaneSurveyProperties.setNeverShowSurvey();
                    }
                }
            }
        }
    }

    private void openSurvey(URL url) throws Exception {
        Controller.getCurrentController().getViewController().openDocument(url);
    }

    private static class OptionButtonListener
    implements ActionListener {
        private OptionButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component source = (Component)e.getSource();
            JOptionPane pane = (JOptionPane)SwingUtilities.getAncestorOfClass(JOptionPane.class, source);
            pane.setValue(source);
        }
    }

    static enum Options {
        GO_OPTION,
        NOT_INTERESTED_OPTION,
        REMIND_ME_LATER_OPTION,
        NEVER_OPTION;

    }
}

