/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.time.Duration;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.map.NodeStream;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.script.IScriptStarter;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.view.swing.features.time.mindmapmode.ClockState;
import org.freeplane.view.swing.features.time.mindmapmode.PeriodUnit;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderHook;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.ShowPastRemindersOnce;
import org.freeplane.view.swing.map.MapView;

public class ReminderExtension
implements IExtension,
IMapChangeListener,
IMapLifeCycleListener {
    private static final ShowPastRemindersOnce pastReminders = new ShowPastRemindersOnce();
    private static final int BLINKING_PERIOD = 1000;
    private static final int MAXIMAL_DELAY = (int)Duration.ofMinutes(5L).toMillis();
    private static final WeakHashMap<MapModel, Boolean> updatedMaps = new WeakHashMap();
    private final NodeModel node;
    private long remindUserAt = 0L;
    private PeriodUnit periodUnit;
    private int period;
    private Timer timer;
    private String script;
    private final ReminderHook reminderController;
    private boolean stateAdded = false;
    private boolean reminderInThePast = false;
    private boolean alreadyExecuted = false;

    public static ReminderExtension getExtension(NodeModel node) {
        return (ReminderExtension)node.getExtension(ReminderExtension.class);
    }

    public ReminderExtension(ReminderHook reminderController, NodeModel node) {
        this.reminderController = reminderController;
        this.node = node;
        MapController mapController = this.reminderController.getModeController().getMapController();
        mapController.addUIMapChangeListener((IMapChangeListener)this);
        mapController.addMapLifeCycleListener((IMapLifeCycleListener)this);
    }

    public NodeModel getNode() {
        return this.node;
    }

    public long getRemindUserAt() {
        return this.remindUserAt;
    }

    public void setRemindUserAt(long remindUserAt) {
        this.remindUserAt = remindUserAt;
    }

    public PeriodUnit getPeriodUnit() {
        return this.periodUnit;
    }

    public void setPeriodUnit(PeriodUnit periodUnit) {
        this.periodUnit = periodUnit;
    }

    public String getPeriodUnitAsString() {
        return this.periodUnit == null ? null : this.periodUnit.name();
    }

    public void setPeriodUnitAsString(String periodUnit) {
        this.periodUnit = PeriodUnit.valueOf(periodUnit);
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    void reminderAdded() {
        MapModel map = this.node.getMap();
        if (updatedMaps.containsKey(map)) {
            return;
        }
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        if (!mapViewManager.containsView(map)) {
            updatedMaps.put(map, Boolean.TRUE);
            return;
        }
        this.scheduleTimer();
    }

    private void reminderDisplayed() {
        this.scheduleTimer(true);
    }

    void scheduleTimer() {
        this.scheduleTimer(false);
    }

    private void scheduleTimer(boolean showPastReminders) {
        long timeBeforeReminder = this.remindUserAt - System.currentTimeMillis();
        this.reminderInThePast = timeBeforeReminder < (long)(-MAXIMAL_DELAY);
        int delay = (int)Math.min(Integer.MAX_VALUE, Math.max(0L, timeBeforeReminder));
        if (this.timer == null) {
            this.timer = new Timer(delay, this::remind);
            this.timer.setRepeats(false);
        }
        this.timer.start();
        if (this.reminderInThePast && showPastReminders) {
            pastReminders.addNode(this.node);
        }
        ReminderExtension.displayStateIcon(ClockState.CLOCK_VISIBLE, this.node, false);
    }

    void deactivateTimer() {
        if (this.timer == null) {
            return;
        }
        ReminderExtension.removeStateIcon(this.getNode());
        this.timer.stop();
        this.timer = null;
    }

    private boolean isAncestorNode(NodeModel parent) {
        for (NodeModel n = this.node; n != null; n = n.getParentNode()) {
            if (!n.equals(parent)) continue;
            return true;
        }
        return false;
    }

    private boolean containsScript() {
        return this.script != null && !this.script.isEmpty();
    }

    private void remind(ActionEvent e) {
        if (this.node.getMap().getNodeForID(this.node.getID()) != this.node) {
            return;
        }
        if (!this.alreadyExecuted && this.remindUserAt > System.currentTimeMillis()) {
            this.scheduleTimer();
            return;
        }
        if (!this.reminderInThePast && this.containsScript()) {
            this.reminderInThePast = true;
            this.runScript();
        }
        if (!this.alreadyExecuted) {
            if (!this.reminderInThePast && ResourceController.getResourceController().getBooleanProperty("remindersShowNotifications")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReminderExtension.this.reminderController.showNotificationPopup(ReminderExtension.this);
                    }
                });
            }
            this.alreadyExecuted = true;
        }
        this.stateAdded = !this.stateAdded;
        this.blink(this.stateAdded);
        if (this.timer != null) {
            this.timer.setInitialDelay(1000);
            this.timer.start();
        }
    }

    public void runScript() {
        if (!this.containsScript()) {
            return;
        }
        String script = this.getScript();
        ModeController modeController = this.reminderController.getModeController();
        IScriptStarter starter = (IScriptStarter)modeController.getExtension(IScriptStarter.class);
        if (starter == null) {
            return;
        }
        NodeModel node = this.getNode();
        MapModel map = node.getMap();
        Controller controller = modeController.getController();
        if (!controller.getMapViewManager().getMaps(modeController.getModeName()).containsValue(map)) {
            return;
        }
        try {
            starter.executeScript(node, script);
        }
        catch (Exception e) {
            LogUtils.warn((Throwable)e);
            UITools.errorMessage((Object)TextUtils.format((String)"reminder_script_error", (Object[])new Object[]{e.toString(), node.getMap().getTitle(), node.getID()}));
        }
    }

    private void blink(boolean stateAdded) {
        if (this.getNode().getMap() != Controller.getCurrentController().getMap()) {
            return;
        }
        ReminderExtension.displayStateIcon(stateAdded ? ClockState.CLOCK_INVISIBLE : ClockState.CLOCK_VISIBLE, this.getNode(), true);
        if (!ResourceController.getResourceController().getBooleanProperty("remindersBlink")) {
            this.deactivateTimer();
        }
    }

    private static void displayStateIcon(ClockState stateAdded, NodeModel pNode, boolean recurse) {
        pNode.putExtension((IExtension)stateAdded);
        Controller.getCurrentModeController().getMapController().nodeRefresh(pNode);
        if (!recurse) {
            return;
        }
        NodeModel parentNode = pNode.getParentNode();
        if (parentNode != null) {
            ReminderExtension.displayStateIcon(stateAdded, parentNode, recurse);
        }
    }

    private static void removeStateIcon(NodeModel pNode) {
        if (pNode.containsExtension(ReminderExtension.class)) {
            pNode.putExtension((IExtension)ClockState.CLOCK_VISIBLE);
        } else {
            pNode.removeExtension(ClockState.class);
        }
        Controller.getCurrentModeController().getMapController().nodeRefresh(pNode);
        NodeModel parentNode = pNode.getParentNode();
        if (parentNode != null) {
            ReminderExtension.removeStateIcon(parentNode);
        }
    }

    public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
        ReminderExtension.removeStateIcon(nodeDeletionEvent.parent);
    }

    public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
        ReminderExtension.removeStateIcon(nodeMoveEvent.oldParent);
    }

    public void onRemove(MapModel map) {
        if (this.node.getMap() == map) {
            this.deactivateTimer();
            MapController mapController = this.reminderController.getModeController().getMapController();
            mapController.removeMapChangeListener((IMapChangeListener)this);
            mapController.removeMapLifeCycleListener((IMapLifeCycleListener)this);
        }
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
            mapViewManager.addMapViewChangeListener(new IMapViewChangeListener(){

                public void afterViewCreated(Component newView) {
                    MapView mapView = (MapView)newView;
                    MapModel newMap = mapView.getMap();
                    Boolean shouldRegisterPastExceptions = (Boolean)updatedMaps.remove(newMap);
                    if (shouldRegisterPastExceptions == null) {
                        return;
                    }
                    NodeStream.of((NodeModel)newMap.getRootNode()).map(ReminderExtension::getExtension).filter(e -> e != null).forEach(rec$ -> ((ReminderExtension)rec$).reminderDisplayed());
                }
            });
        }
    }
}

