/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.properties;

import java.awt.Color;
import net.infonode.docking.properties.TabWindowProperties;
import net.infonode.properties.base.PropertyGroup;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapContainer;
import net.infonode.properties.propertymap.PropertyMapFactory;
import net.infonode.properties.propertymap.PropertyMapGroup;
import net.infonode.properties.propertymap.PropertyMapProperty;
import net.infonode.properties.propertymap.PropertyMapValueHandler;
import net.infonode.properties.types.BooleanProperty;
import net.infonode.properties.types.ColorProperty;
import net.infonode.properties.types.IntegerProperty;
import net.infonode.util.Direction;

public class WindowBarProperties
extends PropertyMapContainer {
    public static final PropertyMapGroup PROPERTIES = new PropertyMapGroup("Window Bar Properties", "");
    public static final PropertyMapProperty COMPONENT_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Component Properties", "The WindowBar component properties.", ComponentProperties.PROPERTIES);
    public static final IntegerProperty CONTENT_PANEL_EDGE_RESIZE_DISTANCE = IntegerProperty.createPositive(PROPERTIES, "Content Panel Edge Resize Distance", "Inside this distance from the content panel edge the user can resize the content panel.", 2, PropertyMapValueHandler.INSTANCE);
    public static final IntegerProperty MINIMUM_WIDTH = IntegerProperty.createPositive(PROPERTIES, "Minimum Width", "The minimum width of the window bar. If greater than 0, the window bar will always be visible and the user can drag windows to it.", 2, PropertyMapValueHandler.INSTANCE);
    public static final BooleanProperty CONTINUOUS_LAYOUT_ENABLED = new BooleanProperty((PropertyGroup)PROPERTIES, "Continuous Layout Enabled", "When enabled causes the selected tab's content to change size continuously while resizing it.", PropertyMapValueHandler.INSTANCE);
    public static final ColorProperty DRAG_INDICATOR_COLOR = new ColorProperty((PropertyGroup)PROPERTIES, "Drag Indicator Color", "The color for the resizer's drag indicator that is shown when continuous layout is disabled.", PropertyMapValueHandler.INSTANCE);
    public static final PropertyMapProperty TAB_WINDOW_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Tab Window Properties", "", TabWindowProperties.PROPERTIES);
    private static WindowBarProperties[] DEFAULT_VALUES = new WindowBarProperties[4];

    static {
        Direction[] directions = Direction.getDirections();
        int i = 0;
        while (i < directions.length) {
            Direction dir = directions[i];
            WindowBarProperties properties = new WindowBarProperties();
            properties.getTabWindowProperties().getTabbedPanelProperties().setTabAreaOrientation(dir);
            properties.getTabWindowProperties().getTabProperties().getTitledTabProperties().getNormalProperties().setDirection(dir.isHorizontal() ? Direction.DOWN : Direction.RIGHT);
            WindowBarProperties.DEFAULT_VALUES[dir.getValue()] = properties;
            ++i;
        }
    }

    public static WindowBarProperties createDefault(Direction location) {
        return new WindowBarProperties(DEFAULT_VALUES[location.getValue()]);
    }

    public WindowBarProperties() {
        super(PropertyMapFactory.create(PROPERTIES));
    }

    public WindowBarProperties(PropertyMap map) {
        super(map);
    }

    public WindowBarProperties(WindowBarProperties inheritFrom) {
        super(PropertyMapFactory.create(inheritFrom.getMap()));
    }

    public WindowBarProperties addSuperObject(WindowBarProperties properties) {
        this.getMap().addSuperMap(properties.getMap());
        return this;
    }

    public WindowBarProperties removeSuperObject() {
        this.getMap().removeSuperMap();
        return this;
    }

    public WindowBarProperties removeSuperObject(WindowBarProperties superObject) {
        this.getMap().removeSuperMap(superObject.getMap());
        return this;
    }

    public int getContentPanelEdgeResizeDistance() {
        return CONTENT_PANEL_EDGE_RESIZE_DISTANCE.get(this.getMap());
    }

    public WindowBarProperties setContentPanelEdgeResizeEdgeDistance(int width) {
        CONTENT_PANEL_EDGE_RESIZE_DISTANCE.set(this.getMap(), width);
        return this;
    }

    public int getMinimumWidth() {
        return MINIMUM_WIDTH.get(this.getMap());
    }

    public WindowBarProperties setMinimumWidth(int width) {
        MINIMUM_WIDTH.set(this.getMap(), width);
        return this;
    }

    public TabWindowProperties getTabWindowProperties() {
        return new TabWindowProperties(TAB_WINDOW_PROPERTIES.get(this.getMap()));
    }

    public ComponentProperties getComponentProperties() {
        return new ComponentProperties(COMPONENT_PROPERTIES.get(this.getMap()));
    }

    public WindowBarProperties setDragIndicatorColor(Color color) {
        DRAG_INDICATOR_COLOR.set(this.getMap(), color);
        return this;
    }

    public Color getDragIndicatorColor() {
        return DRAG_INDICATOR_COLOR.get(this.getMap());
    }

    public boolean getContinuousLayoutEnabled() {
        return CONTINUOUS_LAYOUT_ENABLED.get(this.getMap());
    }

    public WindowBarProperties setContinuousLayoutEnabled(boolean enabled) {
        CONTINUOUS_LAYOUT_ENABLED.set(this.getMap(), enabled);
        return this;
    }
}

