/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;

public class BundleClassPath {
    private final FrameworkContext fwCtx;
    private final ArrayList<FileArchive> archives = new ArrayList(4);
    private Map<String, FileArchive> nativeLibs;
    private final Debug debug;
    private final long bid;

    BundleClassPath(BundleArchive ba, BundleGeneration gen) throws BundleException {
        this.fwCtx = gen.bundle.fwCtx;
        this.debug = this.fwCtx.debug;
        this.bid = gen.bundle.id;
        this.checkBundleArchive(ba, gen.fragments);
        if (gen.fragments != null) {
            for (BundleGeneration bundleGeneration : gen.fragments) {
                this.checkBundleArchive(bundleGeneration.archive, null);
            }
        }
        this.resolveNativeCode(gen);
        if (gen.fragments != null) {
            for (BundleGeneration bundleGeneration : gen.fragments) {
                this.resolveNativeCode(bundleGeneration);
            }
        }
    }

    BundleClassPath(BundleArchive ba, FrameworkContext fwCtx) {
        this.fwCtx = fwCtx;
        this.debug = fwCtx.debug;
        this.bid = ba.getBundleId();
        this.checkBundleArchive(ba, null);
    }

    void attachFragment(BundleGeneration gen) throws BundleException {
        this.checkBundleArchive(gen.archive, null);
        this.resolveNativeCode(gen);
    }

    Vector<FileArchive> componentExists(String component, boolean onlyFirst, boolean dirs) {
        Vector<FileArchive> v;
        block7: {
            block5: {
                block6: {
                    v = null;
                    if (component.startsWith("/")) {
                        component = component.substring(1);
                    }
                    if (this.debug.classLoader) {
                        this.debug.println(this + "componentExists: " + component);
                    }
                    if (0 != component.length()) break block5;
                    if (!onlyFirst) break block6;
                    v = new Vector<FileArchive>(1);
                    v.addElement(this.archives.get(0));
                    if (!this.debug.classLoader) break block7;
                    this.debug.println(this + "compentExists added first top in classpath.");
                    break block7;
                }
                v = new Vector<FileArchive>(this.archives);
                if (!this.debug.classLoader) break block7;
                this.debug.println(this + "compentExists added all tops in classpath.");
                break block7;
            }
            for (FileArchive fa : this.archives) {
                if (!fa.exists(component, dirs)) continue;
                if (v == null) {
                    v = new Vector();
                }
                v.addElement(fa);
                if (this.debug.classLoader) {
                    this.debug.println(this + "compentExists added: " + fa);
                }
                if (!onlyFirst) continue;
                break;
            }
        }
        return v;
    }

    InputStream getInputStream(String component, int ix) {
        if (component.startsWith("/")) {
            component = component.substring(1);
        }
        return this.archives.get(ix).getBundleResourceStream(component);
    }

    String getNativeLibrary(String libName) {
        if (this.debug.classLoader) {
            this.debug.println(this + "getNativeLibrary: lib=" + libName);
        }
        if (this.nativeLibs != null) {
            String[] keys = new String[]{System.mapLibraryName(libName), libName};
            FileArchive fa = null;
            String key = null;
            String[] arr$ = keys;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String k;
                key = k = arr$[i$];
                if (this.debug.classLoader) {
                    this.debug.println(this + "getNativeLibrary: try, " + key);
                }
                if ((fa = this.nativeLibs.get(key)) == null) {
                    String libExtensions = this.fwCtx.props.getProperty("org.osgi.framework.library.extensions");
                    int pos = key.lastIndexOf(".");
                    if (libExtensions.length() > 0 && pos > -1) {
                        String[] exts;
                        String baseKey = key.substring(0, pos + 1);
                        for (String ext : exts = Util.splitwords(libExtensions, ", \t")) {
                            key = baseKey + ext;
                            if (this.debug.classLoader) {
                                this.debug.println(this + "getNativeLibrary: try, " + key);
                            }
                            if ((fa = this.nativeLibs.get(key)) != null) break;
                        }
                    }
                }
                if (fa != null) break;
            }
            if (fa == null) {
                return null;
            }
            if (this.debug.classLoader) {
                this.debug.println(this + "getNativeLibrary: got, " + fa);
            }
            return fa.getNativeLibrary(key);
        }
        return null;
    }

    public String toString() {
        return "BundleClassPath(#" + this.bid + ").";
    }

    private void checkBundleArchive(BundleArchive ba, List<BundleGeneration> frags) {
        String bcp = ba.getAttribute("Bundle-ClassPath");
        if (bcp != null) {
            StringTokenizer st = new StringTokenizer(bcp, ",");
            while (st.hasMoreTokens()) {
                String path = st.nextToken().trim();
                FileArchive a = ba.getFileArchive(path);
                if (a == null && frags != null) {
                    for (BundleGeneration bundleGeneration : frags) {
                        a = bundleGeneration.archive.getFileArchive(path);
                        if (a == null) continue;
                        break;
                    }
                }
                if (a != null) {
                    this.archives.add(a);
                    if (!this.debug.classLoader) continue;
                    this.debug.println(this + "- Added path entry: " + a);
                    continue;
                }
                this.fwCtx.frameworkWarning(ba.getBundleGeneration().bundle, (Throwable)new IllegalArgumentException("Bundle-ClassPath entry " + path + " not found in bundle"), new FrameworkListener[0]);
                if (!this.debug.classLoader) continue;
                this.debug.println(this + "- Failed to find class path entry: " + path);
            }
        } else {
            this.archives.add(ba.getFileArchive("."));
        }
    }

    private void resolveNativeCode(BundleGeneration gen) throws BundleException {
        List<String> best;
        this.nativeLibs = null;
        if (gen.nativeRequirement != null && (best = gen.nativeRequirement.checkNativeCode()) != null) {
            this.nativeLibs = new HashMap<String, FileArchive>();
            block0: for (String name : best) {
                for (FileArchive fa : this.archives) {
                    String key;
                    if (gen.isFragment() && fa.getBundleGeneration() != gen || (key = fa.checkNativeLibrary(name)) == null) continue;
                    this.nativeLibs.put(key, fa);
                    if (!this.debug.classLoader) continue block0;
                    this.debug.println(this + "- Registered native library: " + key + " -> " + fa);
                    continue block0;
                }
                this.nativeLibs = null;
                throw new BundleException("Bundle#" + this.bid + ", failed to resolve native code: " + name, 8);
            }
        }
    }

    Set<BundleGeneration> hasNativeRequirements() {
        if (this.nativeLibs != null) {
            HashSet<BundleGeneration> res = new HashSet<BundleGeneration>();
            for (FileArchive fa : this.nativeLibs.values()) {
                BundleGeneration bg = fa.getBundleGeneration();
                if (bg.nativeRequirement == null) continue;
                res.add(bg);
            }
            return res;
        }
        return null;
    }
}

