/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.awt.Color;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.cloud.CloudShape;
import org.freeplane.features.cloud.mindmapmode.MCloudController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.proxy.NodeProxy;
import org.freeplane.plugin.script.proxy.Proxy;

public class CloudProxy
implements Proxy.Cloud {
    private final NodeModel node;

    public CloudProxy(NodeProxy nodeProxy) {
        this.node = (NodeModel)nodeProxy.getDelegate();
    }

    public boolean getEnabled() {
        return this.getCloudModel() != null;
    }

    public void setEnabled(boolean enable) {
        this.getCloudController().setCloud(this.node, enable);
    }

    public String getShape() {
        CloudModel cloudModel = this.getCloudModel();
        return cloudModel == null ? null : cloudModel.getShape().name();
    }

    public void setShape(String shape) {
        if (!this.handleArgumentIfNull(shape)) {
            this.getCloudController().setShape(this.node, CloudShape.valueOf((String)shape));
        }
    }

    public Color getColor() {
        CloudModel cloudModel = this.getCloudModel();
        return cloudModel == null ? null : cloudModel.getColor();
    }

    public void setColor(Color color) {
        if (!this.handleArgumentIfNull(color)) {
            this.getCloudController().setColor(this.node, color);
        }
    }

    public String getColorCode() {
        Color color = this.getColor();
        return color == null ? null : ColorUtils.colorToString((Color)color);
    }

    public void setColorCode(String rgbString) {
        this.setColor(ColorUtils.stringToColor((String)rgbString));
    }

    private CloudModel getCloudModel() {
        return CloudModel.getModel((NodeModel)this.node);
    }

    private MCloudController getCloudController() {
        return (MCloudController)CloudController.getController();
    }

    private boolean handleArgumentIfNull(Object arg) {
        if (arg == null) {
            if (this.getEnabled()) {
                this.setEnabled(false);
            }
            return true;
        }
        return false;
    }
}

