/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMHierarchyRequestException;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.HTMLDocument;
import org.w3c.dom.Node;

public abstract class HTMLElement
extends DOMElement
implements org.w3c.dom.html.HTMLElement {
    private static final long serialVersionUID = 1L;

    HTMLElement(String tagName) {
        super(tagName, "http://www.w3.org/1999/xhtml");
    }

    HTMLElement(String localName, String namespaceUri) {
        super(localName, namespaceUri);
    }

    @Override
    void checkInsertNodeHierarchy(Node newChild, Node refNode) {
        super.checkInsertNodeHierarchy(newChild, refNode);
        if (this.isNonHTMLOrVoid()) {
            throw new DOMHierarchyRequestException("This element is void");
        }
    }

    @Override
    boolean isNonHTMLOrVoid() {
        return "br".equals(this.localName) || "hr".equals(this.localName) || "input".equals(this.localName) || "area".equals(this.localName) || "col".equals(this.localName) || "embed".equals(this.localName) || "param".equals(this.localName) || "source".equals(this.localName) || "track".equals(this.localName) || "wbr".equals(this.localName);
    }

    @Override
    boolean isNonPrintableElement() {
        String name = this.getLocalName();
        return "iframe".equals(name) || "canvas".equals(name) || "video".equals(name) || "button".equals(name) || "select".equals(name) || "noscript".equals(name);
    }

    @Override
    boolean innerTextVoidElement(DOMElement element, boolean lastTextPreserved, StringBuilder buf) {
        if ("br".equals(element.getLocalName())) {
            this.trimBuffer(lastTextPreserved, buf);
            buf.append('\n');
            return true;
        }
        return lastTextPreserved;
    }

    @Override
    public String getDir() {
        return this.getAttribute("dir");
    }

    @Override
    public void setDir(String dir) {
        this.setAttribute("dir", dir);
    }

    @Override
    public String getLang() {
        return this.getAttribute("lang");
    }

    @Override
    public void setLang(String lang) {
        this.setAttribute("lang", lang);
    }

    @Override
    public String getTitle() {
        return this.getAttribute("title");
    }

    @Override
    public void setTitle(String title) {
        this.setAttribute("title", title);
    }

    @Override
    public abstract HTMLDocument getOwnerDocument();
}

