/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Set;

class OrderedTwoValueShorthandBuilder
extends ShorthandBuilder {
    private final String initialvalue;

    OrderedTwoValueShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle, String initialvalue) {
        super(shorthandName, parentStyle);
        this.initialvalue = initialvalue;
    }

    @Override
    int appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        if (this.hasPropertiesToExclude(declaredSet)) {
            return 1;
        }
        buf.append(this.getShorthandName()).append(':');
        byte check = this.checkValuesForInherit(declaredSet);
        if (check == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return 0;
        }
        if (check == 2) {
            return 1;
        }
        check = this.checkValuesForType(CSSValue.Type.REVERT, declaredSet);
        if (check == 1) {
            buf.append("revert");
            this.appendPriority(buf, important);
            return 0;
        }
        if (check == 2) {
            return 1;
        }
        check = this.checkValuesForType(CSSValue.Type.UNSET, declaredSet);
        if (check == 1) {
            if (this.isInheritedProperty() || this.initialvalue.length() > 5) {
                buf.append("unset");
            } else {
                buf.append(this.initialvalue);
            }
            this.appendPriority(buf, important);
            return 0;
        }
        if (check == 2 && this.isInheritedProperty()) {
            return 1;
        }
        if (this.checkValuesForType(CSSValue.Type.INTERNAL, declaredSet) != 0) {
            return 1;
        }
        String[] subp = this.getSubproperties();
        if (subp.length != 2) {
            throw new IllegalStateException("This class is only for two subproperties");
        }
        String property = subp[0];
        StyleValue cssVal = this.getCSSValue(property);
        if (cssVal.getCssValueType() == CSSValue.CssType.LIST && ((ValueList)cssVal).isCommaSeparated()) {
            return 1;
        }
        StyleValue cssVal2 = this.getCSSValue(subp[1]);
        boolean eqValues = this.valueEquals(cssVal, cssVal2);
        boolean ni1 = this.isNotInitialValue(cssVal, property);
        boolean ni2 = this.isNotInitialValue(cssVal2, property);
        boolean appended = false;
        if (ni1 || !eqValues && ni2) {
            this.appendValueText(buf, cssVal, false);
            appended = true;
        }
        if (!eqValues && appended) {
            this.appendValueText(buf, cssVal2, appended);
            appended = true;
        }
        if (!appended) {
            buf.append(this.initialvalue);
        }
        this.appendPriority(buf, important);
        return 0;
    }

    @Override
    boolean isInheritedProperty() {
        String ptyname = this.getLonghandProperties()[0];
        return PropertyDatabase.getInstance().isInherited(ptyname);
    }

    @Override
    protected boolean isNotInitialValue(StyleValue cssVal, String propertyName) {
        return cssVal != null && !this.isEffectiveInitialKeyword(cssVal) && !this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    private void appendValueText(StringBuilder buf, StyleValue cssVal, boolean prepend) {
        if (prepend) {
            buf.append(' ');
        }
        buf.append(cssVal.getMinifiedCssText(this.getShorthandName()));
    }
}

