/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.component;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.gephi.ui.utils.UIUtils;
import org.gephi.visualization.component.VizToolbarGroup;

public class VizToolbar
extends JToolBar {
    public VizToolbar(VizToolbarGroup[] groups) {
        this.initDesign();
        for (VizToolbarGroup g : groups) {
            this.addSeparator();
            for (JComponent c : g.getToolbarComponents()) {
                this.add(c);
            }
        }
    }

    private void initDesign() {
        this.setFloatable(false);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 4, 0));
        this.setOpaque(true);
    }

    public void setEnable(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component c : VizToolbar.this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        });
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof JButton) {
            UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
        }
        return super.add(comp);
    }
}

