/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.timeline;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gephi.desktop.timeline.TimelineTopComponent;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.TimeFormat;
import org.gephi.timeline.api.TimelineController;
import org.gephi.timeline.api.TimelineModel;
import org.jdesktop.swingx.JXHeader;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.swing.ValidationPanel;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CustomBoundsDialog
extends JPanel {
    private static final String DATE_TIME_FORMAT_HELP_TEXT = "ISO 8601";
    private TimelineModel model;
    private TimelineController controller;
    private JTextField endTextField;
    private JLabel labelBounds;
    private JLabel labelEndDate;
    private JLabel labelIntervalDate;
    private JLabel labelMaxDate;
    private JLabel labelMinDate;
    private JLabel labelStartDate;
    private JTextField maxTextField;
    private JTextField minTextField;
    private JButton resetDefaultsDate;
    private JTextField startTextField;
    private JXHeader titleHeader;

    public CustomBoundsDialog() {
        this.initComponents();
        this.resetDefaultsDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomBoundsDialog.this.setDefaults();
            }
        });
    }

    public static ValidationPanel createValidationPanel(CustomBoundsDialog panel) {
        ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)panel);
        ValidationGroup group = validationPanel.getValidationGroup();
        panel.createValidation(group, validationPanel);
        return validationPanel;
    }

    public void setDefaults() {
        switch (this.model.getTimeFormat()) {
            case DATE: {
                this.minTextField.setText(AttributeUtils.printDateTime((double)this.model.getMin()));
                this.maxTextField.setText(AttributeUtils.printDateTime((double)this.model.getMax()));
                this.startTextField.setText(AttributeUtils.printDateTime((double)this.model.getMin()));
                this.endTextField.setText(AttributeUtils.printDateTime((double)this.model.getMax()));
                break;
            }
            case DATETIME: {
                this.minTextField.setText(AttributeUtils.printDateTime((double)this.model.getMin()));
                this.maxTextField.setText(AttributeUtils.printDateTime((double)this.model.getMax()));
                this.startTextField.setText(AttributeUtils.printDateTime((double)this.model.getMin()));
                this.endTextField.setText(AttributeUtils.printDateTime((double)this.model.getMax()));
                break;
            }
            default: {
                NumberFormat f = NumberFormat.getInstance(Locale.ENGLISH);
                f.setGroupingUsed(false);
                f.setMaximumFractionDigits(20);
                this.minTextField.setText(f.format(this.model.getMin()));
                this.maxTextField.setText(f.format(this.model.getMax()));
                this.startTextField.setText(f.format(this.model.getMin()));
                this.endTextField.setText(f.format(this.model.getMax()));
            }
        }
    }

    public void setup(TimelineModel timelineModel) {
        this.model = timelineModel;
        this.controller = (TimelineController)Lookup.getDefault().lookup(TimelineController.class);
        this.setDefaults();
        switch (this.model.getTimeFormat()) {
            case DATE: {
                this.minTextField.setText(AttributeUtils.printDateTime((double)this.model.getCustomMin()));
                this.maxTextField.setText(AttributeUtils.printDateTime((double)this.model.getCustomMax()));
                this.startTextField.setText(AttributeUtils.printDateTime((double)this.model.getIntervalStart()));
                this.endTextField.setText(AttributeUtils.printDateTime((double)this.model.getIntervalEnd()));
                break;
            }
            case DATETIME: {
                this.minTextField.setText(AttributeUtils.printDateTime((double)this.model.getCustomMin()));
                this.maxTextField.setText(AttributeUtils.printDateTime((double)this.model.getCustomMax()));
                this.startTextField.setText(AttributeUtils.printDateTime((double)this.model.getIntervalStart()));
                this.endTextField.setText(AttributeUtils.printDateTime((double)this.model.getIntervalEnd()));
                break;
            }
            default: {
                NumberFormat f = NumberFormat.getInstance(Locale.ENGLISH);
                f.setGroupingUsed(false);
                f.setMaximumFractionDigits(20);
                this.minTextField.setText(f.format(this.model.getCustomMin()));
                this.maxTextField.setText(f.format(this.model.getCustomMax()));
                this.startTextField.setText(f.format(this.model.getIntervalStart()));
                this.endTextField.setText(f.format(this.model.getIntervalEnd()));
            }
        }
    }

    public void unsetup() {
        if (this.model.getTimeFormat().equals((Object)TimeFormat.DATE) || this.model.getTimeFormat().equals((Object)TimeFormat.DATETIME)) {
            double min = AttributeUtils.parseDateTime((String)this.minTextField.getText());
            double max = AttributeUtils.parseDateTime((String)this.maxTextField.getText());
            double start = AttributeUtils.parseDateTime((String)this.startTextField.getText());
            double end = AttributeUtils.parseDateTime((String)this.endTextField.getText());
            start = Math.max(min, start);
            end = Math.min(max, end);
            this.controller.setCustomBounds(min, max);
            this.controller.setInterval(start, end);
        } else {
            double min = Double.parseDouble(this.minTextField.getText());
            double max = Double.parseDouble(this.maxTextField.getText());
            double start = Double.parseDouble(this.startTextField.getText());
            double end = Double.parseDouble(this.endTextField.getText());
            start = Math.max(min, start);
            end = Math.min(max, end);
            this.controller.setCustomBounds(min, max);
            this.controller.setInterval(start, end);
        }
    }

    public void createValidation(ValidationGroup group, ValidationPanel panel) {
        group.add((Object)this.minTextField, new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING, new FormatValidator(), new TimeValidator(this.maxTextField, false)});
        group.add((Object)this.maxTextField, new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING, new FormatValidator(), new TimeValidator(this.minTextField, true)});
        group.add((Object)this.startTextField, new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING, new FormatValidator(), new TimeValidator(this.endTextField, false)});
        group.add((Object)this.endTextField, new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING, new FormatValidator(), new TimeValidator(this.startTextField, true)});
    }

    private void initComponents() {
        this.titleHeader = new JXHeader();
        this.labelBounds = new JLabel();
        this.labelMinDate = new JLabel();
        this.labelMaxDate = new JLabel();
        this.labelIntervalDate = new JLabel();
        this.labelStartDate = new JLabel();
        this.labelEndDate = new JLabel();
        this.resetDefaultsDate = new JButton();
        this.minTextField = new JTextField();
        this.maxTextField = new JTextField();
        this.startTextField = new JTextField();
        this.endTextField = new JTextField();
        this.titleHeader.setDescription(NbBundle.getMessage(TimelineTopComponent.class, (String)"CustomBoundsDialog.titleHeader.description"));
        this.titleHeader.setIcon((Icon)ImageUtilities.loadImageIcon((String)"DesktopTimeline/custom_bounds.png", (boolean)false));
        this.titleHeader.setTitle(NbBundle.getMessage(TimelineTopComponent.class, (String)"CustomBoundsDialog.titleHeader.title"));
        this.labelBounds.setFont(this.labelBounds.getFont().deriveFont(this.labelBounds.getFont().getStyle() | 1));
        this.labelBounds.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"CustomBoundsDialog.labelBounds.text"));
        this.labelMinDate.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"CustomBoundsDialog.labelMinDate.text"));
        this.labelMaxDate.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"CustomBoundsDialog.labelMaxDate.text"));
        this.labelIntervalDate.setFont(this.labelIntervalDate.getFont().deriveFont(this.labelIntervalDate.getFont().getStyle() | 1));
        this.labelIntervalDate.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"CustomBoundsDialog.labelIntervalDate.text"));
        this.labelStartDate.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"CustomBoundsDialog.labelStartDate.text"));
        this.labelEndDate.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"CustomBoundsDialog.labelEndDate.text"));
        this.resetDefaultsDate.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"CustomBoundsDialog.resetDefaultsDate.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.titleHeader, -1, 564, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.resetDefaultsDate)).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelMinDate).addComponent(this.labelStartDate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.minTextField, -2, 162, -2).addGap(47, 47, 47).addComponent(this.labelMaxDate)).addGroup(layout.createSequentialGroup().addComponent(this.startTextField, -2, 162, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.labelEndDate))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maxTextField, -2, 162, -2).addComponent(this.endTextField, -2, 162, -2))).addComponent(this.labelIntervalDate).addComponent(this.labelBounds)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.titleHeader, -2, 83, -2).addGap(18, 18, 18).addComponent(this.labelBounds).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelMinDate).addComponent(this.minTextField, -2, -1, -2).addComponent(this.labelMaxDate).addComponent(this.maxTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.labelIntervalDate).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startTextField, -2, -1, -2).addComponent(this.labelStartDate).addComponent(this.labelEndDate).addComponent(this.endTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.resetDefaultsDate).addContainerGap(43, Short.MAX_VALUE)));
    }

    private class FormatValidator
    implements Validator<String> {
        private FormatValidator() {
        }

        public void validate(Problems prblms, String string, String t) {
            if (CustomBoundsDialog.this.model.getTimeFormat().equals((Object)TimeFormat.DATE)) {
                try {
                    AttributeUtils.parseDateTime((String)t);
                }
                catch (Exception ex) {
                    prblms.add(NbBundle.getMessage(CustomBoundsDialog.class, (String)"CustomBoundsDialog.FormatValidator.date", (Object)CustomBoundsDialog.DATE_TIME_FORMAT_HELP_TEXT));
                }
            } else if (CustomBoundsDialog.this.model.getTimeFormat().equals((Object)TimeFormat.DATETIME)) {
                try {
                    AttributeUtils.parseDateTime((String)t);
                }
                catch (Exception ex) {
                    prblms.add(NbBundle.getMessage(CustomBoundsDialog.class, (String)"CustomBoundsDialog.FormatValidator.date", (Object)CustomBoundsDialog.DATE_TIME_FORMAT_HELP_TEXT));
                }
            } else {
                try {
                    Double.parseDouble(t);
                }
                catch (Exception e) {
                    prblms.add(NbBundle.getMessage(CustomBoundsDialog.class, (String)"CustomBoundsDialog.FormatValidator.double"));
                }
            }
        }

        public Class<String> modelType() {
            return String.class;
        }
    }

    private class TimeValidator
    implements Validator<String> {
        private final JTextField other;
        private final boolean max;

        public TimeValidator(JTextField other, boolean max) {
            this.other = other;
            this.max = max;
        }

        public void validate(Problems prblms, String string, String t) {
            if (CustomBoundsDialog.this.model.getTimeFormat().equals((Object)TimeFormat.DATE) || CustomBoundsDialog.this.model.getTimeFormat().equals((Object)TimeFormat.DATETIME)) {
                try {
                    double maxDate;
                    double thisDate = AttributeUtils.parseDateTime((String)t);
                    double otherDate = AttributeUtils.parseDateTime((String)this.other.getText());
                    double minDate = this.max ? otherDate : thisDate;
                    double d = maxDate = this.max ? thisDate : otherDate;
                    if (minDate < CustomBoundsDialog.this.model.getMin()) {
                        prblms.add(NbBundle.getMessage(CustomBoundsDialog.class, (String)"CustomBoundsDialog.TimeValidator.min"));
                    }
                    if (maxDate > CustomBoundsDialog.this.model.getMax()) {
                        prblms.add(NbBundle.getMessage(CustomBoundsDialog.class, (String)"CustomBoundsDialog.TimeValidator.max"));
                    }
                    if (minDate >= maxDate) {
                        prblms.add(NbBundle.getMessage(CustomBoundsDialog.class, (String)"CustomBoundsDialog.TimeValidator"));
                    }
                }
                catch (Exception ex) {
                    prblms.add(NbBundle.getMessage(CustomBoundsDialog.class, (String)"CustomBoundsDialog.FormatValidator.date", (Object)CustomBoundsDialog.DATE_TIME_FORMAT_HELP_TEXT));
                }
            } else {
                try {
                    double maxDate;
                    double thisDate = Double.parseDouble(t);
                    double otherDate = Double.parseDouble(this.other.getText());
                    double minDate = this.max ? otherDate : thisDate;
                    double d = maxDate = this.max ? thisDate : otherDate;
                    if (minDate < CustomBoundsDialog.this.model.getMin()) {
                        prblms.add(NbBundle.getMessage(CustomBoundsDialog.class, (String)"CustomBoundsDialog.TimeValidator.min"));
                    }
                    if (maxDate > CustomBoundsDialog.this.model.getMax()) {
                        prblms.add(NbBundle.getMessage(CustomBoundsDialog.class, (String)"CustomBoundsDialog.TimeValidator.max"));
                    }
                    if (minDate >= maxDate) {
                        prblms.add(NbBundle.getMessage(CustomBoundsDialog.class, (String)"CustomBoundsDialog.TimeValidator"));
                    }
                }
                catch (Exception e) {
                    prblms.add(NbBundle.getMessage(CustomBoundsDialog.class, (String)"CustomBoundsDialog.FormatValidator.double"));
                }
            }
        }

        public Class<String> modelType() {
            return String.class;
        }
    }
}

