/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.gnome.libsecret;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.keyring.gnome.libsecret.Glib;
import org.netbeans.modules.keyring.gnome.libsecret.LibSecret;
import org.netbeans.modules.keyring.impl.KeyringSupport;
import org.netbeans.spi.keyring.KeyringProvider;

public class GnomeLibSecretProvider
implements KeyringProvider {
    private static final Logger LOG = Logger.getLogger(GnomeLibSecretProvider.class.getName());
    private static final String KEY = "key";
    private static final Charset CHARSET = Charset.forName(Native.getDefaultStringEncoding());
    private final String appName = KeyringSupport.getAppName();
    private LibSecret.SecretSchema secretSchema = null;

    private LibSecret.SecretSchema getSchema() {
        if (this.secretSchema != null) {
            return this.secretSchema;
        }
        this.secretSchema = new LibSecret.SecretSchema();
        this.secretSchema.name = this.appName;
        this.secretSchema.flags = 0;
        this.secretSchema.attributes[0] = new LibSecret.SecretSchemaAttribute();
        this.secretSchema.attributes[0].name = KEY;
        this.secretSchema.attributes[0].type = 0;
        return this.secretSchema;
    }

    public boolean enabled() {
        if (Boolean.getBoolean("netbeans.keyring.no.native")) {
            LOG.fine("native keyring integration disabled");
            return false;
        }
        try {
            this.read("NoNeXiStEnT");
            return true;
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, null, e);
            return false;
        }
        catch (UnsatisfiedLinkError e) {
            LOG.log(Level.FINE, null, e);
            return false;
        }
    }

    public char[] read(String key) {
        PointerByReference gerrorBuffer = new PointerByReference();
        LibSecret.SecretSchema schema = this.getSchema();
        Pointer pointer = LibSecret.INSTANCE.secret_password_lookup_sync(schema, null, gerrorBuffer, KEY, key);
        if (gerrorBuffer.getValue() != null) {
            this.processError(gerrorBuffer);
            return null;
        }
        if (pointer == null) {
            return null;
        }
        return this.decode(this.readZeroTerminatedBytes(pointer));
    }

    public void save(String key, char[] password, String description) {
        PointerByReference gerrorBuffer = new PointerByReference();
        LibSecret.SecretSchema schema = this.getSchema();
        String label = this.appName + " - " + (description != null ? description : key);
        LibSecret.INSTANCE.secret_password_store_sync(schema, "default", label, this.encode(password), null, gerrorBuffer, KEY, key);
        if (gerrorBuffer.getValue() != null) {
            this.processError(gerrorBuffer);
        }
    }

    public void delete(String key) {
        PointerByReference gerrorBuffer = new PointerByReference();
        LibSecret.SecretSchema schema = this.getSchema();
        LibSecret.INSTANCE.secret_password_clear_sync(schema, null, gerrorBuffer, KEY, key);
        if (gerrorBuffer.getValue() != null) {
            this.processError(gerrorBuffer);
        }
    }

    private void processError(PointerByReference gerrorBuffer) throws IllegalArgumentException {
        try {
            Glib.GError gerror = (Glib.GError)Structure.newInstance(Glib.GError.class, (Pointer)gerrorBuffer.getValue());
            gerror.read();
            throw new RuntimeException(String.format("%d/%d: %s", gerror.domain, gerror.code, gerror.message));
        }
        catch (Throwable throwable) {
            Glib.INSTANCE.g_error_free(gerrorBuffer.getValue());
            throw throwable;
        }
    }

    private byte[] encode(char[] password) {
        ByteBuffer encodedPasswordBuffer = CHARSET.encode(CharBuffer.wrap(password));
        byte[] encodedPassword = new byte[encodedPasswordBuffer.limit() + 1];
        encodedPasswordBuffer.get(encodedPassword, 0, encodedPasswordBuffer.limit());
        return encodedPassword;
    }

    private char[] decode(byte[] bytes) {
        CharBuffer decodedPasswordBuffer = CHARSET.decode(ByteBuffer.wrap(bytes));
        char[] decodedPassword = new char[decodedPasswordBuffer.limit()];
        decodedPasswordBuffer.get(decodedPassword, 0, decodedPasswordBuffer.limit());
        return decodedPassword;
    }

    private byte[] readZeroTerminatedBytes(Pointer pointer) {
        byte curVal;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < 100000 && (curVal = pointer.getByte((long)i)) != 0; ++i) {
            baos.write(curVal);
        }
        return baos.toByteArray();
    }
}

