/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ValidatorUtils;
import org.netbeans.validation.api.ui.SwingValidationListenerFactories;
import org.netbeans.validation.api.ui.ValidationListener;
import org.netbeans.validation.api.ui.ValidationStrategy;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.util.Lookup;

public abstract class ValidationListenerFactory<CompType, ModelType> {
    private final Class<CompType> componentType;
    private final Class<ModelType> modelType;

    protected ValidationListenerFactory(Class<CompType> componentType, Class<ModelType> modelType) {
        this.componentType = componentType;
        this.modelType = modelType;
    }

    final Class<CompType> componentType() {
        return this.componentType;
    }

    final Class<ModelType> modelType() {
        return this.modelType;
    }

    public static <CType, MType> ValidationListener<CType> createValidationListener(CType component, ValidationStrategy strategy, ValidationUI validationUI, Validator<MType> validator) {
        Class modelType = validator.modelType();
        ValidationListener<CType> result = null;
        if (component instanceof JComponent || component.getClass().isArray() && JComponent.class.isAssignableFrom(component.getClass().getComponentType())) {
            result = ValidationListenerFactory.findBuiltInValidationListener(component, strategy, validationUI, validator);
        }
        if (result == null) {
            Collection registered = Lookup.getDefault().lookupAll(ValidationListenerFactory.class);
            if (Object.class.equals((Object)modelType)) {
                Logger.getLogger(ValidationListenerFactory.class.getName()).log(Level.WARNING, "Bad form to create a Validator<Object>: {0}", validator.getClass().getName());
            }
            Class<?> compType = component.getClass();
            for (ValidationListenerFactory f : registered) {
                ValidationListenerFactory cast;
                if (!f.componentType().isAssignableFrom(compType) || (cast = f.as(compType, modelType, component)) == null) continue;
                return cast.createListener(component, strategy, validationUI, validator);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("No registered validator for components of type " + component.getClass().getName() + " and validators for objects of type " + modelType);
        }
        return result;
    }

    static <CType, MType> ValidationListener<CType> findBuiltInValidationListener(CType component, ValidationStrategy strategy, ValidationUI validationUI, Validator<MType> validator) {
        Class modelType = validator.modelType();
        if (component instanceof JList && Integer[].class.equals((Object)modelType)) {
            return SwingValidationListenerFactories.createJListValidationListenerConverted((JList)component, strategy, validationUI, (Validator<Integer[]>)ValidatorUtils.cast(Integer[].class, validator));
        }
        if (component instanceof JList && ListSelectionModel.class.isAssignableFrom(modelType)) {
            return SwingValidationListenerFactories.createJListValidationListener((JList)JList.class.cast(component), strategy, validationUI, validator);
        }
        if (component instanceof JTextComponent && String.class.equals((Object)modelType)) {
            return SwingValidationListenerFactories.createJTextComponentValidationListener((JTextComponent)JTextComponent.class.cast(component), strategy, validationUI, new Validator[]{validator});
        }
        if (component instanceof JTextComponent && Document.class.isAssignableFrom(modelType)) {
            return SwingValidationListenerFactories.createJTextComponentValidationListener((JTextComponent)JTextComponent.class.cast(component), strategy, validationUI, validator);
        }
        if (component instanceof JComboBox && String.class.equals((Object)modelType)) {
            return SwingValidationListenerFactories.createJComboBoxValidationListener((JComboBox)JComboBox.class.cast(component), strategy, validationUI, new Validator[]{validator});
        }
        if (component instanceof JComboBox && ComboBoxModel.class.isAssignableFrom(modelType)) {
            return SwingValidationListenerFactories.createJComboBoxValidationListener((JComboBox)JComboBox.class.cast(component), strategy, validationUI, validator);
        }
        if (ButtonModel[].class.equals((Object)modelType) && component.getClass().isArray() && component.getClass().getComponentType().isAssignableFrom(AbstractButton.class)) {
            return SwingValidationListenerFactories.createButtonsValidationListener((AbstractButton[])AbstractButton[].class.cast(component), validationUI, validator);
        }
        if (Integer[].class.equals((Object)modelType) && component.getClass().isArray() && component.getClass().getComponentType().isAssignableFrom(AbstractButton.class)) {
            return SwingValidationListenerFactories.createButtonsValidationListener((AbstractButton[])AbstractButton[].class.cast(component), validationUI, new Validator[]{validator});
        }
        return null;
    }

    protected abstract ValidationListener<CompType> createListener(CompType var1, ValidationStrategy var2, ValidationUI var3, Validator<ModelType> var4);

    <T, R> ValidationListenerFactory<T, R> as(Class<T> actualCompType, Class<R> actualModelType, T comp) {
        return new Cast(actualCompType, actualModelType, comp, this);
    }

    private static final class Cast<CompType, ModelType, T, R>
    extends ValidationListenerFactory<CompType, ModelType> {
        private final ValidationListenerFactory<T, R> other;

        Cast(Class<CompType> compType, Class<ModelType> model, CompType comp, ValidationListenerFactory<T, R> other) {
            super(compType, model);
            this.other = other;
        }

        @Override
        protected ValidationListener<CompType> createListener(CompType component, ValidationStrategy strategy, ValidationUI validationUI, Validator<ModelType> validator) {
            Object t = ((ValidationListenerFactory)this.other).componentType.cast(component);
            Validator v = ValidatorUtils.cast(this.other.modelType(), validator);
            ValidationListener<T> real = this.other.createListener(t, strategy, validationUI, v);
            return real;
        }
    }
}

