/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;

public class Speed {
    private double _value = 0.0;
    private Unit _unit = null;
    private boolean _valid;
    private boolean _inverted = false;

    public Speed(String string, Unit unit) {
        this(string, unit, false);
    }

    public Speed(String string, Unit unit, boolean bl) {
        try {
            this._value = bl ? -Double.parseDouble(string) : Double.parseDouble(string);
            this._unit = unit;
            this._valid = Speed.isValidUnit(unit);
            this._inverted = bl;
        }
        catch (Exception exception) {
            this._valid = false;
        }
    }

    public static Speed createOrNull(String string, Unit unit) {
        return Speed.createOrNull(string, unit, false);
    }

    public static Speed createOrNull(String string, Unit unit, boolean bl) {
        Speed speed = new Speed(string, unit, bl);
        return speed.isValid() ? speed : null;
    }

    private static boolean isValidUnit(Unit unit) {
        return unit == UnitSetLibrary.SPEED_UNITS_METRESPERSEC || unit == UnitSetLibrary.SPEED_UNITS_KMPERHOUR || unit == UnitSetLibrary.SPEED_UNITS_FEETPERSEC || unit == UnitSetLibrary.SPEED_UNITS_MILESPERHOUR || unit == UnitSetLibrary.SPEED_UNITS_KNOTS;
    }

    public double getValue() {
        return this._value;
    }

    public Unit getUnit() {
        return this._unit;
    }

    public double getValueInMetresPerSec() {
        if (!this._valid) {
            return 0.0;
        }
        return this._value / this._unit.getMultFactorFromStd();
    }

    public double getValue(Unit unit) {
        if (!this._valid || !Speed.isValidUnit(unit)) {
            return 0.0;
        }
        return this.getValueInMetresPerSec() * unit.getMultFactorFromStd();
    }

    public boolean isValid() {
        return this._valid;
    }

    public boolean isInverted() {
        return this._inverted;
    }

    public void copyFrom(Speed speed) {
        this._value = speed._value;
        this._unit = speed._unit;
        this._valid = speed._valid;
        this._inverted = speed._inverted;
    }
}

