/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.provider.ConfigurationTimeBarrier;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.execution.plan.FinalizedExecutionPlan;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;

public class DryRunBuildExecutionAction
implements BuildWorkExecutor {
    private final BuildWorkExecutor delegate;
    private final StyledTextOutputFactory textOutputFactory;
    private final ConfigurationTimeBarrier configurationTimeBarrier;

    public DryRunBuildExecutionAction(BuildWorkExecutor delegate, StyledTextOutputFactory textOutputFactory, ConfigurationTimeBarrier configurationTimeBarrier) {
        this.delegate = delegate;
        this.textOutputFactory = textOutputFactory;
        this.configurationTimeBarrier = configurationTimeBarrier;
    }

    @Override
    public ExecutionResult<Void> execute(GradleInternal gradle, FinalizedExecutionPlan plan) {
        if (this.configurationTimeBarrier.isAtConfigurationTime()) {
            return this.delegate.execute(gradle, plan);
        }
        for (Task task : plan.getContents().getTasks()) {
            this.textOutputFactory.create(DryRunBuildExecutionAction.class).append((CharSequence)((TaskInternal)task).getIdentityPath().asString()).append((CharSequence)" ").style(StyledTextOutput.Style.ProgressStatus).append((CharSequence)"SKIPPED").println();
        }
        return ExecutionResult.succeeded();
    }
}

