/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.FileIconPatcher;
import com.intellij.ide.FileIconProvider;
import com.intellij.ide.FileIconUtilKt;
import com.intellij.openapi.extensions.LazyExtension;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtilRt;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ(\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/FileIconUtil;", "", "<init>", "()V", "getIconFromProviders", "Ljavax/swing/Icon;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "flags", "", "project", "Lcom/intellij/openapi/project/Project;", "patchIconByIconPatchers", "icon", "intellij.platform.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFileIconUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileIconUtil.kt\ncom/intellij/ide/FileIconUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,50:1\n97#2,8:51\n97#2,8:59\n*S KotlinDebug\n*F\n+ 1 FileIconUtil.kt\ncom/intellij/ide/FileIconUtil\n*L\n24#1:51,8\n41#1:59,8\n*E\n"})
public final class FileIconUtil {
    @NotNull
    public static final FileIconUtil INSTANCE = new FileIconUtil();

    private FileIconUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Icon getIconFromProviders(@NotNull VirtualFile file, @Iconable.IconFlags int flags, @Nullable Project project) {
        Intrinsics.checkNotNullParameter(file, "file");
        Iterator iterator2 = FileIconProvider.EP_NAME.filterableLazySequence().iterator();
        while (iterator2.hasNext()) {
            Icon icon;
            void $this$getOrLogException$iv;
            Object $this$getIconFromProviders_u24lambda_u240;
            LazyExtension extension = (LazyExtension)iterator2.next();
            Object object = this;
            try {
                $this$getIconFromProviders_u24lambda_u240 = object;
                boolean bl = false;
                FileIconProvider fileIconProvider = (FileIconProvider)extension.getInstance();
                $this$getIconFromProviders_u24lambda_u240 = Result.constructor-impl(fileIconProvider != null ? fileIconProvider.getIcon(file, flags, project) : null);
            }
            catch (Throwable throwable) {
                $this$getIconFromProviders_u24lambda_u240 = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            object = $this$getIconFromProviders_u24lambda_u240;
            boolean $i$f$getOrLogException = false;
            void var9_10 = $this$getOrLogException$iv;
            if (Result.exceptionOrNull-impl(var9_10) != null) {
                Throwable e$iv;
                boolean bl = false;
                if (e$iv instanceof ProcessCanceledException || e$iv instanceof CancellationException) {
                    throw ExceptionUtilRt.addRethrownStackAsSuppressed((Throwable)e$iv);
                }
                Throwable it = e$iv;
                boolean bl2 = false;
                if (!(it instanceof IndexNotReadyException)) {
                    FileIconUtilKt.access$getLOG().warn(new PluginException("FileIconProvider " + extension + " threw an exception", it, extension.getPluginDescriptor().getPluginId()));
                }
            }
            if ((icon = (Icon)(Result.isFailure-impl(var9_10) ? null : var9_10)) == null) continue;
            return icon;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Icon patchIconByIconPatchers(@NotNull Icon icon, @NotNull VirtualFile file, int flags, @Nullable Project project) {
        Intrinsics.checkNotNullParameter(icon, "icon");
        Intrinsics.checkNotNullParameter(file, "file");
        Icon patched = null;
        patched = icon;
        Iterator iterator2 = FileIconPatcher.EP_NAME.filterableLazySequence().iterator();
        while (iterator2.hasNext()) {
            Icon icon2;
            void $this$getOrLogException$iv;
            Object $this$patchIconByIconPatchers_u24lambda_u242;
            LazyExtension extension = (LazyExtension)iterator2.next();
            Object object = this;
            try {
                $this$patchIconByIconPatchers_u24lambda_u242 = object;
                boolean bl = false;
                FileIconPatcher fileIconPatcher = (FileIconPatcher)extension.getInstance();
                $this$patchIconByIconPatchers_u24lambda_u242 = Result.constructor-impl(fileIconPatcher != null ? fileIconPatcher.patchIcon(patched, file, flags, project) : null);
            }
            catch (Throwable throwable) {
                $this$patchIconByIconPatchers_u24lambda_u242 = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            object = $this$patchIconByIconPatchers_u24lambda_u242;
            boolean $i$f$getOrLogException = false;
            void var10_11 = $this$getOrLogException$iv;
            if (Result.exceptionOrNull-impl(var10_11) != null) {
                Throwable e$iv;
                boolean bl = false;
                if (e$iv instanceof ProcessCanceledException || e$iv instanceof CancellationException) {
                    throw ExceptionUtilRt.addRethrownStackAsSuppressed((Throwable)e$iv);
                }
                Throwable it = e$iv;
                boolean bl2 = false;
                if (!(it instanceof IndexNotReadyException)) {
                    FileIconUtilKt.access$getLOG().warn(new PluginException("FileIconPatcher " + extension + " threw an exception", it, extension.getPluginDescriptor().getPluginId()));
                }
            }
            if ((icon2 = (Icon)(Result.isFailure-impl(var10_11) ? null : var10_11)) == null) {
                icon2 = patched;
            }
            patched = icon2;
        }
        return patched;
    }
}

