/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.fs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.Utils;

@ApiStatus.Internal
public final class FilesDelta {
    private static final Logger LOG = Logger.getInstance(FilesDelta.class);
    private final ReentrantLock dataLock = new ReentrantLock();
    private final Set<String> deletedPaths = CollectionFactory.createFilePathLinkedSet();
    private final Map<BuildRootDescriptor, Set<Path>> filesToRecompile = new LinkedHashMap<BuildRootDescriptor, Set<Path>>();

    public void lockData() {
        this.dataLock.lock();
    }

    public void unlockData() {
        this.dataLock.unlock();
    }

    public FilesDelta() {
    }

    FilesDelta(Collection<FilesDelta> deltas) {
        for (FilesDelta delta : deltas) {
            this.addAll(delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAll(FilesDelta other) {
        other.lockData();
        try {
            this.deletedPaths.addAll(other.deletedPaths);
            for (Map.Entry<BuildRootDescriptor, Set<Path>> entry : other.filesToRecompile.entrySet()) {
                this._addToRecompiled(entry.getKey(), (Collection<Path>)entry.getValue());
            }
        }
        finally {
            other.unlockData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(DataOutput out) throws IOException {
        this.lockData();
        try {
            out.writeInt(this.deletedPaths.size());
            for (String string : this.deletedPaths) {
                IOUtil.writeString((String)string, (DataOutput)out);
            }
            out.writeInt(this.filesToRecompile.size());
            for (Map.Entry entry : this.filesToRecompile.entrySet()) {
                IOUtil.writeString((String)((BuildRootDescriptor)entry.getKey()).getRootId(), (DataOutput)out);
                Set files = (Set)entry.getValue();
                out.writeInt(files.size());
                for (Path file : files) {
                    IOUtil.writeString((String)FileUtilRt.toSystemIndependentName((String)file.toString()), (DataOutput)out);
                }
            }
        }
        finally {
            this.unlockData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(@NotNull DataInput in, @NotNull BuildTarget<?> target, @NotNull BuildRootIndex buildRootIndex) throws IOException {
        if (in == null) {
            FilesDelta.$$$reportNull$$$0(0);
        }
        if (target == null) {
            FilesDelta.$$$reportNull$$$0(1);
        }
        if (buildRootIndex == null) {
            FilesDelta.$$$reportNull$$$0(2);
        }
        this.lockData();
        try {
            this.deletedPaths.clear();
            int deletedCount = in.readInt();
            while (deletedCount-- > 0) {
                this.deletedPaths.add(IOUtil.readString((DataInput)in));
            }
            this.filesToRecompile.clear();
            int recompileCount = in.readInt();
            while (recompileCount-- > 0) {
                Set files;
                String rootId = IOUtil.readString((DataInput)in);
                Object descriptor = target.findRootDescriptor(Objects.requireNonNull(rootId), buildRootIndex);
                if (descriptor == null) {
                    LOG.debug("Cannot find root by " + rootId + ", delta will be skipped");
                    files = FileCollectionFactory.createCanonicalLinkedPathSet();
                } else {
                    files = this.filesToRecompile.get(descriptor);
                    if (files == null) {
                        files = FileCollectionFactory.createCanonicalLinkedPathSet();
                        this.filesToRecompile.put((BuildRootDescriptor)descriptor, files);
                    }
                }
                int filesCount = in.readInt();
                while (filesCount-- > 0) {
                    Path file = Path.of(Objects.requireNonNull(IOUtil.readString((DataInput)in)), new String[0]);
                    if (Utils.IS_TEST_MODE) {
                        LOG.info("Loaded " + String.valueOf(file));
                    }
                    files.add(file);
                }
            }
        }
        finally {
            this.unlockData();
        }
    }

    public static void skip(@NotNull DataInput in) throws IOException {
        if (in == null) {
            FilesDelta.$$$reportNull$$$0(3);
        }
        int deletedCount = in.readInt();
        while (deletedCount-- > 0) {
            IOUtil.readString((DataInput)in);
        }
        int recompiledCount = in.readInt();
        while (recompiledCount-- > 0) {
            IOUtil.readString((DataInput)in);
            int filesCount = in.readInt();
            while (filesCount-- > 0) {
                IOUtil.readString((DataInput)in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChanges() {
        this.lockData();
        try {
            if (!this.deletedPaths.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (!this.filesToRecompile.isEmpty()) {
                for (Set<Path> files : this.filesToRecompile.values()) {
                    if (files.isEmpty()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlockData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markRecompile(@NotNull BuildRootDescriptor root, @NotNull Path file) {
        if (root == null) {
            FilesDelta.$$$reportNull$$$0(4);
        }
        if (file == null) {
            FilesDelta.$$$reportNull$$$0(5);
        }
        this.lockData();
        try {
            boolean added = this._addToRecompiled(root, file);
            if (added && !this.deletedPaths.isEmpty()) {
                this.deletedPaths.remove(file.toAbsolutePath().normalize().toString());
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.unlockData();
        }
    }

    public void initRecompile(@NotNull Map<BuildRootDescriptor, Set<Path>> filesToRecompile) {
        if (filesToRecompile == null) {
            FilesDelta.$$$reportNull$$$0(6);
        }
        this.lockData();
        try {
            assert (this.filesToRecompile.isEmpty());
            assert (this.deletedPaths.isEmpty());
            this.filesToRecompile.putAll(filesToRecompile);
        }
        finally {
            this.unlockData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markRecompileIfNotDeleted(@NotNull BuildRootDescriptor root, @NotNull Path file) {
        if (root == null) {
            FilesDelta.$$$reportNull$$$0(7);
        }
        if (file == null) {
            FilesDelta.$$$reportNull$$$0(8);
        }
        this.lockData();
        try {
            boolean isMarkedDeleted;
            String path = null;
            boolean bl = isMarkedDeleted = !this.deletedPaths.isEmpty() && this.deletedPaths.contains(path = file.toAbsolutePath().normalize().toString());
            if (isMarkedDeleted) {
                boolean bl2 = false;
                return bl2;
            }
            if (Files.notExists(file, new LinkOption[0])) {
                if (path == null) {
                    path = file.toAbsolutePath().normalize().toString();
                }
                if (Utils.IS_TEST_MODE) {
                    LOG.info("Marking deleted: " + path);
                }
                this.deletedPaths.add(path);
                boolean bl3 = false;
                return bl3;
            }
            this._addToRecompiled(root, file);
            boolean bl4 = true;
            return bl4;
        }
        finally {
            this.unlockData();
        }
    }

    private boolean _addToRecompiled(@NotNull BuildRootDescriptor root, @NotNull Path file) {
        if (root == null) {
            FilesDelta.$$$reportNull$$$0(9);
        }
        if (file == null) {
            FilesDelta.$$$reportNull$$$0(10);
        }
        if (Utils.IS_TEST_MODE) {
            LOG.info("Marking dirty: " + String.valueOf(file));
        }
        return this.filesToRecompile.computeIfAbsent(root, __ -> FileCollectionFactory.createCanonicalPathSet()).add(file);
    }

    private void _addToRecompiled(@NotNull BuildRootDescriptor root, @NotNull Collection<Path> filesToAdd) {
        if (root == null) {
            FilesDelta.$$$reportNull$$$0(11);
        }
        if (filesToAdd == null) {
            FilesDelta.$$$reportNull$$$0(12);
        }
        this.filesToRecompile.computeIfAbsent(root, __ -> FileCollectionFactory.createCanonicalPathSet()).addAll(filesToAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeleted(@NotNull Path file) {
        if (file == null) {
            FilesDelta.$$$reportNull$$$0(13);
        }
        String path = file.toAbsolutePath().normalize().toString();
        this.lockData();
        try {
            for (Set<Path> files : this.filesToRecompile.values()) {
                files.remove(file);
            }
            this.deletedPaths.add(path);
            if (Utils.IS_TEST_MODE) {
                LOG.info("Marking deleted: " + path);
            }
        }
        finally {
            this.unlockData();
        }
    }

    public void clearDeletedPaths() {
        this.lockData();
        try {
            this.deletedPaths.clear();
        }
        finally {
            this.unlockData();
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public Set<String> getAndClearDeletedPaths() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    @NotNull
    public @Unmodifiable Map<BuildRootDescriptor, Set<File>> getSourcesToRecompile() {
        LOG.assertTrue(this.dataLock.isHeldByCurrentThread(), (Object)"FilesDelta data must be locked by querying thread");
        LinkedHashMap<BuildRootDescriptor, Set<File>> map = new LinkedHashMap<BuildRootDescriptor, Set<File>>(this.filesToRecompile.size());
        for (Map.Entry<BuildRootDescriptor, Set<Path>> entry : this.filesToRecompile.entrySet()) {
            Set<Path> value = entry.getValue();
            LinkedHashSet<File> set = new LinkedHashSet<File>(value.size());
            for (Path path : value) {
                set.add(path.toFile());
            }
            map.put(entry.getKey(), set);
        }
        LinkedHashMap<BuildRootDescriptor, Set<File>> linkedHashMap = map;
        if (linkedHashMap == null) {
            FilesDelta.$$$reportNull$$$0(16);
        }
        return linkedHashMap;
    }

    @NotNull
    public Map<BuildRootDescriptor, Set<Path>> getSourceMapToRecompile() {
        LOG.assertTrue(this.dataLock.isHeldByCurrentThread(), (Object)"FilesDelta data must be locked by querying thread");
        Map<BuildRootDescriptor, Set<Path>> map = this.filesToRecompile;
        if (map == null) {
            FilesDelta.$$$reportNull$$$0(17);
        }
        return map;
    }

    @NotNull
    public @UnmodifiableView Collection<Set<Path>> getSourceSetsToRecompile() {
        LOG.assertTrue(this.dataLock.isHeldByCurrentThread(), (Object)"FilesDelta data must be locked by querying thread");
        Collection<Set<Path>> collection = this.filesToRecompile.values();
        if (collection == null) {
            FilesDelta.$$$reportNull$$$0(18);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMarkedRecompile(@NotNull BuildRootDescriptor rootDescriptor, @NotNull Path file) {
        if (rootDescriptor == null) {
            FilesDelta.$$$reportNull$$$0(19);
        }
        if (file == null) {
            FilesDelta.$$$reportNull$$$0(20);
        }
        this.lockData();
        try {
            Set<Path> files = this.filesToRecompile.get(rootDescriptor);
            boolean bl = files != null && files.contains(file);
            return bl;
        }
        finally {
            this.unlockData();
        }
    }

    @Nullable
    public Set<Path> clearRecompile(@NotNull BuildRootDescriptor root) {
        if (root == null) {
            FilesDelta.$$$reportNull$$$0(21);
        }
        this.lockData();
        try {
            Set<Path> set = this.filesToRecompile.remove(root);
            return set;
        }
        finally {
            this.unlockData();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildRootIndex";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToRecompile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToAdd";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/fs/FilesDelta";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/fs/FilesDelta";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndClearDeletedPaths";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcesToRecompile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapToRecompile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceSetsToRecompile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "skip";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markRecompile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initRecompile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "markRecompileIfNotDeleted";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "_addToRecompiled";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addDeleted";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isMarkedRecompile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "clearRecompile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

