/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.UtilKt;
import org.jetbrains.plugins.groovy.annotator.intentions.AddParenthesesToLambdaParameterIntention;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrRemoveModifierFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotator30;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "<init>", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "visitModifierList", "", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "checkDefaultModifier", "visitLambdaExpression", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;", "checkSingleArgumentLambda", "lambda", "intellij.groovy.psi"})
public final class GroovyAnnotator30
extends GroovyElementVisitor {
    @NotNull
    private final AnnotationHolder holder;

    public GroovyAnnotator30(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    @Override
    public void visitModifierList(@NotNull GrModifierList modifierList) {
        Intrinsics.checkNotNullParameter((Object)modifierList, (String)"modifierList");
        this.checkDefaultModifier(modifierList);
    }

    private final void checkDefaultModifier(GrModifierList modifierList) {
        block6: {
            PsiElement modifier;
            block5: {
                PsiElement psiElement = modifierList.getModifier("default");
                if (psiElement == null) {
                    return;
                }
                modifier = psiElement;
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)modifier, PsiClass.class);
                if (psiClass == null) {
                    return;
                }
                PsiClass parentClass = psiClass;
                if (!parentClass.isInterface()) break block5;
                GrTypeDefinition grTypeDefinition = parentClass instanceof GrTypeDefinition ? (GrTypeDefinition)parentClass : null;
                boolean bl = grTypeDefinition != null ? grTypeDefinition.isTrait() : false;
                if (!bl) break block6;
            }
            String string = GroovyBundle.message("illegal.default.modifier", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            AnnotationBuilder annotationBuilder = this.holder.newAnnotation(HighlightSeverity.WARNING, message).range(modifier);
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"range(...)");
            AnnotationBuilder builder = annotationBuilder;
            LocalQuickFix localQuickFix = (LocalQuickFix)new GrRemoveModifierFix("default", GroovyBundle.message("illegal.default.modifier.fix", new Object[0]));
            TextRange textRange = modifier.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            builder = UtilKt.registerLocalFix(builder, localQuickFix, modifier, message, ProblemHighlightType.WARNING, textRange);
            builder.create();
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull GrLambdaExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.checkSingleArgumentLambda(expression);
        super.visitLambdaExpression(expression);
    }

    private final void checkSingleArgumentLambda(GrLambdaExpression lambda) {
        GrParameterList grParameterList = lambda.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)grParameterList, (String)"getParameterList(...)");
        GrParameterList parameterList = grParameterList;
        if (parameterList.getLParen() != null) {
            return;
        }
        PsiElement parent = lambda.getParent();
        if (parent instanceof GrAssignmentExpression || parent instanceof GrVariable || parent instanceof GrParenthesizedExpression) {
            return;
        }
        if (parent instanceof GrArgumentList && ((GrArgumentList)parent).getParent() instanceof GrMethodCallExpression) {
            return;
        }
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("illegal.single.argument.lambda", new Object[0])).range((PsiElement)parameterList).withFix((CommonIntentionAction)new AddParenthesesToLambdaParameterIntention(lambda)).create();
    }
}

