/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.patch.LazyPatchContentRevision;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.patch.PatchedRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class TextFilePatchInProgress
extends AbstractFilePatchInProgress<TextFilePatch> {
    TextFilePatchInProgress(TextFilePatch patch, Collection<VirtualFile> autoBases, VirtualFile baseDir) {
        super(patch.pathsOnlyCopy(), autoBases, baseDir);
    }

    @Override
    public ContentRevision getNewContentRevision() {
        if (FilePatchStatus.DELETED.equals((Object)this.myStatus)) {
            return null;
        }
        if (this.myNewContentRevision == null) {
            this.myConflicts = null;
            FilePath newFilePath = this.getFilePath();
            PatchedRevisionNumber revisionNumber = new PatchedRevisionNumber(((TextFilePatch)this.myPatch).getAfterVersionId());
            if (FilePatchStatus.ADDED.equals((Object)this.myStatus)) {
                String content = ((TextFilePatch)this.myPatch).getSingleHunkPatchText();
                this.myNewContentRevision = new SimpleContentRevision(content, newFilePath, revisionNumber);
            } else {
                this.myNewContentRevision = new LazyPatchContentRevision(this.myCurrentBase, newFilePath, revisionNumber, (TextFilePatch)this.myPatch);
            }
        }
        return this.myNewContentRevision;
    }

    @Override
    @NotNull
    public DiffRequestProducer getDiffRequestProducers(final Project project, final PatchReader patchReader) {
        final AbstractFilePatchInProgress.PatchChange change = this.getChange();
        Object patch = this.getPatch();
        final String path = patch.getBeforeName() == null ? patch.getAfterName() : patch.getBeforeName();
        return new DiffRequestProducer(){

            @NotNull
            public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (indicator == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (TextFilePatchInProgress.this.myCurrentBase != null && FileTypeRegistry.getInstance().isFileOfType(TextFilePatchInProgress.this.myCurrentBase, UnknownFileType.INSTANCE)) {
                    return new UnknownFileTypeDiffRequest(TextFilePatchInProgress.this.myCurrentBase, this.getName());
                }
                if (TextFilePatchInProgress.this.isConflictingChange()) {
                    VirtualFile file = TextFilePatchInProgress.this.getCurrentBase();
                    ApplyPatchForBaseRevisionTexts texts = ApplyPatchForBaseRevisionTexts.create(project, file, VcsUtil.getFilePath((VirtualFile)file), (TextFilePatch)TextFilePatchInProgress.this.getPatch(), patchReader.getBaseRevision(path));
                    String afterTitle = ((TextFilePatch)TextFilePatchInProgress.this.getPatch()).getAfterVersionId();
                    if (afterTitle == null) {
                        afterTitle = VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0]);
                    }
                    DiffRequest diffRequest = PatchDiffRequestFactory.createConflictDiffRequest(project, file, (TextFilePatch)TextFilePatchInProgress.this.getPatch(), afterTitle, texts, this.getName());
                    if (diffRequest == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return diffRequest;
                }
                DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(project, change, this.getName(), context, indicator);
                if (diffRequest == null) {
                    1.$$$reportNull$$$0(3);
                }
                return diffRequest;
            }

            @NotNull
            public String getName() {
                File ioCurrentBase = TextFilePatchInProgress.this.getIoCurrentBase();
                String string = ioCurrentBase == null ? TextFilePatchInProgress.this.getCurrentPath() : ioCurrentBase.getPath();
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            @NotNull
            public FileType getContentType() {
                FileType fileType = TextFilePatchInProgress.this.getFilePath().getFileType();
                if (fileType == null) {
                    1.$$$reportNull$$$0(5);
                }
                return fileType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/TextFilePatchInProgress$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/TextFilePatchInProgress$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "process";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContentType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "process";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 4, 5 -> new IllegalStateException(string);
                };
            }
        };
    }
}

