/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import git4idea.commands.GitCommandOutputPrinter;
import git4idea.util.GitVcsConsoleWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J,\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J \u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lgit4idea/commands/GitCommandOutputConsolePrinter;", "Lgit4idea/commands/GitCommandOutputPrinter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "ansiEscapeDecoder", "Lcom/intellij/execution/process/AnsiEscapeDecoder;", "getAnsiEscapeDecoder", "()Lcom/intellij/execution/process/AnsiEscapeDecoder;", "ansiEscapeDecoder$delegate", "Lkotlin/Lazy;", "showCommandStart", "", "processId", "", "workingDir", "Ljava/nio/file/Path;", "commandLine", "showCommandOutput", "outputType", "Lcom/intellij/openapi/util/Key;", "line", "showCommandFinished", "exitCode", "", "intellij.vcs.git"})
public final class GitCommandOutputConsolePrinter
implements GitCommandOutputPrinter {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy ansiEscapeDecoder$delegate;

    public GitCommandOutputConsolePrinter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.ansiEscapeDecoder$delegate = LazyKt.lazy(GitCommandOutputConsolePrinter::ansiEscapeDecoder_delegate$lambda$0);
    }

    private final AnsiEscapeDecoder getAnsiEscapeDecoder() {
        Lazy lazy = this.ansiEscapeDecoder$delegate;
        return (AnsiEscapeDecoder)lazy.getValue();
    }

    @Override
    public void showCommandStart(@NotNull String processId, @NotNull Path workingDir, @NotNull String commandLine) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        String string = "[%s] %s";
        Object[] objectArray = new Object[]{workingDir, commandLine};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String commandLineWithDir = string2;
        GitVcsConsoleWriter.getInstance(this.project).showCommandLine(commandLineWithDir);
    }

    @Override
    public void showCommandOutput(@NotNull String processId, @NotNull Path workingDir, @NotNull Key<?> outputType, @NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        List lineChunks = new ArrayList();
        this.getAnsiEscapeDecoder().escapeText(line, outputType, (arg_0, arg_1) -> GitCommandOutputConsolePrinter.showCommandOutput$lambda$1(lineChunks, arg_0, arg_1));
        GitVcsConsoleWriter.getInstance(this.project).showMessage(lineChunks);
    }

    @Override
    public void showCommandFinished(@NotNull String processId, @NotNull Path workingDir, int exitCode) {
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
    }

    private static final AnsiEscapeDecoder ansiEscapeDecoder_delegate$lambda$0() {
        return new AnsiEscapeDecoder();
    }

    private static final void showCommandOutput$lambda$1(List $lineChunks, String text2, Key key) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Pair pair = Pair.create((Object)text2, (Object)key);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
        $lineChunks.add(pair);
    }
}

