/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.DynamicBundle;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.LabeledComponentNoThrow;
import com.intellij.openapi.ui.TextComponentAccessors;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenVersionSupportUtil;
import org.jetbrains.idea.maven.config.MavenConfig;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTargetConfiguration;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenHomeKt;
import org.jetbrains.idea.maven.project.MavenHomeType;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.StaticResolvedMavenHomeType;
import org.jetbrains.idea.maven.utils.MavenEelUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenEnvironmentForm
implements PanelWithAnchor {
    private JPanel panel;
    private LabeledComponent<ComponentWithBrowseButton<TextFieldWithHistory>> mavenHomeComponent;
    private ContextHelpLabel mavenHomeOnTargetHelpLabel;
    private TextFieldWithHistory mavenHomeField;
    private LabeledComponent<JBLabel> mavenVersionLabelComponent;
    private LabeledComponentNoThrow<TextFieldWithBrowseButton> settingsFileComponent;
    private LabeledComponentNoThrow<TextFieldWithBrowseButton> localRepositoryComponent;
    private JCheckBox settingsOverrideCheckBox;
    private JCheckBox localRepositoryOverrideCheckBox;
    private JComponent anchor;
    private final PathOverrider userSettingsFileOverrider;
    private final PathOverrider localRepositoryOverrider;
    private boolean isUpdating = false;
    private final SingleEdtTaskScheduler updateAlarm;
    private String myTargetName;
    private Project myProject;

    public MavenEnvironmentForm() {
        this.$$$setupUI$$$();
        this.updateAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
        DocumentAdapter listener2 = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (MavenEnvironmentForm.this.isUpdating) {
                        return;
                    }
                    if (!MavenEnvironmentForm.this.panel.isShowing()) {
                        return;
                    }
                    MavenEnvironmentForm.this.updateAlarm.cancelAndRequest(100L, () -> {
                        MavenEnvironmentForm.this.isUpdating = true;
                        MavenEnvironmentForm.this.userSettingsFileOverrider.updateDefault();
                        MavenEnvironmentForm.this.localRepositoryOverrider.updateDefault();
                        MavenEnvironmentForm.this.isUpdating = false;
                    });
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/project/MavenEnvironmentForm$1", "textChanged"));
            }
        };
        this.userSettingsFileOverrider = new PathOverrider((LabeledComponent<TextFieldWithBrowseButton>)this.settingsFileComponent, this.settingsOverrideCheckBox, (DocumentListener)listener2, new PathProvider(){

            @Override
            @Nullable
            protected Path getFile() {
                return MavenEnvironmentForm.this.doResolveDefaultUserSettingsFile();
            }
        });
        this.localRepositoryOverrider = new PathOverrider((LabeledComponent<TextFieldWithBrowseButton>)this.localRepositoryComponent, this.localRepositoryOverrideCheckBox, (DocumentListener)listener2, new PathProvider(){

            @Override
            @Nullable
            protected Path getFile() {
                return MavenEnvironmentForm.this.doResolveDefaultLocalRepository();
            }
        });
        this.mavenHomeField.addDocumentListener((DocumentListener)listener2);
    }

    @NotNull
    private Path doResolveDefaultLocalRepository() {
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        MavenConfig config = projectsManager != null ? projectsManager.getGeneralSettings().getMavenConfig() : null;
        Path path = MavenEelUtil.getLocalRepoUnderModalProgress(this.myProject, "", MavenHomeKt.staticOrBundled(MavenHomeKt.resolveMavenHomeType(this.mavenHomeField.getText().trim())), ((TextFieldWithBrowseButton)this.settingsFileComponent.getComponent()).getText(), config);
        if (path == null) {
            MavenEnvironmentForm.$$$reportNull$$$0(0);
        }
        return path;
    }

    @NotNull
    private Path doResolveDefaultUserSettingsFile() {
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        MavenConfig config = projectsManager != null ? projectsManager.getGeneralSettings().getMavenConfig() : null;
        Path path = MavenEelUtil.getUserSettingsUnderModalProgress(this.myProject, "", config);
        if (path == null) {
            MavenEnvironmentForm.$$$reportNull$$$0(1);
        }
        return path;
    }

    private void createUIComponents() {
        this.mavenHomeField = new TextFieldWithHistory();
        this.mavenHomeField.setHistorySize(-1);
        ArrayList foundMavenHomes = new ArrayList();
        MavenHomeKt.getAllKnownHomes().forEach(it -> foundMavenHomes.add(it.getTitle()));
        this.mavenHomeField.setHistory(foundMavenHomes);
        this.mavenHomeComponent = LabeledComponent.create((JComponent)new ComponentWithBrowseButton((JComponent)this.mavenHomeField, null), (String)MavenConfigurableBundle.message("maven.settings.environment.home.directory", new Object[0]));
        this.mavenHomeOnTargetHelpLabel = ContextHelpLabel.create((String)MavenConfigurableBundle.message("maven.settings.on.targets.environment.home.directory.context.help", new Object[0]));
        this.mavenHomeOnTargetHelpLabel.setVisible(false);
        this.mavenHomeOnTargetHelpLabel.setOpaque(true);
        this.mavenHomeComponent.add((Component)this.mavenHomeOnTargetHelpLabel, (Object)"East");
        JBLabel versionLabel = new JBLabel();
        versionLabel.setOpaque(true);
        versionLabel.setVerticalAlignment(1);
        versionLabel.setVerticalTextPosition(1);
        this.mavenVersionLabelComponent = LabeledComponent.create((JComponent)versionLabel, (String)"");
    }

    public boolean isModified(MavenGeneralSettings data) {
        MavenGeneralSettings formData = new MavenGeneralSettings();
        this.setData(formData);
        return !formData.equals(data);
    }

    public void setData(MavenGeneralSettings data) {
        data.setMavenHomeType(MavenHomeKt.resolveMavenHomeType(this.mavenHomeField.getText().trim()));
        data.setUserSettingsFile(this.userSettingsFileOverrider.getResult());
        data.setLocalRepository(this.localRepositoryOverrider.getResult());
    }

    public void initializeFormData(MavenGeneralSettings data, Project project) {
        this.myProject = project;
        this.setAnchor((JComponent)this.mavenHomeComponent.getLabel());
        String text = data.getMavenHomeType().getTitle();
        this.mavenHomeField.setText(text);
        this.updateMavenVersionLabel();
        this.userSettingsFileOverrider.reset(data.getUserSettingsFile());
        this.localRepositoryOverrider.reset(data.getLocalRepository());
    }

    private void updateMavenVersionLabel() {
        boolean localTarget = this.myTargetName == null;
        MavenHomeType type = MavenHomeKt.resolveMavenHomeType(this.mavenHomeField.getText().trim());
        String version = null;
        if (type instanceof StaticResolvedMavenHomeType) {
            StaticResolvedMavenHomeType sType = (StaticResolvedMavenHomeType)type;
            version = MavenUtil.getMavenVersion(sType);
        }
        String versionText = null;
        if (version != null) {
            versionText = StringUtil.compareVersionNumbers((String)version, (String)"3.1") < 0 ? MavenEnvironmentForm.getUnsupportedMavenMessage(version) : MavenProjectBundle.message("label.invalid.maven.home.version", version);
        } else if (localTarget) {
            versionText = type.getTitle();
        }
        ((JBLabel)this.mavenVersionLabelComponent.getComponent()).setText(StringUtil.notNullize((String)versionText));
    }

    @NlsContexts.Label
    private static String getUnsupportedMavenMessage(String version) {
        if (StringUtil.compareVersionNumbers((String)version, (String)"3.1") < 0 && StringUtil.compareVersionNumbers((String)version, (String)"2") > 0) {
            return MavenProjectBundle.message("label.invalid.maven30", new Object[0]);
        }
        if (!MavenVersionSupportUtil.isMaven2PluginInstalled()) {
            return MavenProjectBundle.message("label.invalid.install.maven2plugin", new Object[0]);
        }
        if (MavenVersionSupportUtil.isMaven2PluginDisabled()) {
            return MavenProjectBundle.message("label.invalid.enable.maven2plugin", new Object[0]);
        }
        if (version == null) {
            return MavenProjectBundle.message("label.invalid.maven.home.directory", new Object[0]);
        }
        return MavenProjectBundle.message("label.invalid.maven.home.version", version);
    }

    public JComponent createComponent() {
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(MavenProjectBundle.message("maven.select.maven.home.directory", new Object[0]));
        ((ComponentWithBrowseButton)this.mavenHomeComponent.getComponent()).addBrowseFolderListener(null, descriptor2, TextComponentAccessors.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        this.mavenHomeField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                MavenEnvironmentForm.this.updateMavenVersionLabel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/project/MavenEnvironmentForm$4", "textChanged"));
            }
        });
        ((TextFieldWithBrowseButton)this.settingsFileComponent.getComponent()).addBrowseFolderListener(null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(MavenProjectBundle.message("maven.select.maven.settings.file", new Object[0])));
        ((TextFieldWithBrowseButton)this.localRepositoryComponent.getComponent()).addBrowseFolderListener(null, FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(MavenProjectBundle.message("maven.select.local.repository", new Object[0])));
        return this.panel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.mavenHomeComponent.setAnchor(anchor);
        this.mavenVersionLabelComponent.setAnchor(anchor);
        this.settingsFileComponent.setAnchor(anchor);
        this.localRepositoryComponent.setAnchor(anchor);
    }

    @ApiStatus.Internal
    void apply(@NotNull Project project, @Nullable String targetName) {
        boolean targetChanged;
        if (project == null) {
            MavenEnvironmentForm.$$$reportNull$$$0(2);
        }
        boolean localTarget = targetName == null;
        boolean bl = targetChanged = !Objects.equals(this.myTargetName, targetName);
        if (targetChanged) {
            String mavenHomeInputLabel;
            this.myTargetName = targetName;
            ((ComponentWithBrowseButton)this.mavenHomeComponent.getComponent()).getButton().setVisible(localTarget);
            this.mavenHomeOnTargetHelpLabel.setVisible(!localTarget);
            if (localTarget) {
                mavenHomeInputLabel = MavenConfigurableBundle.message("maven.settings.environment.home.directory", new Object[0]);
            } else {
                TargetEnvironmentsManager targetManager = TargetEnvironmentsManager.getInstance((Project)project);
                TargetEnvironmentConfiguration targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)targetManager.getTargets().findByName(targetName);
                String typeId = targetEnvironmentConfiguration != null ? targetEnvironmentConfiguration.getTypeId() : null;
                TargetEnvironmentType targetEnvironmentType = null;
                if (typeId != null) {
                    targetEnvironmentType = (TargetEnvironmentType)TargetEnvironmentType.EXTENSION_NAME.findFirstSafe(type -> type.getId().equals(typeId));
                }
                mavenHomeInputLabel = targetEnvironmentType != null ? MessageFormat.format("<html><body><nobr>{0}</nobr></body></html>", MavenConfigurableBundle.message("maven.settings.on.targets.environment.home.directory", targetEnvironmentType.getDisplayName())) : MavenConfigurableBundle.message("maven.settings.environment.home.directory", new Object[0]);
            }
            this.mavenHomeComponent.setText(mavenHomeInputLabel);
            this.reloadMavenHomeComponents(project, targetName);
        } else if (!localTarget) {
            this.reloadMavenHomeComponents(project, targetName);
        }
    }

    private void reloadMavenHomeComponents(@NotNull Project project, @Nullable String targetName) {
        if (project == null) {
            MavenEnvironmentForm.$$$reportNull$$$0(3);
        }
        List<String> targetMavenHomes = MavenEnvironmentForm.findTargetMavenHomes(project, targetName);
        if (!this.mavenHomeField.getHistory().equals(targetMavenHomes)) {
            EdtInvocationManager.getInstance().invokeLater(() -> this.mavenHomeField.setHistory(targetMavenHomes));
        }
        String mavenHomeFieldText = this.mavenHomeField.getText();
        if (targetMavenHomes.isEmpty()) {
            if (!mavenHomeFieldText.isEmpty()) {
                EdtInvocationManager.getInstance().invokeLater(() -> this.mavenHomeField.setSelectedItem((Object)""));
            }
        } else if (!targetMavenHomes.contains(mavenHomeFieldText)) {
            EdtInvocationManager.getInstance().invokeLater(() -> {
                if (!targetMavenHomes.contains(this.mavenHomeField.getText())) {
                    this.mavenHomeField.setSelectedItem(targetMavenHomes.get(0));
                }
            });
        }
    }

    private static List<String> findTargetMavenHomes(@NotNull Project project, @Nullable String targetName) {
        List<String> mavenHomes;
        boolean localTarget;
        if (project == null) {
            MavenEnvironmentForm.$$$reportNull$$$0(4);
        }
        boolean bl = localTarget = targetName == null;
        if (localTarget) {
            mavenHomes = new ArrayList<String>();
            MavenUtil.getSystemMavenHomeVariants(project).forEach(it -> mavenHomes.add(it.getTitle()));
        } else {
            TargetEnvironmentConfiguration targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)TargetEnvironmentsManager.getInstance((Project)project).getTargets().findByName(targetName);
            mavenHomes = targetEnvironmentConfiguration != null ? targetEnvironmentConfiguration.getRuntimes().resolvedConfigs().stream().filter(runtimeConfiguration -> runtimeConfiguration instanceof MavenRuntimeTargetConfiguration).map(runtimeConfiguration -> ((MavenRuntimeTargetConfiguration)((Object)runtimeConfiguration)).getHomePath()).collect(Collectors.toList()) : new ArrayList();
        }
        return mavenHomes;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        LabeledComponentNoThrow labeledComponentNoThrow;
        JCheckBox jCheckBox2;
        LabeledComponentNoThrow labeledComponentNoThrow2;
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.settingsFileComponent = labeledComponentNoThrow2 = new LabeledComponentNoThrow();
        labeledComponentNoThrow2.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponentNoThrow2.setLabelLocation("West");
        labeledComponentNoThrow2.setText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenEnvironmentForm.class).getString("maven.settings.environment.user.settings"));
        jPanel.add((Component)labeledComponentNoThrow2, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.settingsOverrideCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenEnvironmentForm.class).getString("maven.settings.override"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.localRepositoryComponent = labeledComponentNoThrow = new LabeledComponentNoThrow();
        labeledComponentNoThrow.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponentNoThrow.setLabelLocation("West");
        labeledComponentNoThrow.setText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenEnvironmentForm.class).getString("maven.settings.environment.local.repository"));
        jPanel.add((Component)labeledComponentNoThrow, new GridConstraints(3, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.localRepositoryOverrideCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenEnvironmentForm.class).getString("maven.settings.override"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        LabeledComponent<ComponentWithBrowseButton<TextFieldWithHistory>> labeledComponent = this.mavenHomeComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenEnvironmentForm.class).getString("maven.settings.environment.home.directory"));
        jPanel.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        LabeledComponent<JBLabel> labeledComponent2 = this.mavenVersionLabelComponent;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText("");
        jPanel.add((Component)labeledComponent2, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenEnvironmentForm";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveDefaultLocalRepository";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveDefaultUserSettingsFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenEnvironmentForm";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reloadMavenHomeComponents";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTargetMavenHomes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static class PathOverrider {
        private final TextFieldWithBrowseButton component;
        private final JCheckBox checkBox;
        private final PathProvider pathProvider;
        private Boolean isOverridden;
        @NlsSafe
        private String overrideText;

        PathOverrider(LabeledComponent<TextFieldWithBrowseButton> component, JCheckBox checkBox, DocumentListener docListener, PathProvider pathProvider) {
            this.component = (TextFieldWithBrowseButton)component.getComponent();
            this.component.getTextField().getDocument().addDocumentListener(docListener);
            this.checkBox = checkBox;
            this.pathProvider = pathProvider;
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.update();
                }
            });
        }

        private void update() {
            boolean override = this.checkBox.isSelected();
            if (Comparing.equal((Object)this.isOverridden, (Object)override)) {
                return;
            }
            this.isOverridden = override;
            this.component.setEditable(override);
            this.component.setEnabled(override && this.checkBox.isEnabled());
            if (override) {
                if (this.overrideText != null) {
                    this.component.setText(this.overrideText);
                }
            } else {
                if (!StringUtil.isEmptyOrSpaces((String)this.component.getText())) {
                    this.overrideText = this.component.getText();
                }
                this.component.setText(this.pathProvider.getPath());
            }
        }

        private void updateDefault() {
            if (!this.checkBox.isSelected()) {
                this.component.setText(this.pathProvider.getPath());
            }
        }

        public void reset(@NlsSafe String text) {
            this.isOverridden = null;
            this.checkBox.setSelected(!StringUtil.isEmptyOrSpaces((String)text));
            this.overrideText = StringUtil.isEmptyOrSpaces((String)text) ? null : text;
            this.update();
        }

        public String getResult() {
            return this.checkBox.isSelected() ? this.component.getText().trim() : "";
        }
    }

    private static abstract class PathProvider {
        private PathProvider() {
        }

        @NlsSafe
        public String getPath() {
            Path file2 = this.getFile();
            return file2 == null ? "" : file2.toString();
        }

        @Nullable
        protected abstract Path getFile();
    }
}

