/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.BinaryDisplayType;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.TextInfo;
import com.intellij.database.run.actions.ChangeCellEditorFileEncodingAction;
import com.intellij.database.run.actions.LoadFileAction;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.editors.GridTextCellEditorBase;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBlobEditorFactory
implements GridCellEditorFactory {
    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(1);
        }
        if (column == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(2);
        }
        return switch (GridCellEditorHelper.get((CoreGrid)grid).guessJdbcTypeForEditing((CoreGrid)grid, row, column)) {
            case -4, -3, -2, 2004 -> 1;
            default -> 0;
        };
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueFormatter getValueFormatter(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx, @Nullable Object value) {
        if (grid == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(3);
        }
        if (rowIdx == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(4);
        }
        if (columnIdx == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(5);
        }
        return new GridCellEditorFactory.DefaultValueToText(grid, columnIdx, value);
    }

    @Override
    @NotNull
    public GridCellEditorFactory.IsEditableChecker getIsEditableChecker() {
        GridCellEditorFactory.IsEditableChecker isEditableChecker = (value, grid, column) -> {
            TextInfo textInfo = (TextInfo)ObjectUtils.tryCast((Object)value, TextInfo.class);
            return value == null || textInfo != null && DatabaseObjectFormatterConfig.isTypeAllowed((ObjectFormatterConfig)GridUtil.createFormatterConfig(grid, (ModelIndex<GridColumn>)column), (BinaryDisplayType)BinaryDisplayType.TEXT);
        };
        if (isEditableChecker == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(6);
        }
        return isEditableChecker;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx) {
        if (grid == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(7);
        }
        if (rowIdx == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(8);
        }
        if (columnIdx == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(9);
        }
        GridCellEditorFactory.ValueParser valueParser = (text, document) -> {
            VirtualFile file = document == null ? null : FileDocumentManager.getInstance().getFile(document);
            Charset charset = file == null ? StandardCharsets.UTF_8 : file.getCharset();
            byte[] bytes = text.getBytes(charset);
            byte[] bom = file == null ? null : file.getBOM();
            return new TextInfo(text, bom == null ? bytes : ArrayUtil.mergeArrays((byte[])bom, (byte[])bytes), charset);
        };
        if (valueParser == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(10);
        }
        return valueParser;
    }

    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @Nullable Object object, EventObject initiator) {
        if (grid == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(11);
        }
        if (row == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(12);
        }
        if (column == null) {
            DefaultBlobEditorFactory.$$$reportNull$$$0(13);
        }
        return new BlobTextCellEditor(grid, row, column, object, initiator, this.getIsEditableChecker(), this.getValueParser(grid, row, column), this.getValueFormatter(grid, row, column, object));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultBlobEditorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBlobEditorFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsEditableChecker";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValueFormatter";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValueParser";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10 -> new IllegalStateException(string);
        };
    }

    private static class BlobTextCellEditor
    extends GridTextCellEditorBase
    implements LoadFileAction.LoadFileActionHandler {
        private final GridCellEditorFactory.ValueParser myValueParser;

        BlobTextCellEditor(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @Nullable Object value, EventObject initiator, @NotNull GridCellEditorFactory.IsEditableChecker editableChecker, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
            if (grid == null) {
                BlobTextCellEditor.$$$reportNull$$$0(0);
            }
            if (row == null) {
                BlobTextCellEditor.$$$reportNull$$$0(1);
            }
            if (column == null) {
                BlobTextCellEditor.$$$reportNull$$$0(2);
            }
            if (editableChecker == null) {
                BlobTextCellEditor.$$$reportNull$$$0(3);
            }
            if (valueParser == null) {
                BlobTextCellEditor.$$$reportNull$$$0(4);
            }
            if (valueFormatter == null) {
                BlobTextCellEditor.$$$reportNull$$$0(5);
            }
            super(grid, row, column, value, initiator, editableChecker, valueFormatter);
            this.myValueParser = valueParser;
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.isValueEditable() ? this.myValueParser.parse(this.myTextField.getText(), this.myTextField.getDocument()) : this.myValue;
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                BlobTextCellEditor.$$$reportNull$$$0(6);
            }
            sink.set(LoadFileAction.LOAD_FILE_ACTION_HANDLER_KEY, (Object)this);
            if (this.isValueEditable()) {
                sink.set(ChangeCellEditorFileEncodingAction.ENCODING_CHANGE_SUPPORTED_KEY, (Object)Boolean.TRUE);
            }
            sink.set(CommonDataKeys.VIRTUAL_FILE, (Object)this.getVirtualFile());
            sink.set(CommonDataKeys.VIRTUAL_FILE_ARRAY, (Object)new VirtualFile[]{this.getVirtualFile()});
        }

        @Override
        public void fileChosen(@NotNull VirtualFile file) {
            if (file == null) {
                BlobTextCellEditor.$$$reportNull$$$0(7);
            }
            this.myValue = GridUtil.blobFromFile(file);
            this.myGrid.stopEditing();
        }

        private VirtualFile getVirtualFile() {
            return FileDocumentManager.getInstance().getFile(this.myTextField.getDocument());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editableChecker";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueParser";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueFormatter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultBlobEditorFactory$BlobTextCellEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileChosen";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

