/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.util.DictionaryLookup;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.ThreadLocalCachedValue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoverageIOUtil {
    public static final int GIGA = 1000000000;
    private static final int STRING_HEADER_SIZE = 1;
    private static final int STRING_LENGTH_THRESHOLD = 255;
    private static final String LONGER_THAN_64K_MARKER = "LONGER_THAN_64K";
    private static final ThreadLocalCachedValue<byte[]> ioBuffer = new ThreadLocalCachedValue<byte[]>(){

        @Override
        protected final byte[] create() {
            return CoverageIOUtil.allocReadWriteUTFBuffer();
        }
    };
    private static final Pattern TYPE_PATTERN = Pattern.compile("L[^;]*;");

    private CoverageIOUtil() {
    }

    /*
     * WARNING - void declaration
     */
    private static String readString(DataInput stream) throws IOException {
        void var2_3;
        int length = stream.readInt();
        if (length == -1) {
            return null;
        }
        char[] chars = new char[length];
        byte[] bytes = new byte[length << 1];
        stream.readFully(bytes);
        int i = 0;
        int i2 = 0;
        while (i < length) {
            chars[i] = (char)((bytes[i2] << 8) + (bytes[i2 + 1] & 0xFF));
            ++i;
            i2 += 2;
        }
        return new String((char[])var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void writeString(DataOutput stream, String s) throws IOException {
        void var2_2;
        DataOutput dataOutput;
        if (s == null) {
            stream.writeInt(-1);
            return;
        }
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length << 1];
        stream.writeInt(chars.length);
        int i = 0;
        int i2 = 0;
        while (i < chars.length) {
            char aChar = chars[i];
            bytes[i2] = (byte)(aChar >>> 8);
            bytes[i2 + 1] = (byte)aChar;
            ++i;
            i2 += 2;
        }
        dataOutput.write((byte[])var2_2);
    }

    private static byte[] allocReadWriteUTFBuffer() {
        return new byte[256];
    }

    /*
     * WARNING - void declaration
     */
    public static void writeUTF(DataOutput storage, String value) throws IOException {
        int len = value.length();
        if (len < 255 && CoverageIOUtil.isAscii(value)) {
            void var2_2;
            CoverageIOUtil.ioBuffer.getValue()[0] = (byte)len;
            for (int i = 0; i < len; ++i) {
                CoverageIOUtil.ioBuffer.getValue()[i + 1] = (byte)value.charAt(i);
            }
            storage.write(ioBuffer.getValue(), 0, (int)(var2_2 + true));
            return;
        }
        storage.writeByte(-1);
        try {
            storage.writeUTF(value);
            return;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            void var1_1;
            DataOutput dataOutput;
            storage.writeUTF(LONGER_THAN_64K_MARKER);
            CoverageIOUtil.writeString(dataOutput, (String)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String readUTFFast(DataInput storage) throws IOException {
        void var2_4;
        int len = 0xFF & storage.readByte();
        if (len == 255) {
            String result = storage.readUTF();
            if (LONGER_THAN_64K_MARKER.equals(result)) {
                return CoverageIOUtil.readString(storage);
            }
            return result;
        }
        char[] chars = new char[len];
        storage.readFully(ioBuffer.getValue(), 0, len);
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)ioBuffer.getValue()[i];
        }
        return new String((char[])var2_4);
    }

    private static boolean isAscii(String str) {
        for (int i = 0; i != str.length(); ++i) {
            char c = str.charAt(i);
            if (c < '\u0080') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static int readINT(DataInput record) throws IOException {
        int val = record.readUnsignedByte();
        if (val < 192) {
            return val;
        }
        int res = val - 192;
        int sh = 6;
        while (true) {
            void var3_3;
            int next = record.readUnsignedByte();
            res |= (next & 0x7F) << sh;
            if ((var3_3 & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeINT(DataOutput record, int val) throws IOException {
        void var1_1;
        DataOutput dataOutput;
        if (val < 0 || val >= 192) {
            record.writeByte(192 + (val & 0x3F));
            val >>>= 6;
            while (val >= 128) {
                record.writeByte(val & 0x7F | 0x80);
                val >>>= 7;
            }
        }
        dataOutput.writeByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String collapse(String methodSignature, DictionaryLookup dictionaryLookup) {
        void var1_1;
        return CoverageIOUtil.processWithDictionary(methodSignature, new Consumer((DictionaryLookup)var1_1){
            final /* synthetic */ DictionaryLookup val$dictionaryLookup;
            {
                this.val$dictionaryLookup = dictionaryLookup;
            }

            /*
             * WARNING - void declaration
             */
            protected final String consume(String type) {
                void var1_1;
                int dictionaryIndex = this.val$dictionaryLookup.getDictionaryIndex(type);
                if (dictionaryIndex >= 0) {
                    void var2_2;
                    return String.valueOf((int)var2_2);
                }
                return var1_1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static String processWithDictionary(String methodSignature, Consumer consumer) {
        String string;
        Matcher matcher = TYPE_PATTERN.matcher(methodSignature);
        while (matcher.find()) {
            void var3_3;
            String type;
            String replacement;
            String s = matcher.group();
            if (!s.startsWith("L") || !s.endsWith(";") || (replacement = consumer.consume(type = s.substring(1, s.length() - 1))) == type) continue;
            methodSignature = methodSignature.replace((CharSequence)var3_3, replacement);
        }
        return string;
    }

    public static DataOutputStream openWriteFile(File file) throws FileNotFoundException {
        File file2;
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
    }

    public static DataInputStream openReadFile(File file) throws FileNotFoundException {
        File file2;
        return new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));
    }

    public static void close(Closeable out) {
        if (out != null) {
            try {
                Closeable closeable;
                closeable.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static abstract class Consumer {
        protected abstract String consume(String var1);
    }

    public static final class FileLock {
        final File myLock;

        /*
         * WARNING - void declaration
         */
        private FileLock(File target) {
            void var1_1;
            this.myLock = new File(target.getParentFile(), var1_1.getName() + ".lck");
            if (this.myLock.getParentFile() != null) {
                this.myLock.getParentFile().mkdirs();
            }
        }

        private boolean isLocked() {
            return this.myLock.exists();
        }

        private boolean tryLock() {
            try {
                return this.myLock.createNewFile();
            }
            catch (IOException iOException) {
                return false;
            }
        }

        private boolean tryUnlock() {
            return this.myLock.delete();
        }

        public static FileLock lock(File targetFile) {
            return FileLock.lock(targetFile, 120000L, 100L);
        }

        public static FileLock lock(File targetFile, long totalTimeoutMS, long waitTimeMS) {
            FileLock fileLock;
            FileLock lock = new FileLock(targetFile);
            if (lock.myLock.exists()) {
                long current = System.currentTimeMillis();
                long modified = lock.myLock.lastModified();
                if (modified != 0L && modified + totalTimeoutMS < current) {
                    super.tryUnlock();
                }
            }
            for (long timePassed = 0L; timePassed < totalTimeoutMS; timePassed += waitTimeMS) {
                if (super.tryLock()) {
                    return lock;
                }
                FileLock.wait(lock, waitTimeMS, "lock");
            }
            ErrorReporter.warn("Failed to lock with file lock: " + fileLock.myLock.getAbsolutePath());
            return null;
        }

        public static void unlock(FileLock lock) {
            FileLock.unlock(lock, 5, 100L);
        }

        public static void unlock(FileLock lock, int retries, long waitTimeMS) {
            FileLock fileLock;
            if (lock == null) {
                return;
            }
            for (int attempt = 0; attempt < retries; ++attempt) {
                if (!lock.isLocked()) {
                    return;
                }
                if (lock.tryUnlock()) {
                    return;
                }
                FileLock.wait(lock, waitTimeMS, "unlock");
            }
            ErrorReporter.warn("Failed to unlock with file lock: " + fileLock.myLock.getAbsolutePath());
        }

        /*
         * WARNING - void declaration
         */
        private static void wait(FileLock lock, long waitTimeMS, String action) {
            try {
                Thread.sleep(waitTimeMS);
                return;
            }
            catch (InterruptedException e) {
                void var1_2;
                FileLock fileLock;
                void var3_3;
                throw new RuntimeException("Failed to " + (String)var3_3 + " with file lock: " + fileLock.myLock.getAbsolutePath(), (Throwable)var1_2);
            }
        }
    }
}

