/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.code.cfg.ExceptionRangeCFG;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersion;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public final class TryHelper {
    public static boolean enhanceTryStats(RootStatement root, ControlFlowGraph graph, StructMethod mt) {
        boolean ret = TryHelper.makeTryWithResourceRec(root, graph, mt, root.getDummyExit(), new ArrayList<TryStatementJ11>());
        if (ret) {
            SequenceHelper.condenseSequences(root);
            if (TryHelper.collapseTryRec(root, mt)) {
                SequenceHelper.condenseSequences(root);
            }
        }
        return ret;
    }

    private static boolean makeTryWithResourceRec(Statement stat, ControlFlowGraph graph, StructMethod mt, DummyExitStatement exit, List<TryStatementJ11> stack) {
        boolean ret = false;
        if (stat.type == Statement.StatementType.CATCH_ALL && ((CatchAllStatement)stat).isFinally() && TryHelper.makeTryWithResource((CatchAllStatement)stat, graph)) {
            return true;
        }
        if (mt.getBytecodeVersion() >= 55 && stat.type == Statement.StatementType.TRY_CATCH) {
            ret |= TryHelper.addTryWithResourceJ11((CatchStatement)stat, graph, stack);
        }
        for (int i = 0; i < stat.getStats().size(); ++i) {
            Statement st = (Statement)stat.getStats().get(i);
            ret |= TryHelper.makeTryWithResourceRec(st, graph, mt, exit, stack);
        }
        if (!stack.isEmpty() && stack.get(0).tryStatement() == stat) {
            TryHelper.makeTryStatementJ11(stack, exit);
        }
        return ret;
    }

    private static boolean collapseTryRec(Statement stat, StructMethod mt) {
        CatchStatement tryStat;
        if (mt.getBytecodeVersion() >= 55) {
            Object tryStat2;
            boolean ret = false;
            if (stat.type == Statement.StatementType.TRY_CATCH && TryHelper.collapseTryJ11((CatchStatement)(tryStat2 = (CatchStatement)stat))) {
                ret = true;
            }
            for (Statement st : stat.getStats()) {
                ret |= TryHelper.collapseTryRec(st, mt);
            }
            return ret;
        }
        if (stat.type == Statement.StatementType.TRY_CATCH && TryHelper.collapseTry(tryStat = (CatchStatement)stat)) {
            return true;
        }
        for (Statement st : stat.getStats()) {
            if (!TryHelper.collapseTryRec(st, mt)) continue;
            return true;
        }
        return false;
    }

    private static boolean makeTryWithResource(CatchAllStatement finallyStat, ControlFlowGraph graph) {
        Exprent exp;
        Statement handler = finallyStat.getHandler();
        if (handler.getStats().size() != 2) {
            return false;
        }
        Statement toCheck = finallyStat.getHandler().getFirst();
        if (toCheck.type != Statement.StatementType.IF || ((IfStatement)toCheck).getIfstat().type != Statement.StatementType.IF) {
            return false;
        }
        if (((IfStatement)(toCheck = ((IfStatement)toCheck).getIfstat())).getElsestat() == null) {
            return false;
        }
        Statement elseBlock = ((IfStatement)toCheck).getElsestat();
        VarExprent var = null;
        if (elseBlock.getExprents() != null && elseBlock.getExprents().size() == 1 && TryHelper.isCloseCall(exp = elseBlock.getExprents().get(0), elseBlock, graph)) {
            var = (VarExprent)((InvocationExprent)exp).getInstance();
        }
        if (var != null) {
            AssignmentExprent ass = null;
            BasicBlockStatement initBlock = null;
            for (StatEdge edge : finallyStat.getAllPredecessorEdges()) {
                if (!edge.getDestination().equals(finallyStat) || edge.getSource().type != Statement.StatementType.BASIC_BLOCK || (ass = TryHelper.findResourceDef(var, edge.getSource())) == null) continue;
                initBlock = (BasicBlockStatement)edge.getSource();
                break;
            }
            if (ass != null) {
                Statement stat = finallyStat.getParent();
                Statement stat2 = finallyStat.getFirst();
                if (stat2.type == Statement.StatementType.TRY_CATCH) {
                    CatchStatement child = (CatchStatement)stat2;
                    AssignmentExprent resourceDef = (AssignmentExprent)ass.copy();
                    if (ass.getRight().getExprType().equals(VarType.VARTYPE_NULL) && child.getFirst() != null) {
                        TryHelper.fixResourceAssignment(resourceDef, child.getFirst());
                    }
                    if (resourceDef.getRight().getExprType().equals(VarType.VARTYPE_NULL)) {
                        return false;
                    }
                    child.setTryType(CatchStatement.CatchStatementType.RESOURCES);
                    List<Exprent> exprents = initBlock.getExprents();
                    if (exprents != null) {
                        exprents.remove(ass);
                    }
                    child.getResources().add(0, resourceDef);
                    if (!finallyStat.getVarDefinitions().isEmpty()) {
                        child.getVarDefinitions().addAll(0, finallyStat.getVarDefinitions());
                    }
                    stat.replaceStatement(finallyStat, child);
                    TryHelper.removeRedundantThrow(initBlock, child);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean addTryWithResourceJ11(CatchStatement tryStatement, ControlFlowGraph graph, List<TryStatementJ11> stack) {
        if (tryStatement.getStats().size() < 2) {
            return false;
        }
        if (!tryStatement.getVars().get(0).getVarType().getValue().equals("java/lang/Throwable")) {
            return false;
        }
        Statement inner = (Statement)tryStatement.getStats().get(1);
        VarExprent closeable = null;
        boolean nullable = false;
        if (inner instanceof SequenceStatement) {
            Exprent ifCase;
            if ((inner = (Statement)inner.getStats().get(0)) instanceof CatchStatement) {
                Exprent first;
                if (inner.getStats().isEmpty()) {
                    return false;
                }
                Statement inTry = (Statement)inner.getStats().get(0);
                if (inTry instanceof BasicBlockStatement && inTry.getExprents() != null && !inTry.getExprents().isEmpty() && TryHelper.isCloseCall(first = inTry.getExprents().get(0), inTry, graph)) {
                    closeable = (VarExprent)((InvocationExprent)first).getInstance();
                }
            }
            if (inner instanceof IfStatement && (ifCase = ((IfStatement)inner).getHeadexprent().getCondition()) instanceof FunctionExprent) {
                FunctionExprent func = TryHelper.unwrapNegations((FunctionExprent)ifCase);
                if (func == null) {
                    return false;
                }
                Exprent check = func.getLstOperands().get(0);
                if (!(check instanceof VarExprent)) {
                    return false;
                }
                if (func.getLstOperands().get(1).getExprType().equals(VarType.VARTYPE_NULL)) {
                    Exprent first;
                    Statement inTry;
                    if ((inner = ((IfStatement)inner).getIfstat()) == null) {
                        return false;
                    }
                    if (inner instanceof CatchStatement && !inner.getStats().isEmpty() && (inTry = (Statement)inner.getStats().get(0)) instanceof BasicBlockStatement && inTry.getExprents() != null && !inTry.getExprents().isEmpty() && TryHelper.isCloseCall(first = inTry.getExprents().get(0), inTry, graph)) {
                        closeable = (VarExprent)((InvocationExprent)first).getInstance();
                        nullable = true;
                        if (!closeable.getVarVersion().equals(((VarExprent)check).getVarVersion())) {
                            closeable = null;
                        }
                    }
                }
            }
        }
        if (closeable == null) {
            return false;
        }
        Set<Statement> destinations = TryHelper.findExitpoints(tryStatement);
        if (destinations.isEmpty()) {
            return false;
        }
        List<Object> preds = new ArrayList();
        for (Statement check = tryStatement; check != null && preds.isEmpty(); check = check.getParent()) {
            preds = check.getPredecessorEdges(StatEdge.EdgeType.REGULAR);
        }
        if (preds.isEmpty()) {
            return false;
        }
        StatEdge edge = (StatEdge)preds.get(0);
        if (edge.getSource() instanceof BasicBlockStatement) {
            AssignmentExprent assignment = TryHelper.findResourceDef(closeable, edge.getSource());
            if (assignment == null) {
                return false;
            }
            for (Statement destination : destinations) {
                if (TryHelper.isValid(destination, closeable, graph, nullable)) continue;
                return false;
            }
            stack.add(new TryStatementJ11(destinations, closeable, nullable, assignment, edge, tryStatement));
            return true;
        }
        return false;
    }

    private static void makeTryStatementJ11(List<TryStatementJ11> tryStatements, DummyExitStatement exit) {
        if (tryStatements.isEmpty()) {
            return;
        }
        TryStatementJ11 tryStatementRecord = tryStatements.get(0);
        Set<Statement> destinations = tryStatementRecord.destinations();
        boolean nullable = tryStatementRecord.nullable();
        AssignmentExprent assignment = tryStatementRecord.assignment();
        StatEdge edge = tryStatementRecord.pred();
        CatchStatement tryStatement = tryStatementRecord.tryStatement();
        for (Statement destination : destinations) {
            TryHelper.removeTempAssignments(destination, tryStatements, exit);
        }
        for (Statement destination : destinations) {
            TryHelper.removeClose(destination, nullable, exit);
        }
        List<Exprent> exprents = edge.getSource().getExprents();
        if (exprents != null) {
            exprents.remove(assignment);
        }
        tryStatement.getResources().add(0, assignment);
        Statement remove = (Statement)tryStatement.getStats().get(1);
        SequenceHelper.destroyAndFlattenStatement(remove);
        tryStatement.getStats().remove(1);
        tryStatement.setTryType(CatchStatement.CatchStatementType.RESOURCES);
        tryStatements.remove(0);
    }

    private static boolean isValid(Statement stat, VarExprent closeable, ControlFlowGraph graph, boolean nullable) {
        Exprent inst;
        Exprent exprent;
        if (nullable) {
            IfStatement ifStat;
            Exprent condition;
            if (stat instanceof IfStatement && (condition = (ifStat = (IfStatement)stat).getHeadexprent().getCondition()) instanceof FunctionExprent) {
                FunctionExprent func = TryHelper.unwrapNegations((FunctionExprent)condition);
                if (func == null) {
                    return false;
                }
                if (func.getFuncType() == 43 && func.getLstOperands().get(0) instanceof VarExprent && func.getLstOperands().get(1).getExprType().equals(VarType.VARTYPE_NULL) && func.getLstOperands().get(0) instanceof VarExprent && ((VarExprent)func.getLstOperands().get(0)).getVarVersion().equals(closeable.getVarVersion())) {
                    return true;
                }
            }
        } else if (stat instanceof BasicBlockStatement && stat.getExprents() != null && !stat.getExprents().isEmpty() && (exprent = stat.getExprents().get(0)) instanceof InvocationExprent && (inst = ((InvocationExprent)exprent).getInstance()) instanceof VarExprent && inst.equals(closeable) && TryHelper.isCloseCall(exprent, stat, graph)) {
            return true;
        }
        return false;
    }

    private static void removeTempAssignments(Statement statement, List<TryStatementJ11> stack, DummyExitStatement exitStat) {
        Statement stat = statement;
        int exprentIndex = 0;
        boolean previousNonNullable = false;
        for (int i = stack.size() - 1; i >= 0; --i) {
            TryStatementJ11 tryStatement = stack.get(i);
            if (tryStatement.nullable()) {
                if (stat.getAllSuccessorEdges().size() != 1) continue;
                stat = stat.getAllSuccessorEdges().get(0).getDestination();
                exprentIndex = 0;
                if (!previousNonNullable) continue;
                if (stat.getAllSuccessorEdges().size() == 1) {
                    stat = stat.getAllSuccessorEdges().get(0).getDestination();
                }
                previousNonNullable = false;
                continue;
            }
            ++exprentIndex;
            previousNonNullable = true;
        }
        List<StatEdge> edges = stat.getAllPredecessorEdges();
        edges.removeIf(edge -> {
            CatchAllStatement catchAll;
            Statement patt15812$temp = edge.getSource();
            return patt15812$temp instanceof CatchAllStatement && (catchAll = (CatchAllStatement)patt15812$temp).isFinally();
        });
        if (exprentIndex == 0 && edges.size() > 2) {
            return;
        }
        ExitExprent exit = null;
        Runnable remove = null;
        if (stat.getExprents() != null && stat.getExprents().size() > exprentIndex) {
            Exprent exp = stat.getExprents().get(exprentIndex);
            if (exp.type == 4) {
                exit = (ExitExprent)exp;
                Statement finalStat = stat;
                int finalIndex = exprentIndex;
                remove = () -> {
                    finalStat.getExprents().remove(finalIndex);
                    if (finalStat.getExprents().isEmpty()) {
                        TryHelper.addEnd(finalStat, exitStat);
                    }
                };
            }
        }
        if (exit != null && exit.getValue() != null && exit.getValue().type == 12) {
            VarVersion returnVar = ((VarExprent)exit.getValue()).getVarVersion();
            if (!statement.getAllPredecessorEdges().isEmpty()) {
                StatEdge edge2 = statement.getAllPredecessorEdges().get(0);
                Statement ret = edge2.getSource();
                if (ret.type == Statement.StatementType.BASIC_BLOCK && ret.getExprents() != null && !ret.getExprents().isEmpty()) {
                    Exprent last = ret.getExprents().get(ret.getExprents().size() - 1);
                    if (last.type == 2) {
                        AssignmentExprent assignment = (AssignmentExprent)last;
                        if (assignment.getLeft().type == 12) {
                            VarVersion assigned = ((VarExprent)assignment.getLeft()).getVarVersion();
                            if (returnVar.var == assigned.var) {
                                exit.replaceExprent(exit.getValue(), assignment.getRight());
                                ret.getExprents().set(ret.getExprents().size() - 1, exit);
                                remove.run();
                            }
                        }
                    }
                }
            }
        }
    }

    private static void removeClose(Statement statement, boolean nullable, DummyExitStatement exit) {
        if (nullable) {
            List<StatEdge> edges = statement.getAllSuccessorEdges();
            if (!edges.isEmpty() && edges.get((int)0).closure == statement.getParent()) {
                SequenceHelper.destroyAndFlattenStatement(statement);
            } else {
                for (StatEdge edge : statement.getFirst().getAllSuccessorEdges()) {
                    edge.getDestination().removePredecessor(edge);
                }
                for (StatEdge edge : ((IfStatement)statement).getIfstat().getAllSuccessorEdges()) {
                    edge.getDestination().removePredecessor(edge);
                    if (edge.closure == null) continue;
                    edge.closure.getLabelEdges().remove(edge);
                }
                if (!statement.getNeighboursSet(StatEdge.EdgeType.ALL, StatEdge.EdgeDirection.FORWARD).contains(exit)) {
                    BasicBlockStatement newStat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
                    newStat.setExprents(new ArrayList<Exprent>());
                    statement.getParent().replaceStatement(statement, newStat);
                } else {
                    TryHelper.addEnd(statement, exit);
                }
            }
        } else {
            List<Exprent> exprents = statement.getExprents();
            if (exprents == null) {
                return;
            }
            exprents.remove(0);
            if (exprents.isEmpty() && statement.getNeighboursSet(StatEdge.EdgeType.ALL, StatEdge.EdgeDirection.FORWARD).contains(exit)) {
                TryHelper.addEnd(statement, exit);
            }
        }
    }

    private static Set<Statement> findExitpoints(Statement stat) {
        LinkedHashSet<StatEdge> edges = new LinkedHashSet<StatEdge>();
        TryHelper.findEdgesLeaving(stat.getFirst(), stat, edges);
        return edges.stream().map(StatEdge::getDestination).collect(Collectors.toSet());
    }

    private static void findEdgesLeaving(Statement curr, Statement check, Set<StatEdge> edges) {
        TryHelper.findEdgesLeaving(curr, check, edges, false);
    }

    public static void findEdgesLeaving(Statement curr, Statement check, Set<StatEdge> edges, boolean allowExit) {
        for (StatEdge edge : curr.getAllSuccessorEdges()) {
            if (check.containsStatement(edge.getDestination()) || !allowExit && edge.getDestination() instanceof DummyExitStatement) continue;
            edges.add(edge);
        }
        for (Statement stat : curr.getStats()) {
            TryHelper.findEdgesLeaving(stat, check, edges, allowExit);
        }
    }

    @Nullable
    private static FunctionExprent unwrapNegations(@NotNull FunctionExprent func) {
        Exprent expr;
        if (func == null) {
            TryHelper.$$$reportNull$$$0(0);
        }
        int count = 0;
        while (func.getFuncType() == 12 && (expr = func.getLstOperands().get(0)) instanceof FunctionExprent) {
            func = (FunctionExprent)expr;
            ++count;
        }
        if (count % 2 == 0) {
            return func;
        }
        return null;
    }

    private static boolean collapseTry(CatchStatement catchStat) {
        CatchStatement toRemove;
        Statement parent = catchStat;
        if (parent.getFirst() != null && parent.getFirst().type == Statement.StatementType.SEQUENCE) {
            parent = parent.getFirst();
        }
        if (parent != null && parent.getFirst() != null && parent.getFirst().type == Statement.StatementType.TRY_CATCH && (toRemove = (CatchStatement)parent.getFirst()).getTryType() == CatchStatement.CatchStatementType.RESOURCES) {
            catchStat.setTryType(CatchStatement.CatchStatementType.RESOURCES);
            catchStat.getResources().addAll(toRemove.getResources());
            catchStat.getVarDefinitions().addAll(toRemove.getVarDefinitions());
            parent.replaceStatement(toRemove, toRemove.getFirst());
            if (!toRemove.getVars().isEmpty()) {
                for (int i = 0; i < toRemove.getVars().size(); ++i) {
                    catchStat.getVars().add(i, toRemove.getVars().get(i));
                    catchStat.getExctStrings().add(i, toRemove.getExctStrings().get(i));
                    catchStat.getStats().add(i + 1, (Statement)catchStat.getStats().get(i + 1));
                }
            }
            return true;
        }
        return false;
    }

    private static boolean collapseTryJ11(CatchStatement stat) {
        boolean merged;
        if (stat.getStats().isEmpty()) {
            return false;
        }
        boolean ret = false;
        do {
            List<Exprent> resources;
            merged = false;
            Statement inner = (Statement)stat.getStats().get(0);
            if (!(inner instanceof CatchStatement) || (resources = ((CatchStatement)inner).getResources()).isEmpty() || inner.getStats().size() != 1) continue;
            stat.setTryType(CatchStatement.CatchStatementType.RESOURCES);
            stat.getResources().addAll(resources);
            stat.getVarDefinitions().addAll(inner.getVarDefinitions());
            Statement innerBlock = (Statement)inner.getStats().get(0);
            List<StatEdge> innerEdges = inner.getAllSuccessorEdges();
            for (StatEdge succ : innerBlock.getAllSuccessorEdges()) {
                boolean found = false;
                for (StatEdge innerEdge : innerEdges) {
                    if (succ.getDestination() != innerEdge.getDestination() || succ.getType() != innerEdge.getType()) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                innerBlock.removeSuccessor(succ);
            }
            stat.replaceStatement(inner, innerBlock);
            ret = true;
            merged = true;
        } while (merged);
        return ret;
    }

    private static AssignmentExprent findResourceDef(VarExprent var, Statement prevStatement) {
        List<Exprent> exprents = prevStatement.getExprents();
        if (exprents == null) {
            return null;
        }
        for (Exprent exp : exprents) {
            VarExprent left;
            if (exp.type != 2) continue;
            AssignmentExprent ass = (AssignmentExprent)exp;
            if (ass.getLeft().type != 12 || !(left = (VarExprent)ass.getLeft()).getVarVersion().equals(var.getVarVersion())) continue;
            return ass;
        }
        return null;
    }

    private static boolean isCloseCall(Exprent exp, Statement inTry, ControlFlowGraph graph) {
        InvocationExprent invocExp;
        if (exp.type == 8 && (invocExp = (InvocationExprent)exp).getName().equals("close") && invocExp.getStringDescriptor().equals("()V") && invocExp.getInstance() != null && invocExp.getInstance().type == 12) {
            if (inTry.type == Statement.StatementType.BASIC_BLOCK && inTry instanceof BasicBlockStatement) {
                BasicBlockStatement basicBlockStatement = (BasicBlockStatement)inTry;
                BasicBlock block = basicBlockStatement.getBlock();
                for (ExceptionRangeCFG exception : graph.getExceptions()) {
                    if (!exception.getProtectedRange().contains(block) || exception.getExceptionTypes() != null) continue;
                    return false;
                }
            }
            if (!DecompilerContext.getOption("cci")) {
                return true;
            }
            return DecompilerContext.getStructContext().instanceOf(invocExp.getClassName(), "java/lang/AutoCloseable");
        }
        return false;
    }

    private static void fixResourceAssignment(AssignmentExprent ass, Statement statement) {
        if (statement.getExprents() != null) {
            for (Exprent exp : statement.getExprents()) {
                if (exp.type != 2) continue;
                AssignmentExprent toRemove = (AssignmentExprent)exp;
                if (!ass.getLeft().equals(toRemove.getLeft()) || toRemove.getRight().getExprType().equals(VarType.VARTYPE_NULL)) continue;
                ass.setRight(toRemove.getRight());
                statement.getExprents().remove(toRemove);
                break;
            }
        }
    }

    private static void removeRedundantThrow(BasicBlockStatement initBlock, CatchStatement catchStat) {
        if (catchStat.getStats().size() > 1) {
            AssignmentExprent assignmentExp;
            boolean removed = false;
            Statement temp = null;
            for (int i = 1; i < catchStat.getStats().size(); ++i) {
                ExitExprent exitExprent;
                temp = (Statement)catchStat.getStats().get(i);
                if (temp.type != Statement.StatementType.BASIC_BLOCK || temp.getExprents() == null || temp.getExprents().size() < 2 || !catchStat.getVars().get(i - 1).getVarType().getValue().equals("java/lang/Throwable") || temp.getExprents().get((int)(temp.getExprents().size() - 1)).type != 4 || (exitExprent = (ExitExprent)temp.getExprents().get(temp.getExprents().size() - 1)).getExitType() != 1 || !exitExprent.getValue().equals(catchStat.getVars().get(i - 1))) continue;
                catchStat.getExctStrings().remove(i - 1);
                catchStat.getVars().remove(i - 1);
                catchStat.getStats().remove(i);
                for (StatEdge edge : temp.getAllPredecessorEdges()) {
                    edge.getSource().removeSuccessor(edge);
                }
                for (StatEdge edge : temp.getAllSuccessorEdges()) {
                    edge.getDestination().removePredecessor(edge);
                }
                removed = true;
                break;
            }
            if (removed && temp.getExprents().get((int)(temp.getExprents().size() - 2)).type == 2 && (assignmentExp = (AssignmentExprent)temp.getExprents().get(temp.getExprents().size() - 2)).getLeft().getExprType().getValue().equals("java/lang/Throwable")) {
                List<Exprent> exprents = initBlock.getExprents();
                if (exprents == null) {
                    return;
                }
                for (Exprent exprent : exprents) {
                    AssignmentExprent toRemove;
                    if (exprent.type != 2 || !(toRemove = (AssignmentExprent)exprent).getLeft().equals(assignmentExp.getLeft())) continue;
                    initBlock.getExprents().remove(toRemove);
                    return;
                }
            }
        }
    }

    private static void addEnd(Statement stat, DummyExitStatement exit) {
        for (StatEdge edge : stat.getAllPredecessorEdges()) {
            edge.getSource().changeEdgeNode(StatEdge.EdgeDirection.FORWARD, edge, exit);
            exit.addPredecessor(edge);
            if (edge.closure == null) continue;
            edge.closure.getLabelEdges().remove(edge);
        }
        for (StatEdge edge : stat.getAllSuccessorEdges()) {
            edge.getDestination().removePredecessor(edge);
        }
        stat.getParent().getStats().removeWithKey(stat.id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "func", "org/jetbrains/java/decompiler/modules/decompiler/TryHelper", "unwrapNegations"));
    }

    public record TryStatementJ11(Set<Statement> destinations, VarExprent closeable, boolean nullable, AssignmentExprent assignment, StatEdge pred, CatchStatement tryStatement) {
    }
}

