/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class GenericUnpairedQuotesRule
extends TextLevelRule {
    private static final Pattern POSSIBLE_APOSTROPHE = Pattern.compile("[\u2018\u2019']");
    private static final Pattern INCH_PATTERN = Pattern.compile(".*\\d\".*", 32);
    private static final Pattern PUNCTUATION = Pattern.compile("[\\p{Punct}\u2026\u2013\u2014&&[^\"'_]]");
    private static final Pattern PUNCT_MARKS = Pattern.compile("[\\?\\.!,]");
    private final List<String> startSymbols;
    private final List<String> endSymbols;
    private final String ruleId;

    public GenericUnpairedQuotesRule(String ruleId, ResourceBundle messages, List<String> startSymbols, List<String> endSymbols) {
        super(messages);
        this.ruleId = ruleId != null ? ruleId : "UNPAIRED_QUOTES";
        super.setCategory(Categories.PUNCTUATION.getCategory(messages));
        if (startSymbols.size() != endSymbols.size()) {
            throw new IllegalArgumentException("Different number of start and end symbols: " + startSymbols + " vs. " + endSymbols);
        }
        this.startSymbols = startSymbols;
        this.endSymbols = endSymbols;
        this.setLocQualityIssueType(ITSIssueType.Typographical);
    }

    public GenericUnpairedQuotesRule(ResourceBundle messages, List<String> startSymbols, List<String> endSymbols) {
        this(null, messages, startSymbols, endSymbols);
    }

    public GenericUnpairedQuotesRule(ResourceBundle messages) {
        this(null, messages, Arrays.asList("\u201c", "\"", "\u2018", "'"), Arrays.asList("\u201d", "\"", "\u2019", "'"));
    }

    @Override
    public String getId() {
        return this.ruleId;
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_unpaired_quotes");
    }

    @Override
    public final RuleMatch[] match(List<AnalyzedSentence> sentences) {
        ArrayList<SymbolLocator> openingQuotes = new ArrayList<SymbolLocator>();
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        String lastApostropheSymbol = null;
        boolean wasInch = false;
        int startPosBase = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            for (int i = 1; i < tokens.length; ++i) {
                String symbol;
                if (this.isOpeningQuote(tokens, i)) {
                    int index;
                    symbol = tokens[i].getToken();
                    if (!this.isNotBeginningApostrophe(tokens, i)) {
                        lastApostropheSymbol = symbol;
                        continue;
                    }
                    if ("\"".equals(symbol)) {
                        wasInch = false;
                    }
                    if (lastApostropheSymbol != null && lastApostropheSymbol.equals(symbol)) {
                        lastApostropheSymbol = null;
                    }
                    if ((index = this.indexOfOpeningQuote(openingQuotes, symbol)) >= 0) {
                        this.removeAllOpenInnerQuotes(index - 1, openingQuotes, ruleMatches);
                    }
                    openingQuotes.add(new SymbolLocator(symbol, tokens[i].getStartPos() + startPosBase, sentence));
                    continue;
                }
                if (!this.isClosingQuote(tokens, i, openingQuotes)) continue;
                symbol = tokens[i].getToken();
                if (!this.isNotBeginningApostrophe(tokens, i)) {
                    lastApostropheSymbol = symbol;
                    continue;
                }
                boolean isInchSymb = "\"".equals(symbol);
                boolean isInch = isInchSymb ? this.isInchQuote(sentence.getText()) : false;
                String startSymbol = this.findCorrespondingSymbol(symbol);
                int index = this.indexOfOpeningQuote(openingQuotes, startSymbol);
                if (index >= 0) {
                    this.removeAllOpenInnerQuotes(index, openingQuotes, ruleMatches);
                    openingQuotes.remove(index);
                    if (lastApostropheSymbol != null && lastApostropheSymbol.equals(startSymbol)) {
                        lastApostropheSymbol = null;
                    }
                    if (!isInch) continue;
                    wasInch = true;
                    continue;
                }
                if (!this.isNotEndingApostrophe(tokens, i)) continue;
                if (!(isInch || isInchSymb && wasInch)) {
                    if (lastApostropheSymbol == null || !lastApostropheSymbol.equals(symbol)) {
                        this.addMatch(new SymbolLocator(symbol, tokens[i].getStartPos() + startPosBase, sentence), ruleMatches);
                        continue;
                    }
                    lastApostropheSymbol = null;
                    continue;
                }
                wasInch = false;
            }
            startPosBase += sentence.getCorrectedTextLength();
        }
        this.removeAllOpenInnerQuotes(-1, openingQuotes, ruleMatches);
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isStartSymbolbefore(AnalyzedTokenReadings[] tokens, int i) {
        for (int j = i - 1; j > 0; --j) {
            if (!tokens[i].getToken().equals(tokens[j].getToken()) && this.startSymbols.contains(tokens[j].getToken())) {
                if (!tokens[j - 1].isSentenceStart() && !tokens[j].isWhitespaceBefore()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isNotOpenSymbol(int j, List<SymbolLocator> openingQuotes) {
        if (this.endSymbols.get(j).equals(this.startSymbols.get(j))) {
            for (SymbolLocator openingQuote : openingQuotes) {
                if (!this.endSymbols.get(j).equals(openingQuote.getSymbol())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isNotQuote(AnalyzedTokenReadings[] tokens, int i, int j) {
        if ((tokens[i - 1].isSentenceStart() || tokens[i].isWhitespaceBefore()) && (i >= tokens.length - 1 || tokens[i + 1].isWhitespaceBefore())) {
            return true;
        }
        return this.endSymbols.get(j).equals(this.startSymbols.get(j)) && i < tokens.length - 1 && !tokens[i].isWhitespaceBefore() && !tokens[i + 1].isWhitespaceBefore() && PUNCTUATION.matcher(tokens[i - 1].getToken()).matches() && !".".equals(tokens[i + 1].getToken()) && PUNCTUATION.matcher(tokens[i + 1].getToken()).matches();
    }

    private boolean isOpeningQuote(AnalyzedTokenReadings[] tokens, int i) {
        for (int j = 0; j < this.startSymbols.size(); ++j) {
            if (!this.startSymbols.get(j).equals(tokens[i].getToken())) continue;
            if (this.isNotQuote(tokens, i, j)) {
                return false;
            }
            if (this.endSymbols.contains(this.startSymbols.get(j))) {
                return tokens[i - 1].isSentenceStart() || tokens[i].isWhitespaceBefore() || i < tokens.length - 1 && !tokens[i + 1].isWhitespaceBefore() && (!PUNCT_MARKS.matcher(tokens[i + 1].getToken()).matches() && PUNCTUATION.matcher(tokens[i - 1].getToken()).matches() || tokens[i - 1].getToken().endsWith("-")) || this.isStartSymbolbefore(tokens, i);
            }
            return true;
        }
        return false;
    }

    private boolean isClosingQuote(AnalyzedTokenReadings[] tokens, int i, List<SymbolLocator> openingQuotes) {
        for (int j = 0; j < this.endSymbols.size(); ++j) {
            if (!this.endSymbols.get(j).equals(tokens[i].getToken())) continue;
            return !this.isNotQuote(tokens, i, j) || !this.isNotOpenSymbol(j, openingQuotes);
        }
        return false;
    }

    private boolean isInchQuote(String text) {
        return INCH_PATTERN.matcher(text).matches();
    }

    protected boolean isNotBeginningApostrophe(AnalyzedTokenReadings[] tokens, int i) {
        return !POSSIBLE_APOSTROPHE.matcher(tokens[i].getToken()).matches() || i >= tokens.length - 1 || tokens[i + 1].isNonWord() || tokens[i + 1].isWhitespaceBefore();
    }

    protected boolean isNotEndingApostrophe(AnalyzedTokenReadings[] tokens, int i) {
        return !POSSIBLE_APOSTROPHE.matcher(tokens[i].getToken()).matches() || tokens[i].isWhitespaceBefore() || tokens[i - 1].isNonWord();
    }

    private int indexOfOpeningQuote(List<SymbolLocator> openingQuotes, String symbol) {
        for (int i = 0; i < openingQuotes.size(); ++i) {
            if (!symbol.equals(openingQuotes.get(i).getSymbol())) continue;
            return i;
        }
        return -1;
    }

    private void addMatch(SymbolLocator openingQuote, List<RuleMatch> ruleMatches) {
        String message = MessageFormat.format(this.messages.getString("unpaired_brackets"), this.findCorrespondingSymbol(openingQuote.getSymbol()));
        RuleMatch match = new RuleMatch(this, openingQuote.getSentence(), openingQuote.getStartPos(), openingQuote.getStartPos() + openingQuote.getSymbol().length(), message);
        ruleMatches.add(match);
    }

    private void removeAllOpenInnerQuotes(int index, List<SymbolLocator> openingQuotes, List<RuleMatch> ruleMatches) {
        for (int i = openingQuotes.size() - 1; i > index; --i) {
            this.addMatch(openingQuotes.get(i), ruleMatches);
            openingQuotes.remove(i);
        }
    }

    protected String findCorrespondingSymbol(String symbol) {
        int idx1 = this.startSymbols.indexOf(symbol);
        if (idx1 >= 0) {
            return this.endSymbols.get(idx1);
        }
        int idx2 = this.endSymbols.indexOf(symbol);
        return this.startSymbols.get(idx2);
    }

    @Override
    public int minToCheckParagraph() {
        return -1;
    }

    protected class SymbolLocator {
        private final String symbol;
        private final int startPos;
        private final AnalyzedSentence sentence;

        SymbolLocator(String symbol, int startPos, AnalyzedSentence sentence) {
            this.symbol = symbol;
            this.startPos = startPos;
            this.sentence = sentence;
        }

        public String getSymbol() {
            return this.symbol;
        }

        int getStartPos() {
            return this.startPos;
        }

        AnalyzedSentence getSentence() {
            return this.sentence;
        }
    }
}

