/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.RemoteRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RemoteRuleResult;
import org.languagetool.rules.RuleMatch;

public class TestRemoteRule
extends RemoteRule {
    private long waitTime;

    public TestRemoteRule(Language lang, RemoteRuleConfig config) {
        super(lang, JLanguageTool.getMessageBundle(), config, false);
        this.waitTime = Long.parseLong(config.getOptions().getOrDefault("waitTime", "1"));
    }

    @Override
    protected RemoteRule.RemoteRequest prepareRequest(List<AnalyzedSentence> sentences, Long textSessionId) {
        return new TestRemoteRequest(sentences);
    }

    private RuleMatch testMatch(AnalyzedSentence s) {
        return new RuleMatch(this, s, 0, 1, "Test match");
    }

    @Override
    protected Callable<RemoteRuleResult> executeRequest(RemoteRule.RemoteRequest request, long timeoutMilliseconds) throws TimeoutException {
        return () -> {
            TestRemoteRequest req = (TestRemoteRequest)request;
            List<RuleMatch> matches = req.sentences.stream().map(this::testMatch).collect(Collectors.toList());
            long deadline = System.currentTimeMillis() + this.waitTime;
            Thread.sleep(this.waitTime);
            return new RemoteRuleResult(true, true, matches, req.sentences);
        };
    }

    @Override
    protected RemoteRuleResult fallbackResults(RemoteRule.RemoteRequest request) {
        TestRemoteRequest req = (TestRemoteRequest)request;
        return new RemoteRuleResult(false, false, Collections.emptyList(), req.sentences);
    }

    @Override
    public String getDescription() {
        return "TEST REMOTE RULE";
    }

    class TestRemoteRequest
    extends RemoteRule.RemoteRequest {
        private final List<AnalyzedSentence> sentences;

        TestRemoteRequest(List<AnalyzedSentence> sentences) {
            this.sentences = sentences;
        }
    }
}

