/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.packages.KotlinPackageProviderFactoryKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0000H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KtPackage;", "Lcom/intellij/psi/impl/file/PsiPackageImpl;", "manager", "Lcom/intellij/psi/PsiManager;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lcom/intellij/psi/PsiManager;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/search/GlobalSearchScope;)V", "copy", "isValid", "", "analysis-api-fir"})
final class KtPackage
extends PsiPackageImpl {
    @NotNull
    private final FqName fqName;
    @NotNull
    private final GlobalSearchScope scope;

    public KtPackage(@NotNull PsiManager manager, @NotNull FqName fqName, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(manager, StringsKt.replace$default((String)fqName.asString(), (char)'/', (char)'.', (boolean)false, (int)4, null));
        this.fqName = fqName;
        this.scope = scope;
    }

    @NotNull
    public KtPackage copy() {
        PsiManager psiManager = this.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getManager(...)");
        return new KtPackage(psiManager, this.fqName, this.scope);
    }

    public boolean isValid() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return KotlinPackageProviderFactoryKt.createPackageProvider(project, this.scope).doesKotlinOnlyPackageExist(this.fqName);
    }
}

