/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javajs.util.BS;
import org.jmol.i18n.GT;
import org.jmol.shape.Shape;
import org.jmol.util.Font;
import org.jmol.viewer.Viewer;

public class Frank
extends Shape {
    static final String defaultFontName = "SansSerif";
    static final String defaultFontStyle = "Plain";
    static final int defaultFontSize = 16;
    public static final int frankMargin = 4;
    public static String frankString = "Jmol";
    Font currentMetricsFont3d;
    public Font baseFont3d;
    public int frankWidth;
    public int frankAscent;
    public int frankDescent;
    int x;
    int y;
    int dx;
    int dy;
    private float scaling;
    public Font font3d;

    @Override
    public void initShape() {
        this.myType = "frank";
        this.baseFont3d = this.font3d = this.vwr.gdata.getFont3DFSS(defaultFontName, defaultFontStyle, 16.0f);
        if (Viewer.isJS || Viewer.isSwingJS) {
            frankString = "JSmol";
        }
        this.calcMetrics();
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        if ("font" == propertyName) {
            Font f = (Font)value;
            if (f.fontSize >= 10.0f) {
                this.baseFont3d = f;
                this.scaling = 0.0f;
            }
        }
    }

    @Override
    public boolean wasClicked(int x, int y) {
        int width = this.vwr.getScreenWidth();
        int height = this.vwr.getScreenHeight();
        return width > 0 && height > 0 && x > width - this.frankWidth - 4 && y > height - this.frankAscent - 4;
    }

    @Override
    public boolean checkObjectHovered(int x, int y, BS bsVisible) {
        if (!(this.vwr.getShowFrank() && this.wasClicked(x, y) && this.vwr.menuEnabled())) {
            return false;
        }
        this.vwr.hoverOnPt(x, y, GT.$("Click for menu..."), null, null);
        return true;
    }

    void calcMetrics() {
        if (this.font3d == this.currentMetricsFont3d) {
            return;
        }
        this.currentMetricsFont3d = this.font3d;
        this.frankWidth = this.font3d.stringWidth(frankString);
        this.frankDescent = this.font3d.getDescent();
        this.frankAscent = this.font3d.getAscent();
    }

    public void getFont(float imageFontScaling) {
        if (imageFontScaling != this.scaling) {
            this.scaling = imageFontScaling;
            this.font3d = this.vwr.gdata.getFont3DScaled(this.baseFont3d, imageFontScaling);
            this.calcMetrics();
        }
    }

    @Override
    public String getShapeState() {
        return null;
    }
}

