/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Map;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDragSourceProtocolListener;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XErrorHandlerUtil;
import sun.awt.X11.XException;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;

abstract class XDragSourceProtocol {
    private final XDragSourceProtocolListener listener;
    private boolean initialized = false;
    private long targetWindow = 0L;
    private long targetProxyWindow = 0L;
    private int targetProtocolVersion = 0;
    private long targetWindowMask = 0L;

    static long getDragSourceWindow() {
        return XWindow.getXAWTRootWindow().getWindow();
    }

    protected XDragSourceProtocol(XDragSourceProtocolListener xDragSourceProtocolListener) {
        if (xDragSourceProtocolListener == null) {
            throw new NullPointerException("Null XDragSourceProtocolListener");
        }
        this.listener = xDragSourceProtocolListener;
    }

    protected final XDragSourceProtocolListener getProtocolListener() {
        return this.listener;
    }

    public abstract String getProtocolName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initializeDrag(int n, Transferable transferable, Map map, long[] lArray) throws InvalidDnDOperationException, IllegalArgumentException, XException {
        XToolkit.awtLock();
        try {
            try {
                if (this.initialized) {
                    throw new InvalidDnDOperationException("Already initialized");
                }
                this.initializeDragImpl(n, transferable, map, lArray);
                this.initialized = true;
            }
            finally {
                if (!this.initialized) {
                    this.cleanup();
                }
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    protected abstract void initializeDragImpl(int var1, Transferable var2, Map var3, long[] var4) throws InvalidDnDOperationException, IllegalArgumentException, XException;

    public void cleanup() {
        this.initialized = false;
        this.cleanupTargetInfo();
    }

    public void cleanupTargetInfo() {
        this.targetWindow = 0L;
        this.targetProxyWindow = 0L;
        this.targetProtocolVersion = 0;
    }

    public abstract boolean processClientMessage(XClientMessageEvent var1) throws XException;

    public final boolean attachTargetWindow(long l, long l2) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        TargetWindowInfo targetWindowInfo = this.getTargetWindowInfo(l);
        if (targetWindowInfo == null) {
            return false;
        }
        this.targetWindow = l;
        this.targetProxyWindow = targetWindowInfo.getProxyWindow();
        this.targetProtocolVersion = targetWindowInfo.getProtocolVersion();
        return true;
    }

    public abstract TargetWindowInfo getTargetWindowInfo(long var1);

    public abstract void sendEnterMessage(long[] var1, int var2, int var3, long var4);

    public abstract void sendMoveMessage(int var1, int var2, int var3, int var4, long var5);

    public abstract void sendLeaveMessage(long var1);

    protected abstract void sendDropMessage(int var1, int var2, int var3, int var4, long var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initiateDrop(int n, int n2, int n3, int n4, long l) {
        XWindowAttributes xWindowAttributes = new XWindowAttributes();
        try {
            XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
            int n5 = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), this.targetWindow, xWindowAttributes.pData);
            XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
            if (n5 == 0 || XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
                throw new XException("XGetWindowAttributes failed");
            }
            this.targetWindowMask = xWindowAttributes.get_your_event_mask();
        }
        finally {
            xWindowAttributes.dispose();
        }
        XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
        XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.targetWindow, this.targetWindowMask | 0x20000L);
        XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
        if (XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
            throw new XException("XSelectInput failed");
        }
        this.sendDropMessage(n, n2, n3, n4, l);
    }

    protected final void finalizeDrop() {
        XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
        XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.targetWindow, this.targetWindowMask);
        XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
    }

    public abstract boolean processProxyModeEvent(XClientMessageEvent var1, long var2);

    protected final long getTargetWindow() {
        return this.targetWindow;
    }

    protected final long getTargetProxyWindow() {
        if (this.targetProxyWindow != 0L) {
            return this.targetProxyWindow;
        }
        return this.targetWindow;
    }

    protected final int getTargetProtocolVersion() {
        return this.targetProtocolVersion;
    }

    public static class TargetWindowInfo {
        private final long proxyWindow;
        private final int protocolVersion;

        public TargetWindowInfo(long l, int n) {
            this.proxyWindow = l;
            this.protocolVersion = n;
        }

        public long getProxyWindow() {
            return this.proxyWindow;
        }

        public int getProtocolVersion() {
            return this.protocolVersion;
        }
    }
}

