/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import org.jsampler.CC;
import org.jsampler.JSUtils;
import org.jsampler.view.JSViews;

public class JSampler {
    public static final String NAME = "JSampler";
    public static final String VERSION = "0.9";
    public static String[] scripts;

    public static void main(String[] stringArray) {
        scripts = stringArray;
        CC.initJSampler();
        JSampler.initGUI();
    }

    public static void open(String string) {
        CC.getLogger().warning(string);
        if (string == null) {
            return;
        }
        if (CC.getClient().isConnected()) {
            CC.getMainFrame().runScript(string);
            return;
        }
        if (scripts == null) {
            scripts = new String[1];
            JSampler.scripts[0] = string;
            CC.addConnectionEstablishedListener(new ConnectionEstablishedListener());
        } else {
            String[] stringArray = new String[scripts.length + 1];
            for (int i = 0; i < scripts.length; ++i) {
                stringArray[i] = scripts[i];
            }
            stringArray[stringArray.length - 1] = string;
            scripts = stringArray;
        }
    }

    private static void initGUI() {
        JSViews.parseManifest();
        JSViews.setView(JSViews.getDefaultView());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JSampler.initGUI0();
            }
        });
    }

    private static void initGUI0() {
        if (scripts != null) {
            CC.addConnectionEstablishedListener(new ConnectionEstablishedListener());
        }
        JSUtils.checkJSamplerHome();
        CC.loadOrchestras();
        CC.loadServerList();
        CC.connect();
    }

    private static class ConnectionEstablishedListener
    implements ActionListener,
    Runnable {
        private ConnectionEstablishedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (scripts == null) {
                return;
            }
            for (String string : scripts) {
                CC.getMainFrame().runScript(string);
            }
            scripts = null;
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            CC.removeConnectionEstablishedListener(this);
        }
    }
}

