/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.server.AbstractFetcherThread;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.OffsetTruncationState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001B\f\u0019\u0001uA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\na\u0001\u0011\t\u0011)A\u0005cmB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011!a\u0005A!A!\u0002\u0013\u0019\u0003\"B'\u0001\t\u0003q\u0005\u0002C,\u0001\u0005\u0004%\t\u0001\u0007-\t\r\u001d\u0004\u0001\u0015!\u0003Z\u0011\u0015A\u0007\u0001\"\u0015j\u0011\u0015Q\b\u0001\"\u0015|\u0011\u001d\t\u0019\u0001\u0001C)\u0003\u000bAq!!\u0003\u0001\t#\nY\u0001C\u0004\u0002&\u0001!\t%a\n\t\u000f\u0005=\u0002\u0001\"\u0011\u00022!9\u0011\u0011\b\u0001\u0005B\u0005E\u0002bBA\u001e\u0001\u0011\u0005\u0013Q\b\u0005\b\u0003_\u0002A\u0011BA\u0019\u0011\u001d\t\t\b\u0001C!\u0003gBq!a!\u0001\t#\n)\tC\u0007\u0002\u000e\u0002\u0001\n1!A\u0001\n\u0013\tyi\u000f\u0002\u0015%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193\u000b\u0005eQ\u0012AB:feZ,'OC\u0001\u001c\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\u0001S\"\u0001\r\n\u0005\u0005B\"!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0001\u0005]\u0006lW\r\u0005\u0002%[9\u0011Qe\u000b\t\u0003M%j\u0011a\n\u0006\u0003Qq\ta\u0001\u0010:p_Rt$\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J\u0013A\u0002)sK\u0012,g-\u0003\u0002/_\t11\u000b\u001e:j]\u001eT!\u0001L\u0015\u0002\r1,\u0017\rZ3s!\t\u0011\u0014(D\u00014\u0015\tIBG\u0003\u0002\u001ck)\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h\u0013\tQ4G\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\n\u0005A\u0002\u0013\u0001\u00042s_.,'oQ8oM&<\u0007CA\u0010?\u0013\ty\u0004DA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t!\ty\")\u0003\u0002D1\t\u0001b)Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u000be\u0016\u0004H.[2b\u001b\u001e\u0014\bCA\u0010G\u0013\t9\u0005D\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000bE,x\u000e^1\u0011\u0005}Q\u0015BA&\u0019\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u0003%awn\u001a)sK\u001aL\u00070\u0001\u0004=S:LGO\u0010\u000b\t\u001fB\u000b&k\u0015+V-B\u0011q\u0004\u0001\u0005\u0006E!\u0001\ra\t\u0005\u0006a!\u0001\r!\r\u0005\u0006y!\u0001\r!\u0010\u0005\u0006\u0001\"\u0001\r!\u0011\u0005\u0006\t\"\u0001\r!\u0012\u0005\u0006\u0011\"\u0001\r!\u0013\u0005\u0006\u0019\"\u0001\raI\u0001\u001fa\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u001d\u0016<\b*[4i/\u0006$XM]7be.,\u0012!\u0017\t\u00045~\u000bW\"A.\u000b\u0005qk\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003=&\n!bY8mY\u0016\u001cG/[8o\u0013\t\u00017L\u0001\u0004Ck\u001a4WM\u001d\t\u0003E\u0016l\u0011a\u0019\u0006\u0003IR\naaY8n[>t\u0017B\u00014d\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0004]1si&$\u0018n\u001c8t/&$\bNT3x\u0011&<\u0007nV1uKJl\u0017M]6!\u0003-a\u0017\r^3ti\u0016\u0003xn\u00195\u0015\u0005)D\bcA6qe6\tAN\u0003\u0002n]\u0006!Q\u000f^5m\u0015\u0005y\u0017\u0001\u00026bm\u0006L!!\u001d7\u0003\u0011=\u0003H/[8oC2\u0004\"a\u001d<\u000e\u0003QT!!\u001e8\u0002\t1\fgnZ\u0005\u0003oR\u0014q!\u00138uK\u001e,'\u000fC\u0003z\u0017\u0001\u0007\u0011-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002\u001d1|wm\u0015;beR|eMZ:fiR\u0019A0!\u0001\u0011\u0005utX\"A\u0015\n\u0005}L#\u0001\u0002'p]\u001eDQ!\u001f\u0007A\u0002\u0005\fA\u0002\\8h\u000b:$wJ\u001a4tKR$2\u0001`A\u0004\u0011\u0015IX\u00021\u0001b\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0007\u0003\u001b\tI\"a\u0007\u0011\t-\u0004\u0018q\u0002\t\u0005\u0003#\t)\"\u0004\u0002\u0002\u0014)\u0011AmM\u0005\u0005\u0003/\t\u0019B\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\u000bet\u0001\u0019A1\t\u000f\u0005ua\u00021\u0001\u0002 \u0005)Q\r]8dQB\u0019Q0!\t\n\u0007\u0005\r\u0012FA\u0002J]R\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0015\u0005\u0005%\u0002cA?\u0002,%\u0019\u0011QF\u0015\u0003\u000f\t{w\u000e\\3b]\u0006i\u0011m^1jiNCW\u000f\u001e3po:$\"!a\r\u0011\u0007u\f)$C\u0002\u00028%\u0012A!\u00168ji\u00061Am\\,pe.\fA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fGCCA \u00033\nY&a\u0018\u0002dA)Q0!\u0011\u0002F%\u0019\u00111I\u0015\u0003\r=\u0003H/[8o!\u0011\t9%!\u0016\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\n1\u0001\\8h\u0015\u0011\ty%!\u0015\u0002\u0013%tG/\u001a:oC2\u001c(bAA*i\u000591\u000f^8sC\u001e,\u0017\u0002BA,\u0003\u0013\u0012Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007\"B=\u0013\u0001\u0004\t\u0007BBA/%\u0001\u0007A0A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bbBA1%\u0001\u0007\u0011qD\u0001\u0015a\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016\u0003xn\u00195\t\u000f\u0005\u0015$\u00031\u0001\u0002h\u0005i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004B!!\u001b\u0002l5\t\u0001!C\u0002\u0002n\u0001\u0012\u0011BR3uG\"$\u0015\r^1\u00029\r|W\u000e\u001d7fi\u0016$U\r\\1zK\u00124U\r^2i%\u0016\fX/Z:ug\u0006AAO];oG\u0006$X\r\u0006\u0004\u00024\u0005U\u0014\u0011\u0010\u0005\u0007\u0003o\"\u0002\u0019A1\u0002\u0005Q\u0004\bbBA>)\u0001\u0007\u0011QP\u0001\u0016_\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f!\ry\u0012qP\u0005\u0004\u0003\u0003C\"!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/Z\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$b!a\r\u0002\b\u0006%\u0005\"B=\u0016\u0001\u0004\t\u0007BBAF+\u0001\u0007A0\u0001\u0004pM\u001a\u001cX\r^\u0001\rgV\u0004XM\u001d\u0013mK\u0006$WM]\u000b\u0002c\u0001")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final ReplicaQuota quota;
    private final Buffer<TopicPartition> partitionsWithNewHighWatermark;

    private /* synthetic */ LeaderEndPoint super$leader() {
        return super.leader();
    }

    public Buffer<TopicPartition> partitionsWithNewHighWatermark() {
        return this.partitionsWithNewHighWatermark;
    }

    @Override
    public Optional<Integer> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Optional<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    public boolean initiateShutdown() {
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                super.leader().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to initiate shutdown of " + this.super$leader() + " after initiating replica fetcher thread shutdown", (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        }
        return justShutdown;
    }

    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            super.leader().close();
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to close " + this.super$leader() + " after shutting down replica fetcher thread", (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    @Override
    public void doWork() {
        super.doWork();
        this.completeDelayedFetchRequests();
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
        boolean logTrace = this.isTraceEnabled();
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        UnifiedLog log = partition.localLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != log.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)log.logEndOffset())})));
        }
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d bytes of messages and leader hw %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData.highWatermark())})));
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false, partitionLeaderEpoch);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition})));
        }
        long leaderLogStartOffset = partitionData.logStartOffset();
        ObjectRef maybeUpdateHighWatermarkMessage = ObjectRef.create((Object)"but did not update replica high watermark");
        log.maybeUpdateHighWatermark(partitionData.highWatermark()).ifPresent(newHighWatermark -> {
            maybeUpdateHighWatermarkMessage$1.elem = "and updated replica high watermark to " + newHighWatermark;
            this.partitionsWithNewHighWatermark().$plus$eq((Object)topicPartition);
        });
        log.maybeIncrementLogStartOffset(leaderLogStartOffset, LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "Follower received high watermark " + partitionData.highWatermark() + " from the leader " + (String)maybeUpdateHighWatermarkMessage$1.elem + " for partition " + topicPartition);
        }
        if (this.quota.isThrottled(topicPartition)) {
            this.quota.record(records.sizeInBytes());
        }
        if (partition.isReassigning() && partition.isAddingLocalReplica()) {
            this.brokerTopicStats().updateReassignmentBytesIn((long)records.sizeInBytes());
        }
        this.brokerTopicStats().updateReplicationBytesIn((long)records.sizeInBytes());
        return logAppendInfo;
    }

    private void completeDelayedFetchRequests() {
        if (this.partitionsWithNewHighWatermark().nonEmpty()) {
            this.replicaMgr.completeDelayedFetchRequests((Seq<TopicPartition>)this.partitionsWithNewHighWatermark().toSeq());
            this.partitionsWithNewHighWatermark().clear();
            return;
        }
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(tp);
        UnifiedLog log = partition.localLogOrException();
        partition.truncateTo(offsetTruncationState.offset(), false);
        if (offsetTruncationState.offset() < log.highWatermark()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Truncating " + tp + " to offset " + offsetTruncationState.offset() + " below high watermark " + log.highWatermark());
        }
        if (offsetTruncationState.truncationCompleted()) {
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
            return;
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, false, partition.truncateFullyAndStartAt$default$3());
    }

    public ReplicaFetcherThread(String name, LeaderEndPoint leader, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, String logPrefix) {
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, leader, failedPartitions, new TierStateMachine(leader, replicaMgr, false), Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, replicaMgr.brokerTopicStats());
        this.logIdent_$eq(logPrefix);
        this.partitionsWithNewHighWatermark = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }
}

