/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Map;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.MetadataVersion;

public enum ShareVersion implements FeatureVersion
{
    SV_0(0, MetadataVersion.MINIMUM_VERSION, Map.of()),
    SV_1(1, MetadataVersion.IBP_4_2_IV0, Map.of());

    public static final String FEATURE_NAME = "share.version";
    public static final ShareVersion LATEST_PRODUCTION;
    private final short featureLevel;
    private final MetadataVersion bootstrapMetadataVersion;
    private final Map<String, Short> dependencies;

    private ShareVersion(int featureLevel, MetadataVersion bootstrapMetadataVersion, Map<String, Short> dependencies) {
        this.featureLevel = (short)featureLevel;
        this.bootstrapMetadataVersion = bootstrapMetadataVersion;
        this.dependencies = dependencies;
    }

    @Override
    public short featureLevel() {
        return this.featureLevel;
    }

    @Override
    public String featureName() {
        return FEATURE_NAME;
    }

    @Override
    public MetadataVersion bootstrapMetadataVersion() {
        return this.bootstrapMetadataVersion;
    }

    @Override
    public Map<String, Short> dependencies() {
        return this.dependencies;
    }

    public boolean supportsShareGroups() {
        return this.featureLevel >= ShareVersion.SV_1.featureLevel;
    }

    public static ShareVersion fromFeatureLevel(short version) {
        switch (version) {
            case 0: {
                return SV_0;
            }
            case 1: {
                return SV_1;
            }
        }
        throw new RuntimeException("Unknown share feature level: " + version);
    }

    static {
        LATEST_PRODUCTION = SV_1;
    }
}

